/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.source;

import com.macrofocus.application.ApplicationModel;
import com.macrofocus.data.source.FileURLDataSource;
import com.macrofocus.data.source.LipperDataSource;
import com.macrofocus.data.table.ZipTableModel;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.table.TableModel;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;

public class ZipDataSource
extends FileURLDataSource {
    static final String type = "Zip";
    private boolean isLipper = false;

    public ZipDataSource(File file) {
        super(file);
    }

    public ZipDataSource(URL url) {
        super(url);
    }

    @Override
    public String getType() {
        return type;
    }

    @Override
    public TableModel loadTableModel(Component contentPane) throws IOException, SQLException {
        TableModel tableModel;
        BufferedInputStream bis = this.getInputStream(this.checkContentPane(contentPane));
        ZipInputStream zin = new ZipInputStream(bis);
        ZipEntry firstEntry = zin.getNextEntry();
        if (firstEntry != null && firstEntry.getName().equals("Asset.txt")) {
            tableModel = LipperDataSource.load(zin, firstEntry);
            this.isLipper = true;
        } else {
            tableModel = ZipDataSource.load(zin, firstEntry);
        }
        zin.close();
        return tableModel;
    }

    @Override
    public Document getDocument(ApplicationModel applicationModel) {
        if (this.isLipper) {
            return LipperDataSource.getDefaultDocument(applicationModel);
        }
        Element root = new Element("TreeMap");
        Element layout = new Element("Layout");
        root.appendChild((Node)layout);
        Element algorithm = new Element("Labeling");
        algorithm.addAttribute(new Attribute("name", "None"));
        layout.appendChild((Node)algorithm);
        Document doc = new Document(root);
        return doc;
    }

    static ZipTableModel load(ZipInputStream zin, ZipEntry entry) {
        return new ZipTableModel(zin, entry);
    }
}

