/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.source.zip;

import com.macrofocus.data.source.zip.ExtendedZipArchiveEntry;
import com.macrofocus.data.source.zip.ExtendedZipFileInterface;
import com.macrofocus.data.source.zip.PasswordProvider;
import com.macrofocus.data.source.zip.SwingPasswordProvider;
import com.macrofocus.data.source.zip.WinzipAesDecryptedZipInputStream;
import com.macrofocus.data.source.zip.ZipArchiveEntry;
import com.macrofocus.data.source.zip.ZipArchiveOutputStream;
import com.macrofocus.data.source.zip.ZipCryptoInputStream;
import com.macrofocus.data.source.zip.ZipEncoding;
import com.macrofocus.data.source.zip.ZipEncodingHelper;
import com.macrofocus.data.source.zip.ZipExtraField;
import com.macrofocus.data.source.zip.ZipFile;
import com.macrofocus.data.source.zip.ZipLong;
import com.macrofocus.data.source.zip.ZipShort;
import com.macrofocus.data.source.zip.ZipUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;
import org.apache.commons.io.EndianUtils;
import org.apache.commons.lang.StringUtils;

public class ExtendedZipFile
implements ExtendedZipFileInterface {
    private static final int BYTE_ARRAY_SIZE_DOUBLE_WORD = 8;
    private static final int BYTE_ARRAY_SIZE_SHORT = 2;
    private static final int BYTE_ARRAY_SIZE_WORD = 4;
    private static final int BYTE_SHIFT = 8;
    private static final int CFH_LEN = 42;
    public static final int COMPRESSION_METHOD_ENCRYPTED_AES = 99;
    private static final byte[] EOCD_SIG = ZipLong.getBytes(101010256L);
    private static final int HASH_SIZE = 509;
    public static final int HEADER_ID_AES_EXTRA_DATA = 39169;
    private static final long LFH_OFFSET_FOR_FILENAME_LENGTH = 26L;
    private static final int MIN_EOCD_SIZE = 22;
    private static final int MAX_EOCD_SIZE = 65557;
    private static final int MIN_ZIP64_EOCD_LOC_SIZE = 20;
    private static final int NIBLET_MASK = 15;
    private static final int POS_0 = 0;
    private static final int POS_1 = 1;
    private static final int POS_2 = 2;
    private static final int POS_3 = 3;
    private static final long ZIP64_DEFERRED_VALUE_STORAGE_SHORT = Long.decode("0xffff");
    private static final long ZIP64_DEFERRED_VALUE_STORAGE_WORD = Long.decode("0xffffffff");
    private static final byte[] ZIP64_EOCD_LOC_SIG = ZipLong.getBytes(117853008L);
    private static final byte[] ZIP64_EOCD_SIG = ZipLong.getBytes(101075792L);
    private final RandomAccessFile archive;
    private final String encoding;
    private final Map entries = new HashMap(509);
    private boolean isZip64 = false;
    private final Map nameMap = new HashMap(509);
    private PasswordProvider passwordProvider = null;
    private boolean printDebugStatements = false;
    private final boolean useUnicodeExtraFields;
    private final ZipEncoding zipEncoding;

    public static void closeQuietly(ZipFile zipfile) {
        if (zipfile != null) {
            try {
                zipfile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public ExtendedZipFile(File f) throws IOException {
        this(f, "UTF8");
    }

    public ExtendedZipFile(File f, boolean printDebugStatements) throws IOException {
        this(f, "UTF8", true, printDebugStatements);
    }

    public ExtendedZipFile(File f, String encoding) throws IOException {
        this(f, encoding, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtendedZipFile(File f, String encoding, boolean useUnicodeExtraFields, boolean printDebugStatements) throws IOException {
        this.encoding = encoding;
        this.zipEncoding = ZipEncodingHelper.getZipEncoding(encoding);
        this.useUnicodeExtraFields = useUnicodeExtraFields;
        this.printDebugStatements = printDebugStatements;
        this.archive = new RandomAccessFile(f, "r");
        boolean success = false;
        try {
            Map entriesWithoutEFS = this.populateFromCentralDirectory();
            this.resolveLocalFileHeaderData(entriesWithoutEFS);
            success = true;
        }
        finally {
            if (!success) {
                try {
                    this.archive.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public ExtendedZipFile(String name) throws IOException {
        this(new File(name), "UTF8");
    }

    public ExtendedZipFile(String name, String encoding) throws IOException {
        this(new File(name), encoding, true, false);
    }

    @Override
    public void close() throws IOException {
        this.archive.close();
    }

    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public Enumeration getEntries() {
        return Collections.enumeration(this.entries.keySet());
    }

    @Override
    public ZipArchiveEntry getEntry(String name) {
        return (ZipArchiveEntry)this.nameMap.get(name);
    }

    @Override
    public InputStream getInputStream(ZipArchiveEntry ze) throws Exception {
        OffsetEntry offsetEntry = (OffsetEntry)this.entries.get(ze);
        boolean encrypted = false;
        if (offsetEntry == null) {
            return null;
        }
        if (ze instanceof ExtendedZipArchiveEntry && ((ExtendedZipArchiveEntry)ze).isEncrypted()) {
            encrypted = true;
            if (ze.getMethod() == 99) {
                // empty if block
            }
        }
        long start = offsetEntry.dataOffset;
        BoundedInputStream bis = new BoundedInputStream(start, ze.getCompressedSize());
        switch (ze.getMethod()) {
            case 0: {
                if (encrypted) {
                    return new ZipCryptoInputStream(ze, bis, this.getPasswordProvider());
                }
                return bis;
            }
            case 8: {
                bis.addDummy();
                if (encrypted) {
                    return new InflaterInputStream(new ZipCryptoInputStream(ze, bis, this.getPasswordProvider()), new Inflater(true));
                }
                return new InflaterInputStream(bis, new Inflater(true));
            }
            case 99: {
                return new WinzipAesDecryptedZipInputStream(ze, bis, this.getPasswordProvider());
            }
        }
        throw new ZipException("Found unsupported compression method " + ze.getMethod());
    }

    public PasswordProvider getPasswordProvider() {
        if (this.passwordProvider == null) {
            this.passwordProvider = new SwingPasswordProvider(null);
        }
        return this.passwordProvider;
    }

    private boolean isPrintDebugStatements() {
        return this.printDebugStatements;
    }

    private Map populateFromCentralDirectory() throws IOException {
        HashMap<ExtendedZipArchiveEntry, NameAndComment> noEFS = new HashMap<ExtendedZipArchiveEntry, NameAndComment>();
        this.positionAtCentralDirectory();
        byte[] cfh = new byte[42];
        byte[] signatureBytes = new byte[4];
        this.archive.readFully(signatureBytes);
        long sig = ZipLong.getValue(signatureBytes);
        long cfhSig = ZipLong.getValue(ZipArchiveOutputStream.CFH_SIG);
        if (this.isPrintDebugStatements()) {
            System.out.println("Central directory Signature: " + Long.toHexString(sig) + " (" + Long.toHexString(cfhSig) + ")");
        }
        if (sig != cfhSig && this.startsWithLocalFileHeader()) {
            throw new IOException("central directory is empty, can't expand corrupt archive.");
        }
        while (sig == cfhSig) {
            ZipExtraField zip64ExtraDataField;
            this.archive.readFully(cfh);
            int off = 0;
            ExtendedZipArchiveEntry ze = new ExtendedZipArchiveEntry();
            int versionMadeBy = ZipShort.getValue(cfh, off);
            off += 2;
            ze.setPlatform(versionMadeBy >> 8 & 0xF);
            int generalPurposeFlag = ZipShort.getValue(cfh, off += 2);
            boolean hasEFS = (generalPurposeFlag & 0x800) != 0;
            ZipEncoding entryEncoding = hasEFS ? ZipEncodingHelper.UTF8_ZIP_ENCODING : this.zipEncoding;
            ze.setEncrypted((generalPurposeFlag & 1) != 0);
            ze.setMethod(ZipShort.getValue(cfh, off += 2));
            long time = ZipUtil.dosToJavaTime(ZipLong.getValue(cfh, off += 2));
            ze.setTime(time);
            ze.setCrc(ZipLong.getValue(cfh, off += 4));
            ze.setCompressedSize(ZipLong.getValue(cfh, off += 4));
            ze.setSize(ZipLong.getValue(cfh, off += 4));
            int fileNameLen = ZipShort.getValue(cfh, off += 4);
            int extraLen = ZipShort.getValue(cfh, off += 2);
            int commentLen = ZipShort.getValue(cfh, off += 2);
            off += 2;
            ze.setInternalAttributes(ZipShort.getValue(cfh, off += 2));
            ze.setExternalAttributes(ZipLong.getValue(cfh, off += 2));
            byte[] fileName = new byte[fileNameLen];
            this.archive.readFully(fileName);
            ze.setName(entryEncoding.decode(fileName));
            OffsetEntry offset = new OffsetEntry();
            offset.headerOffset = ZipLong.getValue(cfh, off += 4);
            this.entries.put(ze, offset);
            this.nameMap.put(ze.getName(), ze);
            byte[] cdExtraData = new byte[extraLen];
            this.archive.readFully(cdExtraData);
            ze.setCentralDirectoryExtra(cdExtraData);
            byte[] comment = new byte[commentLen];
            this.archive.readFully(comment);
            ze.setComment(entryEncoding.decode(comment));
            this.archive.readFully(signatureBytes);
            sig = ZipLong.getValue(signatureBytes);
            if (this.isZip64 && (zip64ExtraDataField = ze.getExtraField(new ZipShort(1))) != null) {
                byte[] zip64ExtraBlock = zip64ExtraDataField.getCentralDirectoryData();
                byte[] doubleWord = new byte[8];
                int copyOffset = 0;
                if (ze.getSize() == ZIP64_DEFERRED_VALUE_STORAGE_WORD) {
                    doubleWord = Arrays.copyOfRange(zip64ExtraBlock, copyOffset, 8);
                    long actualSize = EndianUtils.readSwappedLong((byte[])doubleWord, (int)0);
                    ze.setSize(actualSize);
                    copyOffset += 8;
                }
                if (ze.getCompressedSize() == ZIP64_DEFERRED_VALUE_STORAGE_WORD) {
                    doubleWord = Arrays.copyOfRange(zip64ExtraBlock, copyOffset, 8);
                    ze.setCompressedSize(EndianUtils.readSwappedLong((byte[])doubleWord, (int)0));
                    copyOffset += 8;
                }
                if (offset.headerOffset == ZIP64_DEFERRED_VALUE_STORAGE_WORD) {
                    doubleWord = Arrays.copyOfRange(zip64ExtraBlock, copyOffset, 8);
                    offset.headerOffset = EndianUtils.readSwappedLong((byte[])doubleWord, (int)0);
                    copyOffset += 8;
                }
            }
            if (hasEFS || !this.useUnicodeExtraFields) continue;
            noEFS.put(ze, new NameAndComment(fileName, comment));
        }
        return noEFS;
    }

    private void positionAtCentralDirectory() throws IOException {
        long centralDirectoryLocatorOffset;
        long startSearchOffset = this.archive.length() - 22L;
        long stopSearchOffset = Math.max(0L, this.archive.length() - 65557L);
        if (this.isPrintDebugStatements()) {
            System.out.println("Looking for End Of Central Directory Record ...");
        }
        if ((centralDirectoryLocatorOffset = this.positionAtSignature(startSearchOffset, stopSearchOffset, EOCD_SIG)) <= 0L) {
            throw new ZipException("archive is not a ZIP archive");
        }
        if (this.isPrintDebugStatements()) {
            System.out.println("Found End Of Central Directory Record at " + centralDirectoryLocatorOffset);
        }
        this.archive.seek(centralDirectoryLocatorOffset);
        byte[] eocdrSignature = new byte[4];
        this.archive.readFully(eocdrSignature);
        byte[] eocdrNumberOfDisk = new byte[2];
        this.archive.readFully(eocdrNumberOfDisk);
        byte[] eocdrNumberOfDiskWithStartOfCentralDirectory = new byte[2];
        this.archive.readFully(eocdrNumberOfDiskWithStartOfCentralDirectory);
        byte[] eocdrNumberOfEntriesInCentralDirOnThisDisk = new byte[2];
        this.archive.readFully(eocdrNumberOfEntriesInCentralDirOnThisDisk);
        byte[] eocdrNumberOfEntriesInCentralDir = new byte[2];
        this.archive.readFully(eocdrNumberOfEntriesInCentralDir);
        byte[] eocdrSizeOfCentralDir = new byte[4];
        this.archive.readFully(eocdrSizeOfCentralDir);
        byte[] cfdOffset = new byte[4];
        this.archive.readFully(cfdOffset);
        byte[] cfdCommentLength = new byte[2];
        this.archive.readFully(cfdCommentLength);
        byte[] cfdComment = new byte[ZipShort.getValue(cfdCommentLength)];
        this.archive.readFully(cfdComment);
        StringBuilder sb = new StringBuilder();
        int padLength = 100;
        if (this.isPrintDebugStatements()) {
            sb.append("End Of Central Directory Record:\n");
            sb.append(StringUtils.rightPad((String)"\tend of central dir signature", (int)100));
            sb.append("(4 bytes) : ");
            sb.append(Long.toHexString(ZipLong.getValue(eocdrSignature)));
            sb.append(" (");
            sb.append(Long.toHexString(ZipLong.getValue(EOCD_SIG)));
            sb.append(")");
            sb.append('\n');
            sb.append(StringUtils.rightPad((String)"\tnumber of this disk", (int)100));
            sb.append("(2 bytes) : ");
            sb.append(ZipShort.getValue(eocdrNumberOfDisk));
            sb.append('\n');
            sb.append(StringUtils.rightPad((String)"\tnumber of the disk with the start of the central directory ", (int)100));
            sb.append("(2 bytes) : ");
            sb.append(ZipShort.getValue(eocdrNumberOfDiskWithStartOfCentralDirectory));
            sb.append('\n');
            sb.append(StringUtils.rightPad((String)"\ttotal number of entries in the central directory on this disk", (int)100));
            sb.append("(2 bytes) : ");
            sb.append(ZipShort.getValue(eocdrNumberOfEntriesInCentralDirOnThisDisk));
            sb.append('\n');
            sb.append(StringUtils.rightPad((String)"\ttotal number of entries in the central directory", (int)100));
            sb.append("(2 bytes) : ");
            sb.append(ZipShort.getValue(eocdrNumberOfEntriesInCentralDir));
            sb.append('\n');
            sb.append(StringUtils.rightPad((String)"\tsize of the central directory", (int)100));
            sb.append("(4 bytes) : ");
            sb.append(ZipLong.getValue(eocdrSizeOfCentralDir));
            sb.append('\n');
            sb.append(StringUtils.rightPad((String)"\toffset of start of central directory with respect to the starting disk number", (int)100));
            sb.append("(4 bytes) : ");
            sb.append(ZipLong.getValue(cfdOffset));
            sb.append('\n');
            sb.append(StringUtils.rightPad((String)"\tzip file comment length", (int)100));
            sb.append("(2 bytes) : ");
            sb.append(ZipShort.getValue(cfdCommentLength));
            sb.append('\n');
            sb.append(StringUtils.rightPad((String)"\tzip file comment", (int)100));
            sb.append("(variable): ");
            sb.append(new String(cfdComment));
            sb.append('\n');
            System.out.println(sb);
        }
        ZipShort test1 = new ZipShort(eocdrNumberOfEntriesInCentralDirOnThisDisk);
        ZipShort test2 = new ZipShort(eocdrNumberOfEntriesInCentralDir);
        ZipShort test3 = new ZipShort(eocdrSizeOfCentralDir);
        ZipLong test4 = new ZipLong(cfdOffset);
        if ((long)test1.getValue() >= ZIP64_DEFERRED_VALUE_STORAGE_SHORT || (long)test2.getValue() >= ZIP64_DEFERRED_VALUE_STORAGE_SHORT || (long)test3.getValue() >= ZIP64_DEFERRED_VALUE_STORAGE_SHORT || test4.getValue() == ZIP64_DEFERRED_VALUE_STORAGE_WORD) {
            long zip64StopSearchOffset;
            long zip64StartSearchOffset;
            long zip64CentralDirectoryLocatorOffset;
            this.isZip64 = true;
            if (this.isPrintDebugStatements()) {
                System.out.println("Looking for Zip64 end of central directory locator ...");
            }
            if ((zip64CentralDirectoryLocatorOffset = this.positionAtSignature(zip64StartSearchOffset = this.archive.length() - 22L, zip64StopSearchOffset = Math.max(0L, this.archive.length() - 65557L - 20L), ZIP64_EOCD_LOC_SIG)) <= 0L) {
                throw new ZipException("Could not find Zip64 end of central directory locator");
            }
            if (this.isPrintDebugStatements()) {
                System.out.println("Found Zip64 end of central directory locator at " + zip64CentralDirectoryLocatorOffset);
            }
            this.archive.seek(zip64CentralDirectoryLocatorOffset);
            byte[] zip64EocdLocSignature = new byte[4];
            this.archive.readFully(zip64EocdLocSignature);
            byte[] zip64NumberOfDiskWithStartOfCentralDirectory = new byte[4];
            this.archive.readFully(zip64NumberOfDiskWithStartOfCentralDirectory);
            byte[] zip64RelativeOffsetOfCentralDirectoryRecord = new byte[8];
            this.archive.readFully(zip64RelativeOffsetOfCentralDirectoryRecord);
            long zip64EndOfCentralDirectoryOffset = EndianUtils.readSwappedLong((byte[])zip64RelativeOffsetOfCentralDirectoryRecord, (int)0);
            byte[] zip64TotalNumberOfDisks = new byte[4];
            this.archive.readFully(zip64TotalNumberOfDisks);
            if (this.isPrintDebugStatements()) {
                sb.setLength(0);
                sb.append("Zip64 End Of Central Directory Locator:\n");
                sb.append(StringUtils.rightPad((String)"\tzip64 end of central dir locator signature", (int)100));
                sb.append("(4 bytes) : ");
                sb.append(Long.toHexString(ZipLong.getValue(zip64EocdLocSignature)));
                sb.append(" (");
                sb.append(Long.toHexString(ZipLong.getValue(ZIP64_EOCD_LOC_SIG)));
                sb.append(")");
                sb.append('\n');
                sb.append(StringUtils.rightPad((String)"\tnumber of the disk with the start of the zip64 end of central directory", (int)100));
                sb.append("(4 bytes) : ");
                sb.append(ZipLong.getValue(zip64NumberOfDiskWithStartOfCentralDirectory));
                sb.append('\n');
                sb.append(StringUtils.rightPad((String)"\trelative offset of the zip64 end of central directory record", (int)100));
                sb.append("(8 bytes) : ");
                sb.append(zip64EndOfCentralDirectoryOffset);
                sb.append('\n');
                sb.append(StringUtils.rightPad((String)"\ttotal number of disks", (int)100));
                sb.append("(4 bytes) : ");
                sb.append(ZipLong.getValue(zip64TotalNumberOfDisks));
                sb.append('\n');
                System.out.println(sb.toString());
            }
            if (this.isPrintDebugStatements()) {
                System.out.println("Moving to Zip64 end of central directory locator at " + zip64EndOfCentralDirectoryOffset);
            }
            this.archive.seek(zip64EndOfCentralDirectoryOffset);
            byte[] zip64EocdSignature = new byte[4];
            this.archive.readFully(zip64EocdSignature);
            byte[] zip64EocdSize = new byte[8];
            this.archive.readFully(zip64EocdSize);
            byte[] zip64VersionMadeBy = new byte[2];
            this.archive.readFully(zip64VersionMadeBy);
            byte[] zip64VersionNeededToExtract = new byte[2];
            this.archive.readFully(zip64VersionNeededToExtract);
            byte[] zip64NumberOfThisDisk = new byte[4];
            this.archive.readFully(zip64NumberOfThisDisk);
            byte[] zip64NumberOfDiskWithStartOfCentralDirectory2 = new byte[4];
            this.archive.readFully(zip64NumberOfDiskWithStartOfCentralDirectory2);
            byte[] zip64TotalNumberOfEntriesOnThisDisk = new byte[8];
            this.archive.readFully(zip64TotalNumberOfEntriesOnThisDisk);
            byte[] zip64TotalNumberOfEntries = new byte[8];
            this.archive.readFully(zip64TotalNumberOfEntries);
            byte[] zip64SizeOfCentralDirectory = new byte[8];
            this.archive.readFully(zip64SizeOfCentralDirectory);
            byte[] zip64CentralDirectoryOffset = new byte[8];
            this.archive.readFully(zip64CentralDirectoryOffset);
            long zip64CentralDirOffset = EndianUtils.readSwappedLong((byte[])zip64CentralDirectoryOffset, (int)0);
            if (this.isPrintDebugStatements()) {
                sb.setLength(0);
                sb.append("Zip64 End Of Central Directory Record:\n");
                sb.append(StringUtils.rightPad((String)"\tzip64 end of central dir signature", (int)100));
                sb.append("(4 bytes) : ");
                sb.append(Long.toHexString(ZipLong.getValue(zip64EocdSignature)));
                sb.append(" (");
                sb.append(Long.toHexString(ZipLong.getValue(ZIP64_EOCD_SIG)));
                sb.append(")");
                sb.append('\n');
                sb.append(StringUtils.rightPad((String)"\tsize of zip64 end of central directory record", (int)100));
                sb.append("(8 bytes) : ");
                sb.append(EndianUtils.readSwappedLong((byte[])zip64EocdSize, (int)0));
                sb.append('\n');
                sb.append(StringUtils.rightPad((String)"\tversion made by", (int)100));
                sb.append("(2 bytes) : ");
                sb.append(ZipShort.getValue(zip64VersionMadeBy));
                sb.append('\n');
                sb.append(StringUtils.rightPad((String)"\tversion needed to extract", (int)100));
                sb.append("(2 bytes) : ");
                sb.append(ZipShort.getValue(zip64VersionNeededToExtract));
                sb.append('\n');
                sb.append(StringUtils.rightPad((String)"\tnumber of this disk", (int)100));
                sb.append("(4 bytes) : ");
                sb.append(ZipLong.getValue(zip64NumberOfThisDisk));
                sb.append('\n');
                sb.append(StringUtils.rightPad((String)"\tnumber of the disk with the start of the central directory", (int)100));
                sb.append("(4 bytes) : ");
                sb.append(ZipLong.getValue(zip64NumberOfDiskWithStartOfCentralDirectory2));
                sb.append('\n');
                sb.append(StringUtils.rightPad((String)"\ttotal number of entries in the central directory on this disk", (int)100));
                sb.append("(8 bytes) : ");
                sb.append(EndianUtils.readSwappedLong((byte[])zip64TotalNumberOfEntriesOnThisDisk, (int)0));
                sb.append('\n');
                sb.append(StringUtils.rightPad((String)"\ttotal number of entries in the central directory", (int)100));
                sb.append("(8 bytes) : ");
                sb.append(EndianUtils.readSwappedLong((byte[])zip64TotalNumberOfEntries, (int)0));
                sb.append('\n');
                sb.append(StringUtils.rightPad((String)"\tsize of the central directory", (int)100));
                sb.append("(8 bytes) : ");
                sb.append(EndianUtils.readSwappedLong((byte[])zip64SizeOfCentralDirectory, (int)0));
                sb.append('\n');
                sb.append(StringUtils.rightPad((String)"\toffset of start of centraldirectory with respect to the starting disk number", (int)100));
                sb.append("(8 bytes) : ");
                sb.append(zip64CentralDirOffset);
                sb.append('\n');
                System.out.println(sb.toString());
            }
            this.archive.seek(zip64CentralDirOffset);
        } else {
            this.archive.seek(ZipLong.getValue(cfdOffset));
        }
    }

    private long positionAtSignature(long startingOffset, long stopSearchingOffset, byte[] sig) throws IOException {
        long off = startingOffset;
        boolean found = false;
        long stopSearching = Math.max(0L, stopSearchingOffset);
        if (off >= 0L) {
            this.archive.seek(off);
            int curr = this.archive.read();
            while (off >= stopSearching && curr != -1) {
                if (curr == sig[0] && (curr = this.archive.read()) == sig[1] && (curr = this.archive.read()) == sig[2] && (curr = this.archive.read()) == sig[3]) {
                    found = true;
                    break;
                }
                this.archive.seek(--off);
                curr = this.archive.read();
            }
        }
        return found ? off : -1L;
    }

    private void resolveLocalFileHeaderData(Map entriesWithoutEFS) throws IOException {
        Enumeration e = this.getEntries();
        while (e.hasMoreElements()) {
            int skipped;
            ZipArchiveEntry ze = (ZipArchiveEntry)e.nextElement();
            OffsetEntry offsetEntry = (OffsetEntry)this.entries.get(ze);
            long offset = offsetEntry.headerOffset;
            this.archive.seek(offset + 26L);
            byte[] b = new byte[2];
            this.archive.readFully(b);
            int fileNameLen = ZipShort.getValue(b);
            this.archive.readFully(b);
            int extraFieldLen = ZipShort.getValue(b);
            for (int lenToSkip = fileNameLen; lenToSkip > 0; lenToSkip -= skipped) {
                skipped = this.archive.skipBytes(lenToSkip);
                if (skipped > 0) continue;
                throw new RuntimeException("failed to skip file name in local file header");
            }
            byte[] localExtraData = new byte[extraFieldLen];
            this.archive.readFully(localExtraData);
            ze.setExtra(localExtraData);
            offsetEntry.dataOffset = offset + 26L + 2L + 2L + (long)fileNameLen + (long)extraFieldLen;
            if (!entriesWithoutEFS.containsKey(ze)) continue;
            String orig = ze.getName();
            NameAndComment nc = (NameAndComment)entriesWithoutEFS.get(ze);
            ZipUtil.setNameAndCommentFromExtraFields(ze, nc.name, nc.comment);
            if (orig.equals(ze.getName())) continue;
            this.nameMap.remove(orig);
            this.nameMap.put(ze.getName(), ze);
        }
    }

    public void setPassword(String password) {
        this.getPasswordProvider().setPassword(password.toCharArray());
    }

    private boolean startsWithLocalFileHeader() throws IOException {
        this.archive.seek(0L);
        byte[] start = new byte[4];
        this.archive.readFully(start);
        for (int i = 0; i < start.length; ++i) {
            if (start[i] == ZipArchiveOutputStream.LFH_SIG[i]) continue;
            return false;
        }
        return true;
    }

    private static final class OffsetEntry {
        private long dataOffset = -1L;
        private long headerOffset = -1L;

        private OffsetEntry() {
        }
    }

    private static final class NameAndComment {
        private final byte[] comment;
        private final byte[] name;

        private NameAndComment(byte[] name, byte[] comment) {
            this.name = name;
            this.comment = comment;
        }
    }

    private class BoundedInputStream
    extends InputStream {
        private boolean addDummyByte = false;
        private long loc;
        private long remaining;

        BoundedInputStream(long start, long remaining) {
            this.remaining = remaining;
            this.loc = start;
        }

        void addDummy() {
            this.addDummyByte = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() throws IOException {
            if (this.remaining-- <= 0L) {
                if (this.addDummyByte) {
                    this.addDummyByte = false;
                    return 0;
                }
                return -1;
            }
            RandomAccessFile randomAccessFile = ExtendedZipFile.this.archive;
            synchronized (randomAccessFile) {
                ExtendedZipFile.this.archive.seek(this.loc++);
                return ExtendedZipFile.this.archive.read();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.remaining <= 0L) {
                if (this.addDummyByte) {
                    this.addDummyByte = false;
                    b[off] = 0;
                    return 1;
                }
                return -1;
            }
            if (len <= 0) {
                return 0;
            }
            if ((long)len > this.remaining) {
                len = (int)this.remaining;
            }
            int ret = -1;
            RandomAccessFile randomAccessFile = ExtendedZipFile.this.archive;
            synchronized (randomAccessFile) {
                ExtendedZipFile.this.archive.seek(this.loc);
                ret = ExtendedZipFile.this.archive.read(b, off, len);
            }
            if (ret > 0) {
                this.loc += (long)ret;
                this.remaining -= (long)ret;
            }
            return ret;
        }
    }
}

