/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.source.zip;

import com.macrofocus.data.source.zip.ExtendedZipFile;
import com.macrofocus.data.source.zip.ExtendedZipFileAdapterForOriginalZipFile;
import com.macrofocus.data.source.zip.ExtendedZipFileInterface;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public class ExtendedZipFileTools {
    public static final Logger logger = Logger.getLogger(ExtendedZipFileTools.class);

    public static ExtendedZipFileInterface getExtendedZipFileInterface(File zipFile) throws IOException {
        try {
            return new ExtendedZipFileAdapterForOriginalZipFile(zipFile);
        }
        catch (Exception e) {
            logger.warn((Object)("Caught exception " + e.getMessage() + "... fallback to ExtendedZipFile for " + zipFile.getPath()));
            return new ExtendedZipFile(zipFile);
        }
    }

    public static void closeQuietly(ExtendedZipFileInterface zipFile) {
        if (zipFile != null) {
            try {
                zipFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

