/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.table;

import com.macrofocus.common.logging.Logging;
import com.macrofocus.data.table.AbstractTableModel;
import com.macrofocus.data.typemap.DefaultTypemapModel;
import com.macrofocus.data.typemap.InvalidValueException;
import com.macrofocus.data.typemap.TypemapModel;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellReference;

public class ExcelXTableModel
extends AbstractTableModel {
    public static boolean ALLOW_FIRST_NULL_COLUMN = false;
    private Sheet sheet;
    private List<Integer> columns;
    private List<Integer> rows;
    private List<String> names;
    private List<Class> classes;
    private final boolean rounding;
    private TypemapModel.Builder[] constructors;

    public ExcelXTableModel(Sheet sheet) {
        this(sheet, false);
    }

    public ExcelXTableModel(Sheet sheet, boolean rounding) {
        this.sheet = sheet;
        this.rounding = rounding;
        try {
            Cell cell;
            this.columns = new ArrayList<Integer>();
            this.rows = new ArrayList<Integer>();
            this.names = new ArrayList<String>();
            this.classes = new ArrayList<Class>();
            Iterator rowIterator = sheet.iterator();
            if (rowIterator.hasNext()) {
                Row firstRow = (Row)rowIterator.next();
                short minColIx = firstRow.getFirstCellNum();
                short maxColIx = firstRow.getLastCellNum();
                for (short colIx = minColIx; colIx < maxColIx; colIx = (short)(colIx + 1)) {
                    Cell cell2 = firstRow.getCell((int)colIx);
                    if ((cell2 == null || cell2.getCellType() == CellType.BLANK) && (!ALLOW_FIRST_NULL_COLUMN || colIx != minColIx)) continue;
                    Object name = this.getValue(0, cell2.getColumnIndex(), cell2, String.class);
                    if (name != null) {
                        this.names.add(name.toString());
                        this.columns.add(cell2.getColumnIndex());
                        this.classes.add(Object.class);
                        continue;
                    }
                    if (!ALLOW_FIRST_NULL_COLUMN || colIx != minColIx) continue;
                    this.names.add("Date");
                    this.columns.add(cell2.getColumnIndex());
                    this.classes.add(Object.class);
                }
            }
            Row nextRow = null;
            if (rowIterator.hasNext()) {
                nextRow = (Row)rowIterator.next();
                boolean hasClassHeader = true;
                DefaultTypemapModel typemapModel = new DefaultTypemapModel();
                short minColIx = nextRow.getFirstCellNum();
                short maxColIx = nextRow.getLastCellNum();
                for (short colIx = minColIx; colIx < maxColIx; colIx = (short)(colIx + 1)) {
                    Object token;
                    cell = nextRow.getCell((int)colIx);
                    if (cell == null || cell.getCellType() == CellType.BLANK || (token = this.getValue(1, cell.getColumnIndex(), cell, String.class)) == null || typemapModel.findBuilder(token.toString()) != null) continue;
                    hasClassHeader = false;
                    break;
                }
                if (hasClassHeader) {
                    this.constructors = new TypemapModel.Builder[this.getColumnCount()];
                    int column = 0;
                    short minColIx2 = nextRow.getFirstCellNum();
                    short maxColIx2 = nextRow.getLastCellNum();
                    for (short colIx = minColIx2; colIx < maxColIx2; colIx = (short)(colIx + 1)) {
                        Object token;
                        Cell cell3 = nextRow.getCell((int)colIx);
                        TypemapModel.Builder builder = cell3 != null && cell3.getCellType() != CellType.BLANK ? ((token = this.getValue(1, cell3.getColumnIndex(), cell3, String.class)) != null ? typemapModel.getBuilder(token.toString()) : typemapModel.getBuilder("String")) : typemapModel.getBuilder("String");
                        this.constructors[column] = builder;
                        this.classes.set(column, builder.getType());
                        ++column;
                    }
                }
                if (hasClassHeader) {
                    nextRow = (Row)rowIterator.next();
                }
            }
            boolean last = false;
            do {
                boolean empty = true;
                if (nextRow != null) {
                    for (Cell cell4 : nextRow) {
                        if (cell4.getCellType() == CellType.BLANK) continue;
                        empty = false;
                        break;
                    }
                }
                if (!empty) {
                    this.rows.add(nextRow.getRowNum());
                }
                if (rowIterator.hasNext()) {
                    nextRow = (Row)rowIterator.next();
                    continue;
                }
                last = true;
            } while (!last);
            if (this.getRowCount() > 0) {
                for (int column = 0; column < this.getColumnCount(); ++column) {
                    int row;
                    if (this.constructors != null && this.constructors[column] != null) continue;
                    Class<Object> cl = this.getColumnClass(column);
                    for (row = 0; row < this.getRowCount(); ++row) {
                        Object value = this.getValueAt(row, column, cl);
                        if (value == null || value.equals("")) continue;
                        cl = value.getClass();
                        break;
                    }
                    for (row = 0; row < this.getRowCount(); ++row) {
                        Object value = this.getValueAt(row, column, cl);
                        if (value == null || value.equals("") || value.getClass() == cl) continue;
                        cl = String.class;
                        break;
                    }
                    if (cl != String.class) {
                        for (row = 0; row < this.getRowCount(); ++row) {
                            Object value = this.getValueAt(row, column, cl);
                            if (value == null || !value.equals("")) continue;
                            cell = this.getCell(row, column);
                            cell.setCellValue((String)null);
                        }
                    }
                    this.classes.set(column, cl);
                }
            }
            this.autoConvert();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Class getColumnClass(int columnIndex) {
        return this.classes.get(columnIndex);
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.names.get(columnIndex);
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Cell cell = this.getCell(rowIndex, columnIndex);
        return this.getValue(rowIndex, columnIndex, cell, this.getColumnClass(columnIndex));
    }

    public Object getValueAt(int rowIndex, int columnIndex, Class type) {
        Cell cell = this.getCell(rowIndex, columnIndex);
        return this.getValue(rowIndex, columnIndex, cell, type);
    }

    private Object getValue(int rowIndex, int columnIndex, Cell cell, Class type) {
        if (cell != null) {
            CellType cellType = cell.getCellType();
            return this.getCellValue(rowIndex, columnIndex, cell, cellType, type);
        }
        return null;
    }

    private Object getCellValue(int rowIndex, int columnIndex, Cell cell, CellType cellType, Class type) {
        if (this.constructors == null || this.constructors.length - 1 < columnIndex || this.constructors[columnIndex] == null) {
            try {
                switch (cellType) {
                    case BLANK: {
                        return null;
                    }
                    case BOOLEAN: {
                        return cell.getBooleanCellValue();
                    }
                    case ERROR: {
                        return null;
                    }
                    case FORMULA: {
                        return this.getCellValue(rowIndex, columnIndex, cell, cell.getCachedFormulaResultType(), type);
                    }
                    case NUMERIC: {
                        if (type == String.class) {
                            return new DataFormatter(Locale.ENGLISH, true).formatCellValue(cell);
                        }
                        if (DateUtil.isCellDateFormatted((Cell)cell)) {
                            return cell.getDateCellValue();
                        }
                        double d = cell.getNumericCellValue();
                        if (!Double.isInfinite(d)) {
                            if (this.classes.size() > columnIndex && this.classes.get(columnIndex) == Integer.class) {
                                return (int)d;
                            }
                            if (this.rounding) {
                                BigDecimal bd = new BigDecimal(d);
                                return bd.round(new MathContext(15)).doubleValue();
                            }
                            return d;
                        }
                        System.err.println(cell + " " + cell.getNumericCellValue());
                        return null;
                    }
                    case STRING: {
                        String string = cell.getRichStringCellValue().getString();
                        if (string != null) {
                            return string.trim();
                        }
                        return null;
                    }
                }
                return null;
            }
            catch (RuntimeException e) {
                if (Logging.getInstance().process((Throwable)e)) {
                    throw e;
                }
                return null;
            }
        }
        try {
            switch (cellType) {
                case BLANK: {
                    return null;
                }
                case BOOLEAN: {
                    return cell.getBooleanCellValue();
                }
                case NUMERIC: {
                    if (DateUtil.isCellDateFormatted((Cell)cell) && this.classes.size() > columnIndex && this.classes.get(columnIndex) == Date.class) {
                        return cell.getDateCellValue();
                    }
                    double numericCellValue = cell.getNumericCellValue();
                    if (numericCellValue == (double)((long)numericCellValue)) {
                        return this.constructors[columnIndex].create(Long.toString((long)numericCellValue));
                    }
                    return this.constructors[columnIndex].create(Double.toString(numericCellValue));
                }
                case STRING: {
                    try {
                        return this.constructors[columnIndex].create(cell.getStringCellValue());
                    }
                    catch (NumberFormatException e) {
                        InvalidValueException t = new InvalidValueException("Incorrect numeric value \"" + cell.getStringCellValue() + "\" in cell " + new CellReference(cell.getRowIndex(), cell.getColumnIndex()).formatAsString() + " of sheet " + this.sheet.getSheetName(), e);
                        throw t;
                    }
                }
                case FORMULA: {
                    return this.getCellValue(rowIndex, columnIndex, cell, cell.getCachedFormulaResultType(), type);
                }
            }
            return null;
        }
        catch (RuntimeException e) {
            InvalidValueException t = new InvalidValueException("Incorrect value in cell " + new CellReference(cell.getRowIndex(), cell.getColumnIndex()).formatAsString() + " of sheet " + this.sheet.getSheetName(), e);
            if (Logging.getInstance().process((Throwable)t)) {
                throw new RuntimeException(t);
            }
            return null;
        }
        catch (InvalidValueException e) {
            if (Logging.getInstance().process((Throwable)e)) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return null;
        }
    }

    private Cell getCell(int rowIndex, int columnIndex) {
        Row row = this.sheet.getRow(this.rows.get(rowIndex).intValue());
        if (row != null) {
            return row.getCell(this.columns.get(columnIndex).intValue());
        }
        return null;
    }

    private void autoConvert() {
        boolean fireEvent = false;
        for (int column = 0; column < this.getColumnCount(); ++column) {
            if (this.constructors != null && this.constructors[column] != null || !this.isConvertableToInteger(column)) continue;
            this.convertToInteger(column);
        }
        if (fireEvent) {
            this.fireTableDataChanged();
        }
    }

    private void convertToInteger(int column) {
        this.classes.set(column, Integer.class);
    }

    private boolean isConvertableToInteger(int column) {
        Class type = this.getColumnClass(column);
        if (type != Integer.class && Number.class.isAssignableFrom(type)) {
            for (int row = 0; row < this.getRowCount(); ++row) {
                Number s;
                Object v = this.getValueAt(row, column);
                if (v == null || !(v instanceof Number ? (double)(s = (Number)v).intValue() != s.doubleValue() : !(v instanceof Integer))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

