/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.table;

import com.macrofocus.data.table.AbstractTableModel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eobjects.sassy.SasColumnType;
import org.eobjects.sassy.SasReader;
import org.eobjects.sassy.SasReaderCallback;

public class SASTableModel
extends AbstractTableModel {
    private List<String> columnNames = new ArrayList<String>();
    private List<Class> columnTypes = new ArrayList<Class>();
    private List<Object[]> rows = new ArrayList<Object[]>();

    public SASTableModel(File shapeURL) throws IOException {
        SasReader reader = new SasReader(shapeURL);
        reader.read(new SasReaderCallback(){

            public void column(int index, String name, String label, SasColumnType type, int length) {
                SASTableModel.this.columnNames.add(name);
                switch (type) {
                    case NUMERIC: {
                        SASTableModel.this.columnTypes.add(Number.class);
                        break;
                    }
                    case CHARACTER: {
                        SASTableModel.this.columnTypes.add(String.class);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            }

            public boolean readData() {
                return true;
            }

            public boolean row(int rowNumber, Object[] rowData) {
                SASTableModel.this.rows.add(rowData);
                return true;
            }
        });
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames.get(column);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.columnTypes.get(columnIndex);
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.rows.get(rowIndex)[columnIndex];
    }
}

