/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.table;

import com.macrofocus.data.table.AbstractTableModel;
import com.macrofocus.data.type.TypeHelper;
import com.macrofocus.helper.ColorHelper;
import com.macrofocus.helper.OSHelper;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.zip.DataFormatException;
import javax.imageio.ImageIO;
import javax.swing.table.TableModel;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKBWriter;
import org.locationtech.jts.io.WKTReader;

public class SimpleTableModel
extends AbstractTableModel
implements Externalizable {
    public static final long serialVersionUID = -3175316423606085277L;
    private Object[][] objects;
    private String[] names;
    private Class[] classes;
    private int rowCount = 0;

    public SimpleTableModel() {
    }

    public SimpleTableModel(TableModel tableModel) {
        this(tableModel, false, false);
    }

    public SimpleTableModel(TableModel tableModel, boolean autoConvert, boolean stripEmptyColumn) {
        this.rowCount = tableModel.getRowCount();
        HashMap<Object, Object> recycler = new HashMap<Object, Object>();
        if (stripEmptyColumn) {
            ArrayList<Integer> columns = new ArrayList<Integer>();
            block0: for (int c = 0; c < tableModel.getColumnCount(); ++c) {
                String columnName = tableModel.getColumnName(c);
                if (columnName != null && !columnName.trim().equals("")) {
                    columns.add(c);
                    continue;
                }
                for (int r = 0; r < tableModel.getRowCount(); ++r) {
                    Object value = tableModel.getValueAt(r, c);
                    if (value == null) continue;
                    if (value instanceof String) {
                        String s = (String)value;
                        if (s.trim().equals("")) continue;
                        columns.add(c);
                        continue block0;
                    }
                    columns.add(c);
                    continue block0;
                }
            }
            this.names = new String[columns.size()];
            this.classes = new Class[columns.size()];
            this.objects = new Object[columns.size()][tableModel.getRowCount()];
            for (int column = 0; column < columns.size(); ++column) {
                int row;
                int col = (Integer)columns.get(column);
                this.names[column] = tableModel.getColumnName(col);
                this.classes[column] = tableModel.getColumnClass(col);
                if (this.classes[column] != null && (this.classes[column] != Float.class || this.classes[column] != Double.class)) {
                    for (row = 0; row < tableModel.getRowCount(); ++row) {
                        this.objects[column][row] = tableModel.getValueAt(row, col);
                    }
                    continue;
                }
                for (row = 0; row < tableModel.getRowCount(); ++row) {
                    this.objects[column][row] = SimpleTableModel.recycle(recycler, tableModel.getValueAt(row, col));
                }
            }
        } else {
            this.names = new String[tableModel.getColumnCount()];
            this.classes = new Class[tableModel.getColumnCount()];
            this.objects = new Object[tableModel.getColumnCount()][tableModel.getRowCount()];
            for (int column = 0; column < tableModel.getColumnCount(); ++column) {
                int row;
                this.names[column] = tableModel.getColumnName(column);
                this.classes[column] = tableModel.getColumnClass(column);
                if (this.classes[column] != null && (this.classes[column] != Float.class || this.classes[column] != Double.class)) {
                    for (row = 0; row < tableModel.getRowCount(); ++row) {
                        this.objects[column][row] = tableModel.getValueAt(row, column);
                    }
                    continue;
                }
                for (row = 0; row < tableModel.getRowCount(); ++row) {
                    this.objects[column][row] = SimpleTableModel.recycle(recycler, tableModel.getValueAt(row, column));
                }
            }
        }
        if (autoConvert) {
            this.autoConvert();
        }
    }

    private static Object recycle(Map<Object, Object> recycler, Object object) {
        if (object != null) {
            if (OSHelper.isJdk8Above() && object instanceof String) {
                return ((String)object).intern();
            }
            if (recycler.containsKey(object)) {
                return recycler.get(object);
            }
            recycler.put(object, object);
            return object;
        }
        return null;
    }

    private void autoConvert() {
        NumberFormat[] doubleFormats = new NumberFormat[]{NumberFormat.getCurrencyInstance(Locale.US), NumberFormat.getPercentInstance()};
        DateFormat[] dateFormats = new SimpleDateFormat[]{new SimpleDateFormat("MM/dd/yyyy"), new SimpleDateFormat("MM/dd/yy"), new SimpleDateFormat("yyyy-MM-dd"), new SimpleDateFormat("dd.MM.yyyy HH:mm:ss")};
        String[] wktTypes = new String[]{"SRID", "POINT", "LINESTRING", "LINEARRING", "POLYGON", "MULTIPOINT", "MULTILINESTRING", "MULTIPOLYGON", "GEOMETRYCOLLECTION"};
        boolean fireEvent = false;
        for (int column = 0; column < this.getColumnCount(); ++column) {
            this.convertToCommon(column);
            if (this.isConvertableToDouble(doubleFormats, column)) {
                if (this.isConvertableToInteger(column)) {
                    this.convertToInteger(column);
                } else {
                    this.convertToDouble(doubleFormats, column);
                }
                fireEvent = true;
                continue;
            }
            DateFormat dateFormat = this.isConvertableToDate(dateFormats, column);
            if (dateFormat != null) {
                this.convertToDate(dateFormat, column);
                fireEvent = true;
                continue;
            }
            if (this.isConvertableToURL(column)) {
                this.convertToURL(column);
                fireEvent = true;
                continue;
            }
            if (this.isConvertableToGeometry(column, wktTypes)) {
                this.convertToGeometry(column, wktTypes);
                fireEvent = true;
                continue;
            }
            if (this.isConvertableToByteArray(column)) {
                this.convertToByteArray(column);
                fireEvent = true;
                continue;
            }
            if (!this.isConvertableToColor(column)) continue;
            this.convertToColor(column);
            fireEvent = true;
        }
        if (fireEvent) {
            this.fireTableDataChanged();
        }
    }

    private void convertToColor(int column) {
        this.classes[column] = Color.class;
        for (int row = 0; row < this.getRowCount(); ++row) {
            Object v = this.getValueAt(row, column);
            if (v == null) continue;
            if (v instanceof String) {
                String s = ((String)v).trim();
                if (!s.equals("")) {
                    boolean parsed = false;
                    if (s.startsWith("#") && s.length() == 7 || s.length() == 9) {
                        try {
                            this.objects[column][row] = ColorHelper.parseHTMLColor((String)s);
                            parsed = true;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (parsed) continue;
                    this.objects[column][row] = null;
                    continue;
                }
                this.objects[column][row] = null;
                continue;
            }
            if (v instanceof Color) continue;
            this.objects[column][row] = null;
        }
    }

    private boolean isConvertableToColor(int column) {
        try {
            if (this.getColumnClass(column) != Color.class) {
                boolean allNull = true;
                for (int row = 0; row < this.getRowCount(); ++row) {
                    Object v = this.getValueAt(row, column);
                    if (v == null) continue;
                    if (v instanceof String) {
                        String s = ((String)v).trim();
                        if (s.equals("")) continue;
                        allNull = false;
                        boolean parsed = false;
                        if (s.startsWith("#") && s.length() == 7 || s.length() == 9) {
                            try {
                                ColorHelper.parseHTMLColor((String)s);
                                parsed = true;
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (parsed) continue;
                        return false;
                    }
                    if (v instanceof Color) continue;
                    return false;
                }
                return !allNull;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void convertToByteArray(int column) {
        this.classes[column] = byte[].class;
        for (int row = 0; row < this.getRowCount(); ++row) {
            Object v = this.getValueAt(row, column);
            if (v == null) continue;
            if (v instanceof String) {
                String s = ((String)v).trim();
                if (!s.equals("")) {
                    boolean parsed = false;
                    try {
                        this.objects[column][row] = TypeHelper.parseBase64CompressedBinary((String)s);
                        parsed = true;
                    }
                    catch (DataFormatException dataFormatException) {
                        // empty catch block
                    }
                    if (parsed) continue;
                    this.objects[column][row] = null;
                    continue;
                }
                this.objects[column][row] = null;
                continue;
            }
            if (v instanceof byte[]) continue;
            this.objects[column][row] = null;
        }
    }

    private boolean isConvertableToByteArray(int column) {
        try {
            if (this.getColumnClass(column) == byte[].class) {
                boolean allNull = true;
                for (int row = 0; row < this.getRowCount(); ++row) {
                    Object v = this.getValueAt(row, column);
                    if (v == null) continue;
                    if (v instanceof String) {
                        String s = ((String)v).trim();
                        if (s.equals("")) continue;
                        allNull = false;
                        boolean parsed = false;
                        try {
                            TypeHelper.parseBase64CompressedBinary((String)s);
                            parsed = true;
                        }
                        catch (DataFormatException dataFormatException) {
                            // empty catch block
                        }
                        if (parsed) continue;
                        return false;
                    }
                    if (v instanceof byte[]) continue;
                    return false;
                }
                return !allNull;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void convertToGeometry(int column, String[] types) {
        this.classes[column] = Geometry.class;
        for (int row = 0; row < this.getRowCount(); ++row) {
            Object v = this.getValueAt(row, column);
            if (v == null) continue;
            if (v instanceof String) {
                String s = ((String)v).trim();
                if (!s.equals("")) {
                    boolean parsed = false;
                    boolean found = false;
                    for (String type : types) {
                        if (!s.startsWith(type)) continue;
                        found = true;
                    }
                    if (!found) {
                        this.objects[column][row] = null;
                    }
                    try {
                        WKTReader reader = new WKTReader();
                        this.objects[column][row] = reader.read(s);
                        parsed = true;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (parsed) continue;
                    this.objects[column][row] = null;
                    continue;
                }
                this.objects[column][row] = null;
                continue;
            }
            if (v instanceof Geometry) continue;
            this.objects[column][row] = null;
        }
    }

    private boolean isConvertableToGeometry(int column, String[] types) {
        try {
            if (!Geometry.class.isAssignableFrom(this.getColumnClass(column))) {
                boolean allNull = true;
                for (int row = 0; row < this.getRowCount(); ++row) {
                    Object v = this.getValueAt(row, column);
                    if (v == null) continue;
                    if (v instanceof String) {
                        String s = ((String)v).trim();
                        if (s.equals("")) continue;
                        allNull = false;
                        boolean parsed = false;
                        boolean found = false;
                        for (String type : types) {
                            if (!s.startsWith(type)) continue;
                            found = true;
                        }
                        if (!found) {
                            return false;
                        }
                        try {
                            WKTReader reader = new WKTReader();
                            reader.read(s);
                            parsed = true;
                        }
                        catch (org.locationtech.jts.io.ParseException parseException) {
                            // empty catch block
                        }
                        if (parsed) continue;
                        return false;
                    }
                    if (v instanceof Geometry) continue;
                    return false;
                }
                return !allNull;
            }
            return false;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
        catch (RuntimeException e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void convertToURL(int column) {
        this.classes[column] = URL.class;
        for (int row = 0; row < this.getRowCount(); ++row) {
            Object v = this.getValueAt(row, column);
            if (v == null) continue;
            if (v instanceof String) {
                String s = ((String)v).trim();
                if (!s.equals("")) {
                    boolean parsed = false;
                    try {
                        this.objects[column][row] = new URL(s);
                        parsed = true;
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                    if (parsed) continue;
                    this.objects[column][row] = null;
                    continue;
                }
                this.objects[column][row] = null;
                continue;
            }
            if (v instanceof URL) continue;
            this.objects[column][row] = null;
        }
    }

    private boolean isConvertableToURL(int column) {
        if (this.getColumnClass(column) != URL.class) {
            boolean allNull = true;
            for (int row = 0; row < this.getRowCount(); ++row) {
                Object v = this.getValueAt(row, column);
                if (v == null) continue;
                if (v instanceof String) {
                    String s = ((String)v).trim();
                    if (s.equals("")) continue;
                    allNull = false;
                    boolean parsed = false;
                    try {
                        new URL(s);
                        parsed = true;
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                    if (parsed) continue;
                    return false;
                }
                if (v instanceof URL) continue;
                return false;
            }
            return !allNull;
        }
        return false;
    }

    private void convertToDate(DateFormat dateFormat, int column) {
        this.classes[column] = Date.class;
        for (int row = 0; row < this.getRowCount(); ++row) {
            Object v = this.getValueAt(row, column);
            if (v == null) continue;
            if (v instanceof String) {
                String s = ((String)v).trim();
                if (!s.equals("")) {
                    boolean parsed = false;
                    try {
                        this.objects[column][row] = SimpleTableModel.parse(dateFormat, s);
                        parsed = true;
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                    if (parsed) continue;
                    this.objects[column][row] = null;
                    continue;
                }
                this.objects[column][row] = null;
                continue;
            }
            if (v instanceof Date) continue;
            this.objects[column][row] = null;
        }
    }

    private DateFormat isConvertableToDate(DateFormat[] dateFormats, int column) {
        if (this.getColumnClass(column) != Date.class) {
            for (DateFormat format : dateFormats) {
                if (!this.isConvertableToDate(column, format)) continue;
                return format;
            }
            return null;
        }
        return null;
    }

    private boolean isConvertableToDate(int column, DateFormat format) {
        boolean allNull = true;
        for (int row = 0; row < this.getRowCount(); ++row) {
            Object v = this.getValueAt(row, column);
            if (v == null) continue;
            if (v instanceof String) {
                String s = ((String)v).trim();
                if (s.equals("")) continue;
                allNull = false;
                boolean parsed = false;
                try {
                    SimpleTableModel.parse(format, s);
                    parsed = true;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                if (parsed) continue;
                return false;
            }
            if (v instanceof Date) continue;
            return false;
        }
        return !allNull;
    }

    private void convertToInteger(int column) {
        this.classes[column] = Integer.class;
        for (int row = 0; row < this.getRowCount(); ++row) {
            Object v = this.getValueAt(row, column);
            if (v == null) continue;
            if (v instanceof String) {
                String s = ((String)v).trim();
                if (!s.equals("")) {
                    try {
                        this.objects[column][row] = Integer.valueOf(s);
                    }
                    catch (NumberFormatException e) {
                        this.objects[column][row] = null;
                    }
                    continue;
                }
                this.objects[column][row] = null;
                continue;
            }
            if (v instanceof Integer) continue;
            this.objects[column][row] = null;
        }
    }

    private boolean isConvertableToInteger(int column) {
        if (this.getColumnClass(column) != Integer.class) {
            boolean allNull = true;
            for (int row = 0; row < this.getRowCount(); ++row) {
                Object v = this.getValueAt(row, column);
                if (v == null) continue;
                if (v instanceof String) {
                    String s = ((String)v).trim();
                    if (s.equals("")) continue;
                    allNull = false;
                    try {
                        Integer.parseInt(s);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }
                if (v instanceof Integer) continue;
                return false;
            }
            return !allNull;
        }
        return false;
    }

    private void convertToDouble(NumberFormat[] doubleFormats, int column) {
        this.classes[column] = Double.class;
        for (int row = 0; row < this.getRowCount(); ++row) {
            Object v = this.getValueAt(row, column);
            if (v == null) continue;
            if (v instanceof String) {
                String s = ((String)v).trim();
                if (!s.equals("")) {
                    try {
                        this.objects[column][row] = Double.valueOf(s);
                    }
                    catch (NumberFormatException e) {
                        boolean parsed = false;
                        for (NumberFormat format : doubleFormats) {
                            try {
                                this.objects[column][row] = SimpleTableModel.parse(format, s);
                                parsed = true;
                            }
                            catch (ParseException parseException) {
                                // empty catch block
                            }
                        }
                        if (parsed) continue;
                        this.objects[column][row] = null;
                    }
                    continue;
                }
                this.objects[column][row] = null;
                continue;
            }
            if (!(v instanceof Double) && v instanceof Number) {
                this.objects[column][row] = ((Number)v).doubleValue();
                continue;
            }
            if (v instanceof Double) continue;
            this.objects[column][row] = null;
        }
    }

    private boolean isConvertableToDouble(NumberFormat[] doubleFormats, int column) {
        if (this.getColumnClass(column) != Integer.class && this.getColumnClass(column) != Double.class) {
            boolean allNull = true;
            for (int row = 0; row < this.getRowCount(); ++row) {
                Object v = this.getValueAt(row, column);
                if (v == null) continue;
                if (v instanceof String) {
                    String s = ((String)v).trim();
                    if (s.equals("")) continue;
                    allNull = false;
                    try {
                        Double.valueOf(s);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        boolean parsed = false;
                        for (NumberFormat format : doubleFormats) {
                            try {
                                SimpleTableModel.parse(format, s);
                                parsed = true;
                            }
                            catch (ParseException parseException) {
                                // empty catch block
                            }
                        }
                        if (parsed) continue;
                        return false;
                    }
                }
                if (!(v instanceof Double) && v instanceof Number) {
                    return true;
                }
                if (v instanceof Double) continue;
                return false;
            }
            return !allNull;
        }
        return false;
    }

    private void convertToCommon(int column) {
        boolean allNull = true;
        Class<?> common = null;
        for (int row = 0; row < this.getRowCount(); ++row) {
            Object v = this.getValueAt(row, column);
            if (v == null) continue;
            if (common == null) {
                common = v.getClass();
                allNull = false;
                continue;
            }
            if (common == v.getClass()) continue;
            common = null;
            break;
        }
        if (!allNull && common != null) {
            this.classes[column] = common;
        }
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public int getColumnCount() {
        return this.names.length;
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.objects[column][row];
    }

    public SimpleTableModel(TableModel tableModel, boolean autoConvert) {
        this(tableModel, autoConvert, true);
    }

    public SimpleTableModel(TableModel tableModel, ColumnsConverter converter) {
        this.names = new String[tableModel.getColumnCount()];
        this.classes = new Class[tableModel.getColumnCount()];
        this.objects = new Object[tableModel.getColumnCount()][tableModel.getRowCount()];
        for (int column = 0; column < tableModel.getColumnCount(); ++column) {
            this.names[column] = converter.getColumnName(tableModel, column);
            this.classes[column] = converter.getColumnClass(tableModel, column);
            for (int row = 0; row < tableModel.getRowCount(); ++row) {
                this.objects[column][row] = converter.getValueAt(tableModel, row, column);
            }
        }
        this.rowCount = tableModel.getRowCount();
    }

    @Override
    public String getColumnName(int column) {
        return this.names[column];
    }

    public Class getColumnClass(int column) {
        return this.classes[column];
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.objects[columnIndex][rowIndex] = aValue;
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int column;
        out.writeInt(10000);
        out.writeInt(this.getRowCount());
        out.writeInt(this.getColumnCount());
        for (column = 0; column < this.getColumnCount(); ++column) {
            out.writeUTF(this.names[column]);
        }
        for (column = 0; column < this.getColumnCount(); ++column) {
            out.writeObject(this.classes[column]);
        }
        for (int row = 0; row < this.getRowCount(); ++row) {
            for (int column2 = 0; column2 < this.getColumnCount(); ++column2) {
                out.writeBoolean(this.isAvailable(row, column2));
            }
        }
        for (column = 0; column < this.getColumnCount(); ++column) {
            Class cl = this.getColumnClass(column);
            if (cl == Double.class) {
                for (int row = 0; row < this.getRowCount(); ++row) {
                    if (!this.isAvailable(row, column)) continue;
                    out.writeDouble((Double)this.objects[column][row]);
                }
                continue;
            }
            if (cl == Float.class) {
                for (int row = 0; row < this.getRowCount(); ++row) {
                    if (!this.isAvailable(row, column)) continue;
                    out.writeFloat(((Float)this.objects[column][row]).floatValue());
                }
                continue;
            }
            if (cl == Long.class) {
                for (int row = 0; row < this.getRowCount(); ++row) {
                    if (!this.isAvailable(row, column)) continue;
                    out.writeLong((Long)this.objects[column][row]);
                }
                continue;
            }
            if (cl == Integer.class) {
                for (int row = 0; row < this.getRowCount(); ++row) {
                    if (!this.isAvailable(row, column)) continue;
                    out.writeInt((Integer)this.objects[column][row]);
                }
                continue;
            }
            if (cl == Short.class) {
                for (int row = 0; row < this.getRowCount(); ++row) {
                    if (!this.isAvailable(row, column)) continue;
                    out.writeShort(((Short)this.objects[column][row]).shortValue());
                }
                continue;
            }
            if (cl == Byte.class) {
                for (int row = 0; row < this.getRowCount(); ++row) {
                    if (!this.isAvailable(row, column)) continue;
                    out.writeByte(((Byte)this.objects[column][row]).byteValue());
                }
                continue;
            }
            if (cl == Boolean.class) {
                for (int row = 0; row < this.getRowCount(); ++row) {
                    if (!this.isAvailable(row, column)) continue;
                    out.writeBoolean((Boolean)this.objects[column][row]);
                }
                continue;
            }
            if (cl == BufferedImage.class) {
                for (int row = 0; row < this.getRowCount(); ++row) {
                    if (!this.isAvailable(row, column)) continue;
                    boolean useCache = ImageIO.getUseCache();
                    ImageIO.setUseCache(false);
                    ByteArrayOutputStream bao = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)((BufferedImage)this.objects[column][row]), "png", bao);
                    byte[] ba = bao.toByteArray();
                    out.writeObject(ba);
                    ImageIO.setUseCache(useCache);
                }
                continue;
            }
            if (Geometry.class.isAssignableFrom(cl)) {
                WKBWriter writer = new WKBWriter();
                for (int row = 0; row < this.getRowCount(); ++row) {
                    if (!this.isAvailable(row, column)) continue;
                    byte[] write = writer.write((Geometry)this.objects[column][row]);
                    out.writeObject(write);
                }
                continue;
            }
            for (int row = 0; row < this.getRowCount(); ++row) {
                if (!this.isAvailable(row, column)) continue;
                out.writeObject(this.objects[column][row]);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version > 0) {
            int column;
            int rowCount = in.readInt();
            int columnCount = in.readInt();
            String[] names = new String[columnCount];
            Class[] classes = new Class[columnCount];
            Object[][] objects = new Object[columnCount][rowCount];
            for (column = 0; column < columnCount; ++column) {
                names[column] = in.readUTF();
            }
            for (column = 0; column < columnCount; ++column) {
                classes[column] = (Class)in.readObject();
            }
            boolean[][] isAvailable = new boolean[columnCount][rowCount];
            for (int row = 0; row < rowCount; ++row) {
                for (int column2 = 0; column2 < columnCount; ++column2) {
                    isAvailable[column2][row] = in.readBoolean();
                }
            }
            for (int column3 = 0; column3 < columnCount; ++column3) {
                byte[] array;
                Class cl = classes[column3];
                Object[] c = objects[column3];
                boolean[] cIsAvailable = isAvailable[column3];
                if (cl == Double.class) {
                    for (int row = 0; row < rowCount; ++row) {
                        if (!cIsAvailable[row]) continue;
                        c[row] = in.readDouble();
                    }
                    continue;
                }
                if (cl == Float.class) {
                    for (int row = 0; row < rowCount; ++row) {
                        if (!cIsAvailable[row]) continue;
                        c[row] = Float.valueOf(in.readFloat());
                    }
                    continue;
                }
                if (cl == Long.class) {
                    for (int row = 0; row < rowCount; ++row) {
                        if (!cIsAvailable[row]) continue;
                        c[row] = in.readLong();
                    }
                    continue;
                }
                if (cl == Integer.class) {
                    for (int row = 0; row < rowCount; ++row) {
                        if (!cIsAvailable[row]) continue;
                        c[row] = in.readInt();
                    }
                    continue;
                }
                if (cl == Short.class) {
                    for (int row = 0; row < rowCount; ++row) {
                        if (!cIsAvailable[row]) continue;
                        c[row] = in.readShort();
                    }
                    continue;
                }
                if (cl == Byte.class) {
                    for (int row = 0; row < rowCount; ++row) {
                        if (!cIsAvailable[row]) continue;
                        Byte o = in.readByte();
                        c[row] = o;
                    }
                    continue;
                }
                if (cl == Boolean.class) {
                    for (int row = 0; row < rowCount; ++row) {
                        if (!cIsAvailable[row]) continue;
                        c[row] = in.readBoolean();
                    }
                    continue;
                }
                if (cl == BufferedImage.class) {
                    for (int row = 0; row < rowCount; ++row) {
                        if (!cIsAvailable[row]) continue;
                        boolean useCache = ImageIO.getUseCache();
                        ImageIO.setUseCache(false);
                        array = (byte[])in.readObject();
                        ByteArrayInputStream bai = new ByteArrayInputStream(array);
                        BufferedImage o = ImageIO.read(bai);
                        ImageIO.setUseCache(useCache);
                        c[row] = o;
                    }
                    continue;
                }
                if (Geometry.class.isAssignableFrom(cl)) {
                    WKBReader reader = new WKBReader();
                    for (int row = 0; row < rowCount; ++row) {
                        if (!cIsAvailable[row]) continue;
                        array = (byte[])in.readObject();
                        try {
                            c[row] = reader.read(array);
                            continue;
                        }
                        catch (org.locationtech.jts.io.ParseException e) {
                            e.printStackTrace();
                        }
                    }
                    continue;
                }
                for (int row = 0; row < rowCount; ++row) {
                    if (!cIsAvailable[row]) continue;
                    c[row] = in.readObject();
                }
            }
            this.rowCount = rowCount;
            this.names = names;
            this.classes = classes;
            this.objects = objects;
        }
    }

    private boolean isAvailable(int row, int column) {
        return this.objects[column][row] != null;
    }

    private static Object parse(Format format, String s) throws ParseException {
        ParsePosition pp = new ParsePosition(0);
        Object value = format.parseObject(s, pp);
        if (s.length() != pp.getIndex() || value == null) {
            throw new ParseException(s, pp.getIndex());
        }
        return value;
    }

    public static interface ColumnsConverter {
        public Class getColumnClass(TableModel var1, int var2);

        public String getColumnName(TableModel var1, int var2);

        public Object getValueAt(TableModel var1, int var2, int var3);
    }
}

