/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.type;

public class StringNumber<T extends Number>
extends Number
implements Comparable {
    private static final long serialVersionUID = -6667383645641637133L;
    protected T value;
    protected String string;

    public StringNumber() {
    }

    public StringNumber(T value, String string) {
        this.value = value;
        this.string = string;
    }

    @Override
    public int intValue() {
        return ((Number)this.value).intValue();
    }

    @Override
    public long longValue() {
        return ((Number)this.value).longValue();
    }

    @Override
    public float floatValue() {
        if (this.value != null) {
            return ((Number)this.value).floatValue();
        }
        return Float.NaN;
    }

    @Override
    public double doubleValue() {
        if (this.value != null) {
            return ((Number)this.value).doubleValue();
        }
        return Double.NaN;
    }

    public T getValue() {
        return this.value;
    }

    public String getString() {
        return this.string;
    }

    public int compareTo(Object o) {
        return Double.compare(this.doubleValue(), ((Number)o).doubleValue());
    }

    public String toString() {
        return this.string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StringNumber)) {
            return false;
        }
        StringNumber that = (StringNumber)o;
        return this.getValue() != null ? this.getValue().equals(that.getValue()) : that.getValue() == null;
    }

    public int hashCode() {
        return this.getValue() != null ? this.getValue().hashCode() : 0;
    }
}

