/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.type.convert;

import com.macrofocus.common.convert.TypeConverter;
import com.macrofocus.helper.ColorHelper;
import java.awt.Color;

public class ToColorTypeConverter
implements TypeConverter {
    public boolean isConvertable(TypeConverter.Input input) {
        try {
            if (input.getType() != Color.class) {
                boolean allNull = true;
                for (int row = 0; row < input.size(); ++row) {
                    Object v = input.get(row);
                    if (v == null) continue;
                    if (v instanceof String) {
                        String s = ((String)v).trim();
                        if (s.equals("")) continue;
                        allNull = false;
                        boolean parsed = false;
                        if (s.startsWith("#") && s.length() == 7 || s.length() == 9) {
                            try {
                                ColorHelper.parseHTMLColor((String)s);
                                parsed = true;
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (parsed) continue;
                        return false;
                    }
                    if (v instanceof Color) continue;
                    return false;
                }
                return !allNull;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public Class convert(TypeConverter.Input input, TypeConverter.Output output) {
        for (int row = 0; row < input.size(); ++row) {
            Object v = input.get(row);
            if (v == null) continue;
            if (v instanceof String) {
                String s = ((String)v).trim();
                if (!s.equals("")) {
                    boolean parsed = false;
                    if (s.startsWith("#") && s.length() == 7 || s.length() == 9) {
                        try {
                            output.set(row, (Object)ColorHelper.parseHTMLColor((String)s));
                            parsed = true;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (parsed) continue;
                    output.set(row, null);
                    continue;
                }
                output.set(row, null);
                continue;
            }
            if (v instanceof Color) continue;
            output.set(row, null);
        }
        return Color.class;
    }

    public Class getType() {
        return Color.class;
    }
}

