/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.type.series;

import com.macrofocus.data.type.series.Series;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public final class IndexSeries<T>
implements Series<T> {
    private final SortedSet<T> set;
    private List<T> list;
    private final Class<? extends T> type;

    public IndexSeries(Series<T> series) {
        this.type = series.getType();
        this.set = new TreeSet<T>();
        this.add(series);
    }

    public void add(Series<T> series) {
        for (int i = 0; i < series.getItemCount(); ++i) {
            this.set.add(series.getValue(i));
        }
        this.list = new ArrayList<T>(this.set);
    }

    @Override
    public Class<? extends T> getType() {
        return this.type;
    }

    @Override
    public T getValue(int index) {
        return this.list.get(index);
    }

    @Override
    public int getItemCount() {
        return this.set.size();
    }

    public int getIndex(T value) {
        return this.list.indexOf(value);
    }

    public int getValueCount() {
        return this.list.size();
    }

    public Object getMin() {
        return this.set.first();
    }

    public Object getMax() {
        return this.set.last();
    }

    public boolean contains(T value) {
        return this.set.contains(value);
    }

    public List<T> getValueList() {
        return this.list;
    }
}

