/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.type.timeseries;

import com.macrofocus.data.type.timeseries.TimeSeries;
import java.util.ArrayList;
import java.util.List;

public final class CompositeTimeSeries<T>
implements TimeSeries {
    final List<TimeSeries> timeSeries;
    private Long min = Long.MAX_VALUE;
    private Long max = Long.MIN_VALUE;
    private int count = 0;
    private final Class type;

    public CompositeTimeSeries(TimeSeries<T> timeSeries) {
        this.timeSeries = new ArrayList<TimeSeries>();
        this.type = timeSeries.getType();
        this.addTimeSeries(timeSeries);
    }

    @Override
    public Class getType() {
        return this.type;
    }

    @Override
    public long getTime(int index) {
        int i = 0;
        for (TimeSeries timeSeries : this.timeSeries) {
            if (index < i + timeSeries.getItemCount()) {
                return timeSeries.getTime(index - i);
            }
            i += timeSeries.getItemCount();
        }
        return 0L;
    }

    @Override
    public Object getValue(int index) {
        int i = 0;
        for (TimeSeries timeSeries : this.timeSeries) {
            if (index < i + timeSeries.getItemCount()) {
                return timeSeries.getValue(index - i);
            }
            i += timeSeries.getItemCount();
        }
        return 0;
    }

    @Override
    public int getItemCount() {
        return this.count;
    }

    @Override
    public long getMinTime() {
        return this.min;
    }

    @Override
    public long getMaxTime() {
        return this.max;
    }

    public void addTimeSeries(TimeSeries<T> timeSeries) {
        this.timeSeries.add(timeSeries);
        long min = timeSeries.getMinTime();
        long max = timeSeries.getMaxTime();
        if (min < this.min) {
            this.min = min;
        }
        if (max > this.max) {
            this.max = max;
        }
        this.count += timeSeries.getItemCount();
    }
}

