/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.type.timeseries;

import com.macrofocus.data.type.timeseries.Event;
import com.macrofocus.data.type.timeseries.TimeSeries;
import java.util.ArrayList;
import java.util.List;

public final class EventTimeSeries<T extends Event>
implements TimeSeries<T> {
    private final List<T> events;
    private Long min = Long.MAX_VALUE;
    private Long max = Long.MIN_VALUE;
    private final Class<? extends T> type;
    private List<Listener> listeners = new ArrayList<Listener>();
    private Event.Listener eventListener = new Event.Listener(){

        @Override
        public void eventChanged() {
            EventTimeSeries.this.updateMinMax();
            EventTimeSeries.this.notifyTimeSeriesChanged();
        }
    };

    public EventTimeSeries(Class<? extends T> type) {
        this.type = type;
        this.events = new ArrayList<T>();
    }

    @Override
    public Class<? extends T> getType() {
        return this.type;
    }

    @Override
    public long getTime(int index) {
        return ((Event)this.events.get(index)).getTime();
    }

    @Override
    public T getValue(int index) {
        return (T)((Event)this.events.get(index));
    }

    @Override
    public int getItemCount() {
        return this.events.size();
    }

    @Override
    public long getMinTime() {
        return this.min;
    }

    @Override
    public long getMaxTime() {
        return this.max;
    }

    public void addEvent(T event) {
        event.addEventListener(this.eventListener);
        this.events.add(event);
        if (event.getTime() < this.min) {
            this.min = event.getTime();
        }
        if (event.getTime() > this.max) {
            this.max = event.getTime();
        }
        this.notifyTimeSeriesChanged();
    }

    public void removeEvent(T event) {
        event.removeEventListener(this.eventListener);
        this.events.remove(event);
        this.updateMinMax();
        this.notifyTimeSeriesChanged();
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public void notifyTimeSeriesChanged() {
        for (Listener listener : this.listeners) {
            listener.timeSeriesChanged();
        }
    }

    private void updateMinMax() {
        this.min = Long.MAX_VALUE;
        this.max = Long.MIN_VALUE;
        for (Event event : this.events) {
            if (event.getTime() < this.min) {
                this.min = event.getTime();
            }
            if (event.getTime() <= this.max) continue;
            this.max = event.getTime();
        }
    }

    public static interface Listener {
        public void timeSeriesChanged();
    }
}

