/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.type.timeseries;

import com.macrofocus.data.type.timeseries.TimeSeries;
import java.util.ArrayList;
import java.util.List;

public final class SimpleTimeSeries<T>
implements TimeSeries<T> {
    private final List<Long> times;
    private final List<T> values;
    private Long min = Long.MAX_VALUE;
    private Long max = Long.MIN_VALUE;
    private final Class<? extends T> type;

    public SimpleTimeSeries(TimeSeries<T> timeSeries) {
        this(timeSeries.getType());
        for (int i = 0; i < timeSeries.getItemCount(); ++i) {
            this.addValue(timeSeries.getTime(i), timeSeries.getValue(i));
        }
    }

    public SimpleTimeSeries(Class<? extends T> type) {
        this.type = type;
        this.times = new ArrayList<Long>();
        this.values = new ArrayList<T>();
    }

    @Override
    public Class<? extends T> getType() {
        return this.type;
    }

    @Override
    public long getTime(int index) {
        return this.times.get(index);
    }

    @Override
    public T getValue(int index) {
        return this.values.get(index);
    }

    @Override
    public int getItemCount() {
        return this.times.size();
    }

    @Override
    public long getMinTime() {
        return this.min;
    }

    @Override
    public long getMaxTime() {
        return this.max;
    }

    public void addValue(Long time, T value) {
        this.times.add(time);
        this.values.add(value);
        if (time < this.min) {
            this.min = time;
        }
        if (time > this.max) {
            this.max = time;
        }
    }
}

