/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.font;

import com.macrofocus.font.FontModel;
import java.awt.Font;
import java.util.StringTokenizer;

public class SimpleFontModel
implements FontModel {
    private final Font font;

    public SimpleFontModel(Font font) {
        this.font = font;
    }

    public SimpleFontModel(String fontName) {
        StringTokenizer st = new StringTokenizer(fontName, ",");
        String name = st.nextToken().trim();
        String style = st.nextToken().trim();
        int styleId = 0;
        if (style.equals("java.awt.Font.PLAIN") || style.equals("Font.PLAIN")) {
            styleId = 0;
        } else if (style.equals("java.awt.Font.BOLD") || style.equals("Font.BOLD")) {
            styleId = 1;
        } else if (style.equals("java.awt.Font.ITALIC") || style.equals("Font.ITALIC")) {
            styleId = 2;
        }
        int size = Integer.valueOf(st.nextToken().trim());
        this.font = new Font(name, styleId, size);
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    public String toString() {
        String s = this.font.getStyle() == 1 ? "java.awt.Font.BOLD" : (this.font.getStyle() == 2 ? "java.awt.Font.ITALIC" : "java.awt.Font.PLAIN");
        String value = this.font.getName() + "," + s + "," + this.font.getSize();
        return value;
    }
}

