/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.minmax;

import com.macrofocus.data.matrix.vector.VectorModel;
import com.macrofocus.util.minmax.MinmaxModel;

public class CenterAverageMinmaxModel
implements MinmaxModel {
    private double average;
    private double maxDeviation;

    public CenterAverageMinmaxModel(VectorModel vectorModel) {
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        int count = 0;
        double sum = 0.0;
        for (int row = 0; row < vectorModel.getRowCount(); ++row) {
            if (!vectorModel.isAvailable(row)) continue;
            double value = vectorModel.getDouble(row);
            sum += value;
            ++count;
            if (value < min) {
                min = value;
            }
            if (!(value > max)) continue;
            max = value;
        }
        this.average = sum / (double)count;
        this.maxDeviation = Math.abs(min - this.average) > Math.abs(max - this.average) ? this.average - min : max - this.average;
    }

    @Override
    public double getMinimum() {
        return this.average - this.maxDeviation;
    }

    @Override
    public double getMaximum() {
        return this.average + this.maxDeviation;
    }

    public String toString() {
        return this.getClass().getName() + "[min=" + this.getMinimum() + ",max=" + this.getMaximum() + "]";
    }
}

