/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.minmax;

import com.macrofocus.data.matrix.MatrixModel;
import com.macrofocus.data.matrix.vector.VectorModel;
import com.macrofocus.util.minmax.MinmaxModel;

public class SimpleMinmaxModel
implements MinmaxModel {
    private double rangeMin;
    private double rangeMax;

    public SimpleMinmaxModel(double rangeMin, double rangeMax) {
        this.rangeMin = rangeMin;
        this.rangeMax = rangeMax;
    }

    public SimpleMinmaxModel(MatrixModel matrixModel, int columnIndex) {
        this.rangeMin = Double.MAX_VALUE;
        this.rangeMax = -1.7976931348623157E308;
        for (int row = 0; row < matrixModel.getRowCount(); ++row) {
            if (!matrixModel.isAvailable(row, columnIndex)) continue;
            double value = matrixModel.getDouble(row, columnIndex);
            if (value < this.rangeMin) {
                this.rangeMin = value;
            }
            if (!(value > this.rangeMax)) continue;
            this.rangeMax = value;
        }
    }

    public SimpleMinmaxModel(MatrixModel matrixModel, Object column) {
        this(matrixModel, matrixModel.getColumnIndex(column));
    }

    public SimpleMinmaxModel(VectorModel vectorModel) {
        this.rangeMin = Double.MAX_VALUE;
        this.rangeMax = -1.7976931348623157E308;
        for (int row = 0; row < vectorModel.getRowCount(); ++row) {
            if (!vectorModel.isAvailable(row)) continue;
            double value = vectorModel.getDouble(row);
            if (value < this.rangeMin) {
                this.rangeMin = value;
            }
            if (!(value > this.rangeMax)) continue;
            this.rangeMax = value;
        }
    }

    public SimpleMinmaxModel(MinmaxModel minmaxModel1, MinmaxModel minmaxModel2) {
        this.rangeMin = minmaxModel1.getMinimum() < minmaxModel2.getMinimum() ? minmaxModel1.getMinimum() : minmaxModel2.getMinimum();
        this.rangeMax = minmaxModel1.getMaximum() > minmaxModel2.getMaximum() ? minmaxModel1.getMaximum() : minmaxModel2.getMaximum();
    }

    @Override
    public double getMinimum() {
        return this.rangeMin;
    }

    @Override
    public double getMaximum() {
        return this.rangeMax;
    }

    public String toString() {
        return this.getClass().getName() + "[rangeMin=" + this.rangeMin + ",rangeMax=" + this.rangeMax + "]";
    }
}

