/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.ole;

import com.macrofocus.util.ole.BlockModel;

public class AbstractBlockModel
implements BlockModel {
    private byte[] block;

    public AbstractBlockModel(byte[] block) {
        this.block = block;
    }

    protected int toInt(int i) {
        int intValue = this.block[i];
        if (intValue < 0) {
            intValue += 256;
        }
        return intValue;
    }

    protected int toInt2(int i) {
        return this.toInt(i + 0) + (this.toInt(i + 1) << 8);
    }

    protected int toInt4(int i) {
        return this.toInt(i + 0) + (this.toInt(i + 1) << 8) + (this.toInt(i + 2) << 16) + (this.toInt(i + 3) << 24);
    }

    protected String getString(int i, int count) {
        char[] chars = new char[count / 2 - 1];
        for (int j = 0; j < count / 2 - 1; ++j) {
            chars[j] = (char)(this.block[i + j * 2] + (this.block[i + j * 2 + 1] << 8));
        }
        return new String(chars);
    }

    private String dump() {
        String s = "";
        for (int i = 0; i < this.block.length; ++i) {
            s = s + this.toHexString(this.block[i]) + " ";
            if ((i + 1) % 16 != 0) continue;
            s = s + "\n";
        }
        return s;
    }

    private String toHexString(byte value) {
        int hex = value;
        if (hex < 0) {
            hex += 256;
        }
        if (hex >= 16) {
            return Integer.toHexString(hex);
        }
        return "0" + Integer.toHexString(hex);
    }

    public String toString() {
        return this.dump();
    }
}

