/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.ole.biff;

import com.macrofocus.common.logging.Logging;
import com.macrofocus.util.ole.OleInputStream;
import com.macrofocus.util.ole.biff.BiffModel;
import com.macrofocus.util.ole.biff.record.BofRecordModel;
import com.macrofocus.util.ole.biff.record.BoundsheetRecordModel;
import com.macrofocus.util.ole.biff.record.ContinueRecordModel;
import com.macrofocus.util.ole.biff.record.DbcellRecordModel;
import com.macrofocus.util.ole.biff.record.EofRecordModel;
import com.macrofocus.util.ole.biff.record.ExtsstRecordModel;
import com.macrofocus.util.ole.biff.record.LabelRecordModel;
import com.macrofocus.util.ole.biff.record.LabelsstRecordModel;
import com.macrofocus.util.ole.biff.record.NumberRecordModel;
import com.macrofocus.util.ole.biff.record.RecordFactory;
import com.macrofocus.util.ole.biff.record.RecordModel;
import com.macrofocus.util.ole.biff.record.RkRecordModel;
import com.macrofocus.util.ole.biff.record.RowRecordModel;
import com.macrofocus.util.ole.biff.record.SstRecordModel;
import com.macrofocus.util.ole.biff.sheet.SheetModel;
import com.macrofocus.util.ole.biff.sheet.SimpleSheetModel;
import com.macrofocus.util.ole.biff.workbook.SimpleWorkbookModel;
import com.macrofocus.util.ole.biff.workbook.WorkbookModel;
import java.util.Hashtable;

public class SimpleBiffModel
implements BiffModel {
    OleInputStream streamModel;
    SstRecordModel sstRecordModel;
    private int bofCount = 0;
    private Hashtable sheets;

    public SimpleBiffModel(OleInputStream streamModel) {
        this.streamModel = streamModel;
        this.sstRecordModel = null;
        this.sheets = new Hashtable();
    }

    @Override
    public RecordModel getNextBiffRecordModel() {
        int type = this.streamModel.getShort();
        int dataLength = this.streamModel.getShort();
        return RecordFactory.createRecordModel(type, dataLength, this.streamModel);
    }

    @Override
    public SheetModel getNextSheetModel() {
        RecordModel recordModel;
        SheetModel sheetModel = null;
        RecordModel previousRecordModel = null;
        do {
            int position = this.streamModel.getReadCount();
            recordModel = this.getNextBiffRecordModel();
            if (recordModel instanceof BofRecordModel) {
                ++this.bofCount;
                int dt = ((BofRecordModel)recordModel).getDt();
                if (dt == 16) {
                    sheetModel = (SheetModel)this.sheets.get(position);
                }
            } else if (!(recordModel instanceof BoundsheetRecordModel)) {
                if (recordModel instanceof EofRecordModel) {
                    --this.bofCount;
                } else if (recordModel instanceof NumberRecordModel) {
                    NumberRecordModel numberRecordModel = (NumberRecordModel)recordModel;
                    sheetModel.setNumber(numberRecordModel.getRw(), numberRecordModel.getCol(), numberRecordModel.getNum());
                } else if (!(recordModel instanceof LabelRecordModel || recordModel instanceof SstRecordModel || recordModel instanceof ExtsstRecordModel || recordModel instanceof RkRecordModel)) {
                    if (recordModel instanceof LabelsstRecordModel) {
                        LabelsstRecordModel labelsstRecordModel = (LabelsstRecordModel)recordModel;
                        sheetModel.setString(labelsstRecordModel.getRw(), labelsstRecordModel.getCol(), this.sstRecordModel.getRgb(labelsstRecordModel.getIsst()));
                    } else if (recordModel instanceof RowRecordModel) {
                        RowRecordModel labelsstRecordModel = (RowRecordModel)recordModel;
                    } else if (!(recordModel instanceof DbcellRecordModel) && recordModel instanceof ContinueRecordModel && previousRecordModel != null) {
                        if (previousRecordModel instanceof SstRecordModel) {
                            SstRecordModel sstRecordModel = (SstRecordModel)previousRecordModel;
                            sstRecordModel.process((ContinueRecordModel)recordModel);
                        } else {
                            for (int i = 0; i < recordModel.getDataLength(); ++i) {
                                this.streamModel.getByte();
                            }
                        }
                    }
                }
            }
            if (recordModel instanceof ContinueRecordModel) continue;
            previousRecordModel = recordModel;
        } while (!(recordModel instanceof EofRecordModel));
        return sheetModel;
    }

    @Override
    public WorkbookModel getWorkbookModel() {
        int i;
        RecordModel recordModel;
        SimpleWorkbookModel workbookModel = new SimpleWorkbookModel();
        RecordModel previousRecordModel = null;
        do {
            if ((recordModel = this.getNextBiffRecordModel()) instanceof BofRecordModel) {
                int dt = ((BofRecordModel)recordModel).getDt();
                if (dt != 5) {
                    try {
                        throw new Exception();
                    }
                    catch (Exception e) {
                        Logging.getInstance().process((Throwable)e);
                    }
                }
            } else if (recordModel instanceof BoundsheetRecordModel) {
                SimpleSheetModel sheetModel = new SimpleSheetModel();
                BoundsheetRecordModel boundsheetRecordModel = (BoundsheetRecordModel)recordModel;
                sheetModel.setName(boundsheetRecordModel.getRgch());
                this.sheets.put(boundsheetRecordModel.getLbPlyPos(), sheetModel);
            } else if (recordModel instanceof SstRecordModel) {
                this.sstRecordModel = (SstRecordModel)recordModel;
            } else if (recordModel instanceof ContinueRecordModel && previousRecordModel != null) {
                if (previousRecordModel instanceof SstRecordModel) {
                    SstRecordModel sstRecordModel = (SstRecordModel)previousRecordModel;
                    sstRecordModel.process((ContinueRecordModel)recordModel);
                } else {
                    for (i = 0; i < recordModel.getDataLength(); ++i) {
                        this.streamModel.getByte();
                    }
                }
            }
            if (recordModel instanceof ContinueRecordModel) continue;
            previousRecordModel = recordModel;
        } while (!(recordModel instanceof EofRecordModel));
        while (this.streamModel.available() > 0) {
            SheetModel sheetModel = this.getNextSheetModel();
            if (sheetModel == null || sheetModel.getName() == null) continue;
            workbookModel.addSheetModel(sheetModel);
        }
        for (i = 0; i < this.sstRecordModel.getRgbCount(); ++i) {
        }
        return workbookModel;
    }
}

