/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.Popup;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.util.OS;
import java.awt.Component;
import java.lang.reflect.Method;
import javax.swing.JComponent;

public class PopupFactory
extends javax.swing.PopupFactory {
    private static PopupFactory popupFactory = new PopupFactory();
    private static javax.swing.PopupFactory storedPopupFactory;

    private PopupFactory() {
    }

    public static void install() {
        if (storedPopupFactory == null) {
            storedPopupFactory = PopupFactory.getSharedInstance();
            PopupFactory.setSharedInstance(popupFactory);
        }
    }

    public static void uninstall() {
        if (storedPopupFactory == null) {
            return;
        }
        PopupFactory.setSharedInstance(storedPopupFactory);
        storedPopupFactory = null;
    }

    @Override
    public javax.swing.Popup getPopup(Component owner, Component contents, int x, int y) {
        boolean heavyweight = false;
        if (owner instanceof JComponent) {
            Method m;
            JComponent c = (JComponent)owner;
            Integer type = (Integer)c.getClientProperty("Synthetica.popupType");
            if (type == null) {
                Integer n = type = SyntheticaLookAndFeel.get("Synthetica.popupType", c) == null ? null : Integer.valueOf(SyntheticaLookAndFeel.getInt("Synthetica.popupType", c));
            }
            if (type == null && OS.getCurrentOS() == OS.Mac && SyntheticaLookAndFeel.getBoolean("Synthetica.forceHeavyWeightPopupOnOSX.enabled", null, true) && SyntheticaLookAndFeel.getJVMCompatibilityMode() == SyntheticaLookAndFeel.JVMCompatibilityMode.SUN) {
                try {
                    m = javax.swing.PopupFactory.class.getDeclaredMethod("getPopupType", null);
                    m.setAccessible(true);
                    if ((Integer)m.invoke((Object)this, new Object[0]) == 1) {
                        type = 2;
                    }
                }
                catch (Exception e) {
                    new RuntimeException(e);
                }
            }
            if (type != null && type == 0) {
                heavyweight = false;
            } else if (type != null && type == 2) {
                heavyweight = true;
            } else if (type != null && SyntheticaLookAndFeel.getJVMCompatibilityMode() == SyntheticaLookAndFeel.JVMCompatibilityMode.SUN) {
                try {
                    m = javax.swing.PopupFactory.class.getDeclaredMethod("setPopupType", Integer.TYPE);
                    m.setAccessible(true);
                    m.invoke((Object)this, type);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        javax.swing.Popup popup = super.getPopup(owner, contents, x, y, heavyweight);
        return new Popup(owner, contents, x, y, popup);
    }
}

