/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.ExtKeyEventProcessor;
import de.javasoft.plaf.synthetica.Scalable;
import de.javasoft.plaf.synthetica.ScalableFont;
import de.javasoft.plaf.synthetica.ScalableIcon;
import de.javasoft.plaf.synthetica.ScalableImage;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaRootPaneUI;
import de.javasoft.plaf.synthetica.painter.SyntheticaPainter;
import de.javasoft.plaf.synthetica.util.DropShadow;
import de.javasoft.plaf.synthetica.util.OS;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicRootPaneUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;

public class SyntheticaTitlePane
extends JPanel {
    private static final long serialVersionUID = -6164225719742333375L;
    private static final String BUTTON_ID = "Synthetica.buttonID";
    private JRootPane rootPane;
    private SyntheticaRootPaneUI rootPaneUI;
    private Window window;
    private Frame frame;
    private Dialog dialog;
    protected JButton menuButton;
    protected JLabel titleLabel;
    private JLabel menuBarLabel;
    private Container userComponentContainer;
    protected JButton toggleButton;
    protected JButton iconifyButton;
    protected JButton closeButton;
    private JPopupMenu systemMenu;
    private Action closeAction;
    private Action iconifyAction;
    private Action restoreAction;
    private Action maximizeAction;
    private WindowListener windowListener;
    private PropertyChangeListener propertyChangeListener;
    private PropertyChangeListener rootPanePropertyChangeListener;
    private ContainerListener layeredPaneContainerListener;
    private ActionListener menuActionListener;
    private boolean selected = true;
    private boolean useMACStyle = false;
    private JInternalFrame iFrameDelegate = new JInternalFrame();

    public SyntheticaTitlePane(JRootPane root, BasicRootPaneUI ui) {
        this.rootPane = root;
        this.rootPaneUI = (SyntheticaRootPaneUI)ui;
        Container parent = this.rootPane.getParent();
        Window window = this.window = parent instanceof Window ? (Window)parent : SwingUtilities.getWindowAncestor(parent);
        if (this.window instanceof Frame) {
            this.frame = (Frame)this.window;
        } else if (this.window instanceof Dialog) {
            this.dialog = (Dialog)this.window;
        }
        this.useMACStyle = SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.titlePane.useMACStyleOnMAC", this.window, true);
        this.setOpaque(SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.titlePane.opaque", this.window, true));
        if (!this.isOpaque() && !SyntheticaLookAndFeel.isWindowOpacityEnabled(this.window)) {
            this.setDoubleBuffered(false);
        }
        this.setLayout(new GridBagLayout());
        this.setName("RootPane.titlePane");
        this.closeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SyntheticaTitlePane.this.close();
            }
        };
        int decorationStyle = this.rootPane.getWindowDecorationStyle();
        boolean showDialogIcon = SyntheticaLookAndFeel.getBoolean("Synthetica.dialog.icon.enabled", this.window);
        if (decorationStyle == 1 || decorationStyle == 3 || decorationStyle == 7 || decorationStyle == 8 || decorationStyle == 2 || showDialogIcon) {
            this.iconifyAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SyntheticaTitlePane.this.iconify();
                }
            };
            this.restoreAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SyntheticaTitlePane.this.restore();
                }
            };
            this.maximizeAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SyntheticaTitlePane.this.maximize();
                }
            };
            this.menuButton = this.createTitlePaneButton("RootPane.titlePane.menuButton");
            this.menuButton.putClientProperty("doNotCancelPopup", new JComboBox().getClientProperty("doNotCancelPopup"));
            this.menuButton.setIcon(this.getIcon(this.rootPane));
            this.menuButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    String osName = System.getProperty("os.name").toLowerCase();
                    if (evt.getClickCount() == 2 && osName.contains("windows")) {
                        SyntheticaTitlePane.this.closeAction.actionPerformed(new ActionEvent(evt.getSource(), evt.getID(), "doubleClick"));
                    }
                }
            });
            this.systemMenu = new JPopupMenu();
            this.systemMenu.putClientProperty("Synthetica.popupMenu.toplevel", false);
            this.addMenuItems(this.systemMenu);
        }
        this.titleLabel = new JLabel(" "){

            @Override
            public void updateUI() {
                super.updateUI();
                if (SyntheticaTitlePane.this.titleLabel != null) {
                    SyntheticaTitlePane.this.updateTitleLabel(SyntheticaTitlePane.this.window == null ? true : SyntheticaTitlePane.this.window.isActive());
                }
            }
        };
        this.titleLabel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.menuBarLabel = new JLabel(" ");
        this.menuBarLabel.setName("RootPane.menuBar");
        this.menuBarLabel.setBorder(new EmptyBorder(0, 0, 0, 0));
        boolean showMenuBar = this.showMenuBarInTitlePane();
        this.menuBarLabel.setVisible(showMenuBar);
        if (showMenuBar) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SyntheticaTitlePane.this.menuBarLabel.setPreferredSize(SyntheticaTitlePane.this.rootPane.getJMenuBar().getPreferredSize());
                }
            });
        }
        this.createButtons();
        this.updateLayoutStyle(decorationStyle, showDialogIcon);
        this.installListeners(this.rootPane);
        this.setComponentsActiveState(this.window.isActive());
        this.updateState();
    }

    public void updateLayoutStyle() {
        int decorationStyle = this.rootPane.getWindowDecorationStyle();
        boolean showDialogIcon = SyntheticaLookAndFeel.getBoolean("Synthetica.dialog.icon.enabled", this.window);
        this.updateLayoutStyle(decorationStyle, showDialogIcon);
    }

    private void updateLayoutStyle(int decorationStyle, boolean showDialogIcon) {
        this.removeAll();
        this.addTitlePaneControls(this.getLayoutStyle(), decorationStyle, showDialogIcon);
    }

    protected void addTitlePaneControls(LayoutStyle layoutStyle, int decorationStyle, boolean showDialogIcon) {
        if (layoutStyle == LayoutStyle.REGULAR) {
            this.addControls_regularLayout(decorationStyle, showDialogIcon);
        } else if (layoutStyle == LayoutStyle.INLINEMENU) {
            this.addControls_inlineMenuLayout(decorationStyle, showDialogIcon);
        } else if (layoutStyle == LayoutStyle.INLINEMENU_LEADING) {
            this.addControls_inlineMenuLeadingLayout(decorationStyle, showDialogIcon);
        } else if (layoutStyle == LayoutStyle.SECONDARYMENU) {
            this.menuBarLabel.setVisible(true);
            if (this.userComponentContainer == null) {
                this.userComponentContainer = new UserComponentContainer();
            }
            this.addControls_secondaryMenuLayout(decorationStyle, showDialogIcon);
        }
    }

    private void addControls_regularLayout(int decorationStyle, boolean showDialogIcon) {
        int xGap = this.getXGap();
        if (this.useMACStyle && OS.getCurrentOS() == OS.Mac) {
            this.add((Component)this.closeButton, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, this.getCloseButtonAlignment(), 0, this.getCloseButtonInsets(xGap), 0, 0));
            if (decorationStyle == 1 && this.dialog == null) {
                this.add((Component)this.iconifyButton, new GridBagConstraints(1, 0, 1, 2, 0.0, 0.0, this.getIconifyButtonAlignment(), 0, this.getIconifyButtonInsets(xGap), 0, 0));
                this.add((Component)this.toggleButton, new GridBagConstraints(2, 0, 1, 2, 0.0, 0.0, this.getToggleButtonAlignment(), 0, this.getToggleButtonInsets(xGap), 0, 0));
            }
            this.add((Component)this.titleLabel, new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, this.getTitleLabelAlignment(), 2, this.getTitleLabelInsets(xGap), 0, 0));
            this.add((Component)this.menuBarLabel, new GridBagConstraints(3, 1, 1, 1, 1.0, 1.0, 10, 2, this.getMenuBarLabelInsets(xGap), 0, 0));
            if (decorationStyle == 1 || showDialogIcon) {
                this.add((Component)this.menuButton, new GridBagConstraints(4, 0, 1, 2, 0.0, 0.0, this.getMenuButtonAlignment(), 0, this.getMenuButtonInsets(xGap), 0, 0));
            }
        } else {
            if (decorationStyle == 1 || showDialogIcon) {
                this.add((Component)this.menuButton, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, this.getMenuButtonAlignment(), 0, this.getMenuButtonInsets(xGap), 0, 0));
            }
            this.add((Component)this.titleLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, this.getTitleLabelAlignment(), 2, this.getTitleLabelInsets(xGap), 0, 0));
            this.add((Component)this.menuBarLabel, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 2, this.getMenuBarLabelInsets(xGap), 0, 0));
            if (decorationStyle == 1 && this.dialog == null) {
                this.add((Component)this.iconifyButton, new GridBagConstraints(2, 0, 1, 2, 0.0, 0.0, this.getIconifyButtonAlignment(), 0, this.getIconifyButtonInsets(xGap), 0, 0));
                this.add((Component)this.toggleButton, new GridBagConstraints(3, 0, 1, 2, 0.0, 0.0, this.getToggleButtonAlignment(), 0, this.getToggleButtonInsets(xGap), 0, 0));
            }
            this.add((Component)this.closeButton, new GridBagConstraints(4, 0, 1, 2, 0.0, 0.0, this.getCloseButtonAlignment(), 0, this.getCloseButtonInsets(xGap), 0, 0));
        }
    }

    private void addControls_inlineMenuLayout(int decorationStyle, boolean showDialogIcon) {
        int xGap = this.getXGap();
        if (this.useMACStyle && OS.getCurrentOS() == OS.Mac) {
            this.add((Component)this.closeButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, this.getCloseButtonAlignment(), 0, this.getCloseButtonInsets(xGap), 0, 0));
            if (decorationStyle == 1 && this.dialog == null) {
                this.add((Component)this.iconifyButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, this.getIconifyButtonAlignment(), 0, this.getIconifyButtonInsets(xGap), 0, 0));
                this.add((Component)this.toggleButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, this.getToggleButtonAlignment(), 0, this.getToggleButtonInsets(xGap), 0, 0));
            }
            this.add((Component)this.titleLabel, new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, this.getTitleLabelAlignment(), 2, this.getTitleLabelInsets(xGap), 0, 0));
            this.add((Component)this.menuBarLabel, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, this.getMenuBarLabelInsets(xGap), 0, 0));
            if (decorationStyle == 1 || showDialogIcon) {
                this.add((Component)this.menuButton, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, this.getMenuButtonAlignment(), 0, this.getMenuButtonInsets(xGap), 0, 0));
            }
        } else {
            if (decorationStyle == 1 || showDialogIcon) {
                this.add((Component)this.menuButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, this.getMenuButtonAlignment(), 0, this.getMenuButtonInsets(xGap), 0, 0));
            }
            this.add((Component)this.titleLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, this.getTitleLabelAlignment(), 2, this.getTitleLabelInsets(xGap), 0, 0));
            this.add((Component)this.menuBarLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, this.getMenuBarLabelInsets(xGap), 0, 0));
            if (decorationStyle == 1 && this.dialog == null) {
                this.add((Component)this.iconifyButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, this.getIconifyButtonAlignment(), 0, this.getIconifyButtonInsets(xGap), 0, 0));
                this.add((Component)this.toggleButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, this.getToggleButtonAlignment(), 0, this.getToggleButtonInsets(xGap), 0, 0));
            }
            this.add((Component)this.closeButton, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, this.getCloseButtonAlignment(), 0, this.getCloseButtonInsets(xGap), 0, 0));
        }
    }

    private void addControls_inlineMenuLeadingLayout(int decorationStyle, boolean showDialogIcon) {
        int xGap = this.getXGap();
        if (this.useMACStyle && OS.getCurrentOS() == OS.Mac) {
            this.add((Component)this.closeButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, this.getCloseButtonAlignment(), 0, this.getCloseButtonInsets(xGap), 0, 0));
            if (decorationStyle == 1 && this.dialog == null) {
                this.add((Component)this.iconifyButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, this.getIconifyButtonAlignment(), 0, this.getIconifyButtonInsets(xGap), 0, 0));
                this.add((Component)this.toggleButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, this.getToggleButtonAlignment(), 0, this.getToggleButtonInsets(xGap), 0, 0));
            }
            this.add((Component)this.menuBarLabel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, this.getMenuBarLabelInsets(xGap), 0, 0));
            this.add((Component)this.titleLabel, new GridBagConstraints(4, 0, 1, 1, 1.0, 1.0, this.getTitleLabelAlignment(), 2, this.getTitleLabelInsets(xGap), 0, 0));
            if (decorationStyle == 1 || showDialogIcon) {
                this.add((Component)this.menuButton, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, this.getMenuButtonAlignment(), 0, this.getMenuButtonInsets(xGap), 0, 0));
            }
        } else {
            if (decorationStyle == 1 || showDialogIcon) {
                this.add((Component)this.menuButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, this.getMenuButtonAlignment(), 0, this.getMenuButtonInsets(xGap), 0, 0));
            }
            this.add((Component)this.menuBarLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, this.getMenuBarLabelInsets(xGap), 0, 0));
            this.add((Component)this.titleLabel, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, this.getTitleLabelAlignment(), 2, this.getTitleLabelInsets(xGap), 0, 0));
            if (decorationStyle == 1 && this.dialog == null) {
                this.add((Component)this.iconifyButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, this.getIconifyButtonAlignment(), 0, this.getIconifyButtonInsets(xGap), 0, 0));
                this.add((Component)this.toggleButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, this.getToggleButtonAlignment(), 0, this.getToggleButtonInsets(xGap), 0, 0));
            }
            this.add((Component)this.closeButton, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, this.getCloseButtonAlignment(), 0, this.getCloseButtonInsets(xGap), 0, 0));
        }
    }

    private void addControls_secondaryMenuLayout(int decorationStyle, boolean showDialogIcon) {
        int xGap = this.getXGap();
        if (this.useMACStyle && OS.getCurrentOS() == OS.Mac) {
            this.add((Component)this.closeButton, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, this.getCloseButtonAlignment(), 0, this.getCloseButtonInsets(xGap), 0, 0));
            if (decorationStyle == 1 && this.dialog == null) {
                this.add((Component)this.iconifyButton, new GridBagConstraints(1, 0, 1, 2, 0.0, 0.0, this.getIconifyButtonAlignment(), 0, this.getIconifyButtonInsets(xGap), 0, 0));
                this.add((Component)this.toggleButton, new GridBagConstraints(2, 0, 1, 2, 0.0, 0.0, this.getToggleButtonAlignment(), 0, this.getToggleButtonInsets(xGap), 0, 0));
            }
            this.add((Component)this.menuBarLabel, new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 10, 2, this.getMenuBarLabelInsets(xGap), 0, 0));
            this.add((Component)this.userComponentContainer, new GridBagConstraints(3, 1, 1, 1, 1.0, 1.0, 10, 2, this.getUserComponentInsets(xGap), 0, 0));
            if (decorationStyle == 1 || showDialogIcon) {
                this.add((Component)this.menuButton, new GridBagConstraints(4, 0, 1, 2, 0.0, 0.0, this.getMenuButtonAlignment(), 0, this.getMenuButtonInsets(xGap), 0, 0));
            }
        } else {
            if (decorationStyle == 1 || showDialogIcon) {
                this.add((Component)this.menuButton, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, this.getMenuButtonAlignment(), 0, this.getMenuButtonInsets(xGap), 0, 0));
            }
            this.add((Component)this.menuBarLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 2, this.getMenuBarLabelInsets(xGap), 0, 0));
            boolean isFrameStyle = decorationStyle == 1 && this.dialog == null;
            this.add((Component)this.userComponentContainer, new GridBagConstraints(1, 1, isFrameStyle ? 4 : 2, 1, 1.0, 1.0, 10, 2, this.getUserComponentInsets(xGap), 0, 0));
            if (isFrameStyle) {
                this.add((Component)this.iconifyButton, new GridBagConstraints(2, 0, 1, 2, 0.0, 0.0, this.getIconifyButtonAlignment(), 0, this.getIconifyButtonInsets(xGap), 0, 0));
                this.add((Component)this.toggleButton, new GridBagConstraints(3, 0, 1, 2, 0.0, 0.0, this.getToggleButtonAlignment(), 0, this.getToggleButtonInsets(xGap), 0, 0));
            }
            this.add((Component)this.closeButton, new GridBagConstraints(4, 0, 1, 2, 0.0, 0.0, this.getCloseButtonAlignment(), 0, this.getCloseButtonInsets(xGap), 0, 0));
        }
    }

    public void setUserComponent(JComponent c) {
        if (this.userComponentContainer != null) {
            this.userComponentContainer.removeAll();
            this.userComponentContainer.add(c);
        }
    }

    public JComponent getUserComponent() {
        return this.userComponentContainer == null || this.userComponentContainer.getComponentCount() == 0 ? null : (JComponent)this.userComponentContainer.getComponent(0);
    }

    public LayoutStyle getLayoutStyle() {
        String s = SyntheticaLookAndFeel.getString("Synthetica.rootPane.titlePane.layoutStyle", this.window);
        return s == null ? LayoutStyle.REGULAR : LayoutStyle.valueOf(s);
    }

    private void installListeners(JRootPane root) {
        this.windowListener = new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent evt) {
                if (OS.getCurrentOS() == OS.Linux && SyntheticaTitlePane.this.dialog != null && SyntheticaTitlePane.this.dialog.isModal() && SyntheticaLookAndFeel.getBoolean("Synthetica.dialog.modalAlwaysOnTopLinuxOnly.enabled", null, false)) {
                    SyntheticaTitlePane.this.dialog.setAlwaysOnTop(true);
                }
                if (SyntheticaTitlePane.this.rootPane.getWindowDecorationStyle() == 1 && SyntheticaTitlePane.this.dialog == null) {
                    SyntheticaTitlePane.this.updateToggleButton();
                    SyntheticaTitlePane.this.updateState();
                }
            }

            @Override
            public void windowStateChanged(WindowEvent evt) {
                SyntheticaTitlePane.this.updateToggleButton();
                SyntheticaTitlePane.this.updateState();
            }

            @Override
            public void windowActivated(WindowEvent evt) {
                SyntheticaTitlePane.this.setActive(true);
                SyntheticaTitlePane.this.selected = true;
            }

            @Override
            public void windowDeactivated(WindowEvent evt) {
                SyntheticaTitlePane.this.setActive(false);
                SyntheticaTitlePane.this.selected = false;
            }
        };
        this.window.addWindowListener(this.windowListener);
        this.window.addWindowStateListener((WindowStateListener)((Object)this.windowListener));
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pce) {
                String name = pce.getPropertyName();
                if ("resizable".equals(name)) {
                    boolean resizable = (Boolean)pce.getNewValue();
                    SyntheticaTitlePane.this.toggleButton.setEnabled(resizable);
                    SyntheticaTitlePane.this.systemMenu.removeAll();
                    SyntheticaTitlePane.this.addMenuItems(SyntheticaTitlePane.this.systemMenu);
                } else if ("iconImage".equals(name) && SyntheticaTitlePane.this.menuButton != null) {
                    SyntheticaTitlePane.this.menuButton.setIcon(SyntheticaTitlePane.this.getIcon(SyntheticaTitlePane.this.rootPane));
                } else if ("title".equals(name)) {
                    SyntheticaTitlePane.this.repaint();
                } else if ("name".equals(name)) {
                    SyntheticaTitlePane.this.updateDefaults();
                    SyntheticaTitlePane.this.updateLayoutStyle();
                }
            }
        };
        this.window.addPropertyChangeListener(this.propertyChangeListener);
        this.rootPanePropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("Synthetica.dialog.iconImage".equals(evt.getPropertyName()) && SyntheticaTitlePane.this.menuButton != null) {
                    SyntheticaTitlePane.this.menuButton.setIcon(SyntheticaTitlePane.this.getIcon((JRootPane)evt.getSource()));
                }
            }
        };
        this.rootPane.addPropertyChangeListener(this.rootPanePropertyChangeListener);
        if (this.menuButton != null) {
            this.menuActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    boolean useMacStyleOnMac;
                    if (SyntheticaTitlePane.this.systemMenu.isVisible()) {
                        SyntheticaTitlePane.this.systemMenu.setVisible(false);
                        return;
                    }
                    int xGap = SyntheticaTitlePane.this.getXGap();
                    int y = SyntheticaTitlePane.this.menuButton.getY() + SyntheticaTitlePane.this.menuButton.getHeight() + ((SyntheticaTitlePane)SyntheticaTitlePane.this).getTitleLabelInsets((int)xGap).bottom;
                    boolean bl = useMacStyleOnMac = SyntheticaTitlePane.this.useMACStyle && OS.getCurrentOS() == OS.Mac;
                    if (SyntheticaTitlePane.this.isRTL() && !useMacStyleOnMac || !SyntheticaTitlePane.this.isRTL() && useMacStyleOnMac) {
                        SyntheticaTitlePane.this.systemMenu.show(SyntheticaTitlePane.this, SyntheticaTitlePane.this.menuButton.getX() + SyntheticaTitlePane.this.menuButton.getWidth() - ((SyntheticaTitlePane)SyntheticaTitlePane.this).systemMenu.getPreferredSize().width + xGap, y);
                    } else {
                        SyntheticaTitlePane.this.systemMenu.show(SyntheticaTitlePane.this, SyntheticaTitlePane.this.menuButton.getX() - xGap, y);
                    }
                }
            };
            this.menuButton.addActionListener(this.menuActionListener);
        }
        this.layeredPaneContainerListener = new ContainerListener(){
            private ContainerListener menuBarContainerListener;
            private MouseInputListener menuBarMouseListener;

            @Override
            public void componentAdded(ContainerEvent evt) {
                if (evt.getChild() instanceof JMenuBar && SyntheticaTitlePane.this.showMenuBarInTitlePane()) {
                    JMenuBar menuBar = (JMenuBar)evt.getChild();
                    this.updatePlaceHolder(menuBar);
                    SyntheticaTitlePane.this.menuBarLabel.setVisible(true);
                    ((JLayeredPane)evt.getComponent()).setComponentZOrder(menuBar, 1);
                    this.menuBarMouseListener = SyntheticaTitlePane.this.rootPaneUI.getMouseInputListener();
                    menuBar.addMouseListener(this.menuBarMouseListener);
                    menuBar.addMouseMotionListener(this.menuBarMouseListener);
                    this.menuBarContainerListener = new ContainerListener(){

                        @Override
                        public void componentRemoved(ContainerEvent evt) {
                            this.updatePlaceHolder(evt.getComponent());
                        }

                        @Override
                        public void componentAdded(ContainerEvent evt) {
                            this.updatePlaceHolder(evt.getComponent());
                        }
                    };
                    menuBar.addContainerListener(this.menuBarContainerListener);
                }
            }

            private void updatePlaceHolder(Component menuBar) {
                SyntheticaTitlePane.this.menuBarLabel.setPreferredSize(menuBar.getPreferredSize());
                SyntheticaTitlePane.this.menuBarLabel.setMinimumSize(menuBar.getPreferredSize());
            }

            @Override
            public void componentRemoved(ContainerEvent evt) {
                if (evt.getChild() instanceof JMenuBar) {
                    JMenuBar menuBar = (JMenuBar)evt.getChild();
                    menuBar.removeMouseListener(this.menuBarMouseListener);
                    menuBar.removeMouseMotionListener(this.menuBarMouseListener);
                    menuBar.removeContainerListener(this.menuBarContainerListener);
                    SyntheticaTitlePane.this.menuBarLabel.setVisible(false);
                    this.menuBarMouseListener = null;
                    this.menuBarContainerListener = null;
                }
            }
        };
        this.rootPane.getLayeredPane().addContainerListener(this.layeredPaneContainerListener);
    }

    void uninstallListeners(JRootPane root) {
        this.window.removeWindowListener(this.windowListener);
        this.window.removeWindowStateListener((WindowStateListener)((Object)this.windowListener));
        this.window.removePropertyChangeListener(this.propertyChangeListener);
        root.removePropertyChangeListener(this.rootPanePropertyChangeListener);
        root.getLayeredPane().removeContainerListener(this.layeredPaneContainerListener);
        if (this.menuButton != null) {
            this.menuButton.removeActionListener(this.menuActionListener);
        }
    }

    private void updateDefaults() {
        this.setOpaque(SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.titlePane.opaque", this.window, true));
        int xGap = this.getXGap();
        GridBagLayout layout = (GridBagLayout)this.getLayout();
        GridBagConstraints gbc = layout.getConstraints(this.titleLabel);
        gbc.insets = this.getTitleLabelInsets(xGap);
        layout.setConstraints(this.titleLabel, gbc);
        this.titleLabel.revalidate();
        gbc = layout.getConstraints(this.menuBarLabel);
        gbc.insets = this.getMenuBarLabelInsets(xGap);
        layout.setConstraints(this.menuBarLabel, gbc);
        this.menuBarLabel.revalidate();
        if (this.menuButton != null) {
            this.menuButton.setIcon(this.getIcon(this.rootPane));
            gbc = layout.getConstraints(this.menuButton);
            gbc.insets = this.getMenuButtonInsets(xGap);
            gbc.anchor = this.getMenuButtonAlignment();
            layout.setConstraints(this.menuButton, gbc);
            this.menuButton.revalidate();
        }
        if (this.iconifyButton != null) {
            gbc = layout.getConstraints(this.iconifyButton);
            gbc.insets = this.getIconifyButtonInsets(xGap);
            gbc.anchor = this.getIconifyButtonAlignment();
            layout.setConstraints(this.iconifyButton, gbc);
            this.iconifyButton.revalidate();
        }
        if (this.toggleButton != null) {
            gbc = layout.getConstraints(this.toggleButton);
            gbc.insets = this.getToggleButtonInsets(xGap);
            gbc.anchor = this.getToggleButtonAlignment();
            layout.setConstraints(this.toggleButton, gbc);
            this.toggleButton.revalidate();
        }
        gbc = layout.getConstraints(this.closeButton);
        gbc.insets = this.getCloseButtonInsets(xGap);
        gbc.anchor = this.getCloseButtonAlignment();
        layout.setConstraints(this.closeButton, gbc);
        this.closeButton.revalidate();
    }

    boolean showMenuBarInTitlePane() {
        return this.rootPane.getJMenuBar() != null && SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.titlePane.showMenuBarInTitlePane", this.window, false);
    }

    boolean clipMenuBarWidth() {
        return this.rootPane.getJMenuBar() != null && SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.titlePane.clipMenuBarWidth", this.window, false);
    }

    private int getXGap() {
        return SyntheticaLookAndFeel.getInt("Synthetica.rootPane.titlePane.gap", this.window, 4, true);
    }

    protected Insets getTitleLabelInsets() {
        return this.getTitleLabelInsets(this.getXGap());
    }

    private Insets getTitleLabelInsets(int xGap) {
        Insets insets = SyntheticaLookAndFeel.getInsets("Synthetica.rootPane.titlePane.title.insets", (Component)this.window, new Insets(3, 0, 4, 0), true);
        return new Insets(insets.top, insets.left + xGap, insets.bottom, insets.right + xGap);
    }

    private Insets getMenuBarLabelInsets(int xGap) {
        Insets insets = SyntheticaLookAndFeel.getInsets("Synthetica.rootPane.titlePane.menuBar.insets", (Component)this.window, false, true);
        return new Insets(insets.top, insets.left + xGap, insets.bottom, insets.right + xGap);
    }

    private Insets getUserComponentInsets(int xGap) {
        Insets insets = SyntheticaLookAndFeel.getInsets("Synthetica.rootPane.titlePane.userComponent.insets", (Component)this.window, false, true);
        return new Insets(insets.top, insets.left + xGap, insets.bottom, insets.right + xGap);
    }

    protected Insets getMenuButtonInsets() {
        return this.getMenuButtonInsets(this.getXGap());
    }

    private Insets getMenuButtonInsets(int xGap) {
        Insets insets = SyntheticaLookAndFeel.getInsets("Synthetica.rootPane.titlePane.menuButton.insets", (Component)this.window, false, true);
        if (this.useMACStyle && OS.getCurrentOS() == OS.Mac) {
            return new Insets(insets.top, insets.right, insets.bottom, insets.left + xGap);
        }
        return new Insets(insets.top, insets.left + xGap, insets.bottom, insets.right);
    }

    protected Insets getIconifyButtonInsets() {
        return this.getIconifyButtonInsets(this.getXGap());
    }

    private Insets getIconifyButtonInsets(int xGap) {
        Insets insets = SyntheticaLookAndFeel.getInsets("Synthetica.rootPane.titlePane.iconifyButton.insets", (Component)this.window, false, true);
        if (this.useMACStyle && OS.getCurrentOS() == OS.Mac) {
            int iconifyGap = SyntheticaLookAndFeel.getInt("Synthetica.rootPane.titlePane.iconifyButton.gap", this.window, 0, true);
            return new Insets(insets.top, insets.left + iconifyGap, insets.bottom, insets.right);
        }
        int iconifyGap = SyntheticaLookAndFeel.getInt("Synthetica.rootPane.titlePane.iconifyButton.gap", this.window, 0, true);
        return new Insets(insets.top, insets.left, insets.bottom, insets.right + iconifyGap);
    }

    protected Insets getToggleButtonInsets() {
        return this.getToggleButtonInsets(this.getXGap());
    }

    private Insets getToggleButtonInsets(int xGap) {
        Insets insets = SyntheticaLookAndFeel.getInsets("Synthetica.rootPane.titlePane.toggleButton.insets", (Component)this.window, false, true);
        if (this.useMACStyle && OS.getCurrentOS() == OS.Mac) {
            int toggleGap = SyntheticaLookAndFeel.getInt("Synthetica.rootPane.titlePane.toggleButton.gap", this.window, 0, true);
            return new Insets(insets.top, insets.left + toggleGap, insets.bottom, insets.right);
        }
        int toggleGap = SyntheticaLookAndFeel.getInt("Synthetica.rootPane.titlePane.toggleButton.gap", this.window, xGap, true, false);
        return new Insets(insets.top, insets.left, insets.bottom, insets.right + toggleGap);
    }

    protected Insets getCloseButtonInsets() {
        return this.getCloseButtonInsets(this.getXGap());
    }

    private Insets getCloseButtonInsets(int xGap) {
        Insets insets = SyntheticaLookAndFeel.getInsets("Synthetica.rootPane.titlePane.closeButton.insets", (Component)this.window, false, true);
        if (this.useMACStyle && OS.getCurrentOS() == OS.Mac) {
            return new Insets(insets.top, insets.right + xGap, insets.bottom, insets.left);
        }
        return new Insets(insets.top, insets.left, insets.bottom, insets.right + xGap);
    }

    private int getMenuButtonAlignment() {
        return SyntheticaLookAndFeel.getInt("Synthetica.rootPane.titlePane.menuButton.alignment", (Component)this.window, 10);
    }

    private int getTitleLabelAlignment() {
        return SyntheticaLookAndFeel.getInt("Synthetica.rootPane.titlePane.title.alignment", (Component)this.window, 10);
    }

    private int getIconifyButtonAlignment() {
        return SyntheticaLookAndFeel.getInt("Synthetica.rootPane.titlePane.iconifyButton.alignment", (Component)this.window, 10);
    }

    private int getToggleButtonAlignment() {
        return SyntheticaLookAndFeel.getInt("Synthetica.rootPane.titlePane.toggleButton.alignment", (Component)this.window, 10);
    }

    private int getCloseButtonAlignment() {
        return SyntheticaLookAndFeel.getInt("Synthetica.rootPane.titlePane.closeButton.alignment", (Component)this.window, 10);
    }

    @Override
    public JRootPane getRootPane() {
        return this.rootPane;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isTitlePaneEnabled()) {
            return super.getPreferredSize();
        }
        return new Dimension(0, 0);
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.isTitlePaneEnabled()) {
            return super.getMinimumSize();
        }
        return new Dimension(0, 0);
    }

    boolean isTitlePaneEnabled() {
        boolean disabled = this.rootPane.getClientProperty("Synthetica.titlePane.enabled") == null ? false : (Boolean)this.rootPane.getClientProperty("Synthetica.titlePane.enabled") == false;
        String key = String.valueOf(this.rootPane.getParent().getClass().getName()) + ".titlePane.enabled";
        return (UIManager.get(key) == null || UIManager.getBoolean(key)) && !disabled;
    }

    private String getTitleText() {
        if (this.frame != null) {
            return this.frame.getTitle();
        }
        if (this.dialog != null) {
            return this.dialog.getTitle();
        }
        return null;
    }

    private Icon getFrameIcon() {
        Image image = this.frame != null ? this.frame.getIconImage() : null;
        Icon icon = null;
        if (image != null) {
            List<Image> icons = this.frame.getIconImages();
            if (icons.size() > 1) {
                image = new ScalableImage(icons.toArray(new Image[0]));
            }
            icon = this.image2Icon(image);
        } else {
            SynthStyle ss = SynthLookAndFeel.getStyle(this.rootPane, Region.ROOT_PANE);
            SynthContext sc = new SynthContext(this.rootPane, Region.ROOT_PANE, ss, 0);
            icon = ss.getIcon(sc, "RootPane.icon");
        }
        return icon;
    }

    private Icon getIcon(JRootPane rootPane) {
        Icon icon = this.getFrameIcon();
        if (rootPane.getWindowDecorationStyle() != 1 && rootPane != null) {
            Window w;
            if (rootPane.getClientProperty("Synthetica.dialog.iconImage") != null) {
                Image image = (Image)rootPane.getClientProperty("Synthetica.dialog.iconImage");
                icon = this.image2Icon(image);
            } else if (this.window instanceof JDialog && ((JDialog)this.window).getIconImages().size() > 0) {
                List<Image> icons = ((JDialog)this.window).getIconImages();
                Image image = icons.get(0);
                if (icons.size() > 1) {
                    image = new ScalableImage(icons.toArray(new Image[0]));
                }
                icon = this.image2Icon(image);
            } else if (this.window != null && this.window.getOwner() != null && (rootPane = (w = this.window.getOwner()) instanceof JFrame ? ((JFrame)w).getRootPane() : (w instanceof JDialog ? ((JDialog)w).getRootPane() : null)) != null && rootPane.getUI() instanceof SyntheticaRootPaneUI && ((SyntheticaRootPaneUI)rootPane.getUI()).getTitlePane() != null) {
                icon = ((SyntheticaTitlePane)((SyntheticaRootPaneUI)rootPane.getUI()).getTitlePane()).getIcon(rootPane);
            }
        }
        return icon instanceof Scalable || SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.titlePane.menuButton.useOriginalImageSize", this.window) ? icon : new ScalableIcon(icon);
    }

    private Icon image2Icon(Image image) {
        Object description = image.getProperty("comment", null);
        if (SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.titlePane.menuButton.useOriginalImageSize", this.window)) {
            return new ImageIcon(image, description instanceof String ? (String)description : "");
        }
        return image instanceof ScalableImage ? new ScalableIcon((ScalableImage)image) : new ImageIcon(image.getScaledInstance(16, 16, 4), description instanceof String ? (String)description : "");
    }

    private void setActive(boolean active) {
        this.setComponentsActiveState(active);
        this.getRootPane().repaint();
    }

    private void setComponentsActiveState(boolean active) {
        this.updateTitleLabel(active);
        this.closeButton.putClientProperty("paintActive", active);
        if (this.rootPane.getWindowDecorationStyle() == 1 && this.dialog == null) {
            this.iconifyButton.putClientProperty("paintActive", active);
            this.toggleButton.putClientProperty("paintActive", active);
        }
        this.updateToggleButton();
        if (this.iconifyButton != null) {
            this.iconifyButton.setIcon(active ? (Icon)this.iconifyButton.getClientProperty("Synthetica.iconifyIcon") : (Icon)this.iconifyButton.getClientProperty("Synthetica.iconifyIcon.inactive"));
        }
        if (this.closeButton != null) {
            this.closeButton.setIcon(active ? (Icon)this.closeButton.getClientProperty("Synthetica.closeIcon") : (Icon)this.closeButton.getClientProperty("Synthetica.closeIcon.inactive"));
        }
    }

    private void updateTitleLabel(boolean active) {
        float fontSize;
        JInternalFrame c = this.iFrameDelegate;
        c.setName(this.window.getName());
        SynthStyle ss = SynthLookAndFeel.getStyleFactory().getStyle(c, Region.INTERNAL_FRAME_TITLE_PANE);
        SynthContext sc = new SynthContext(c, Region.INTERNAL_FRAME_TITLE_PANE, ss, active ? 512 : 0);
        Font font = this.getFont();
        if (font == null || font instanceof UIResource) {
            font = ss.getFont(sc);
        }
        fontSize = (fontSize = (float)SyntheticaLookAndFeel.getInt("Synthetica.rootPane.titlePane.title.fontSize", this.window)) == 0.0f ? (float)font.getSize() : SyntheticaLookAndFeel.getInstance().scaleFontSize(fontSize);
        font = font instanceof Scalable ? new ScalableFont(font.getName(), font.getStyle(), (int)fontSize) : font.deriveFont(font.getStyle(), fontSize);
        this.titleLabel.setFont(font);
        Color foreground = SyntheticaLookAndFeel.getColor("Synthetica.rootPane.titlePane.foreground" + (active ? ".selected" : ""), this.window, this.getForeground());
        if (foreground == null || foreground instanceof UIResource) {
            foreground = ss.getColor(sc, ColorType.FOREGROUND);
        }
        foreground = new Color(foreground.getRGB());
        this.titleLabel.setForeground(foreground);
    }

    private boolean isFrameResizable() {
        return this.frame != null && this.frame.isResizable();
    }

    private boolean isFrameMaximized() {
        return this.frame != null && (this.frame.getExtendedState() & 6) == 6;
    }

    private void addMenuItems(JPopupMenu menu) {
        JMenuItem mi = menu.add(this.restoreAction);
        mi.setText(SyntheticaLookAndFeel.getString("InternalFrameTitlePane.restoreButtonText", this.window));
        mi.setMnemonic('R');
        mi.setEnabled(this.isFrameResizable());
        mi = menu.add(this.iconifyAction);
        mi.setText(SyntheticaLookAndFeel.getString("InternalFrameTitlePane.minimizeButtonText", this.window));
        mi.setMnemonic('n');
        mi.setEnabled(this.frame != null);
        if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
            mi = menu.add(this.maximizeAction);
            mi.setText(SyntheticaLookAndFeel.getString("InternalFrameTitlePane.maximizeButtonText", this.window));
            mi.setMnemonic('x');
            mi.setEnabled(this.isFrameResizable());
        }
        menu.addSeparator();
        mi = menu.add(this.closeAction);
        mi.setText(SyntheticaLookAndFeel.getString("InternalFrameTitlePane.closeButtonText", this.window));
        mi.setMnemonic('C');
        if (this.closeButton != null) {
            mi.setEnabled(this.closeButton.isVisible() & this.closeButton.isEnabled());
        }
    }

    private JButton createTitlePaneButton(String name) {
        JButton button = new JButton();
        button.setName(name);
        button.setFocusPainted(false);
        button.setFocusable(false);
        button.setOpaque(false);
        button.setBorder(BorderFactory.createEmptyBorder());
        return button;
    }

    private void createButtons() {
        MouseAdapter listener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                JButton b = (JButton)evt.getSource();
                String name = "Synthetica." + b.getClientProperty(SyntheticaTitlePane.BUTTON_ID) + "Icon.hover";
                b.setIcon((Icon)b.getClientProperty(name));
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                JButton b = (JButton)evt.getSource();
                String name = "Synthetica." + b.getClientProperty(SyntheticaTitlePane.BUTTON_ID) + "Icon";
                if (!SyntheticaTitlePane.this.window.isActive()) {
                    name = String.valueOf(name) + ".inactive";
                }
                b.setIcon((Icon)b.getClientProperty(name));
            }
        };
        SynthStyle ss = SynthLookAndFeel.getStyle(this.rootPane, Region.ROOT_PANE);
        SynthContext sc = new SynthContext(this.rootPane, Region.ROOT_PANE, ss, 0);
        Icon closeIcon = ss.getIcon(sc, "RootPane.closeIcon");
        Icon iconifyIcon = ss.getIcon(sc, "RootPane.iconifyIcon");
        Icon maximizeIcon = ss.getIcon(sc, "RootPane.maximizeIcon");
        Icon minimizeIcon = ss.getIcon(sc, "RootPane.minimizeIcon");
        Icon closeIconInactive = ss.getIcon(sc, "RootPane.closeIcon.inactive") == null ? closeIcon : ss.getIcon(sc, "RootPane.closeIcon.inactive");
        Icon iconifyIconInactive = ss.getIcon(sc, "RootPane.iconifyIcon.inactive") == null ? iconifyIcon : ss.getIcon(sc, "RootPane.iconifyIcon.inactive");
        Icon maximizeIconInactive = ss.getIcon(sc, "RootPane.maximizeIcon.inactive") == null ? maximizeIcon : ss.getIcon(sc, "RootPane.maximizeIcon.inactive");
        Icon minimizeIconInactive = ss.getIcon(sc, "RootPane.minimizeIcon.inactive") == null ? minimizeIcon : ss.getIcon(sc, "RootPane.minimizeIcon.inactive");
        sc = new SynthContext(this.rootPane, Region.ROOT_PANE, ss, 2);
        Icon closeIconHover = ss.getIcon(sc, "RootPane.closeIcon");
        Icon iconifyIconHover = ss.getIcon(sc, "RootPane.iconifyIcon");
        Icon maximizeIconHover = ss.getIcon(sc, "RootPane.maximizeIcon");
        Icon minimizeIconHover = ss.getIcon(sc, "RootPane.minimizeIcon");
        sc = new SynthContext(this.rootPane, Region.ROOT_PANE, ss, 4);
        Icon closeIconPressed = ss.getIcon(sc, "RootPane.closeIcon") == closeIcon ? null : ss.getIcon(sc, "RootPane.closeIcon");
        Icon iconifyIconPressed = ss.getIcon(sc, "RootPane.iconifyIcon") == iconifyIcon ? null : ss.getIcon(sc, "RootPane.iconifyIcon");
        Icon maximizeIconPressed = ss.getIcon(sc, "RootPane.maximizeIcon") == maximizeIcon ? null : ss.getIcon(sc, "RootPane.maximizeIcon");
        Icon minimizeIconPressed = ss.getIcon(sc, "RootPane.minimizeIcon") == minimizeIcon ? null : ss.getIcon(sc, "RootPane.minimizeIcon");
        this.closeButton = this.createTitlePaneButton("RootPane.titlePane.closeButton");
        this.closeButton.putClientProperty(BUTTON_ID, "close");
        this.closeButton.putClientProperty("Synthetica.closeIcon", closeIcon);
        this.closeButton.putClientProperty("Synthetica.closeIcon.hover", closeIconHover);
        this.closeButton.putClientProperty("Synthetica.closeIcon.inactive", closeIconInactive);
        this.closeButton.setAction(this.closeAction);
        this.closeButton.getAccessibleContext().setAccessibleName("Close");
        this.closeButton.setIcon(closeIcon);
        this.closeButton.setPressedIcon(closeIconPressed);
        this.closeButton.addMouseListener(listener);
        CloseButtonStateListener closeButtonStateListener = new CloseButtonStateListener();
        this.closeButton.addPropertyChangeListener(closeButtonStateListener);
        this.closeButton.addComponentListener(closeButtonStateListener);
        if (this.rootPane.getWindowDecorationStyle() == 1 && this.dialog == null) {
            this.iconifyButton = this.createTitlePaneButton("RootPane.titlePane.iconifyButton");
            this.iconifyButton.putClientProperty(BUTTON_ID, "iconify");
            this.iconifyButton.putClientProperty("Synthetica.iconifyIcon", iconifyIcon);
            this.iconifyButton.putClientProperty("Synthetica.iconifyIcon.hover", iconifyIconHover);
            this.iconifyButton.putClientProperty("Synthetica.iconifyIcon.inactive", iconifyIconInactive);
            this.iconifyButton.setAction(this.iconifyAction);
            this.iconifyButton.getAccessibleContext().setAccessibleName("Iconify");
            this.iconifyButton.setIcon(iconifyIcon);
            this.iconifyButton.setPressedIcon(iconifyIconPressed);
            this.iconifyButton.addMouseListener(listener);
            this.toggleButton = this.createTitlePaneButton("RootPane.titlePane.toggleButton");
            this.toggleButton.putClientProperty("Synthetica.maximizeIcon", maximizeIcon);
            this.toggleButton.putClientProperty("Synthetica.maximizeIcon.hover", maximizeIconHover);
            this.toggleButton.putClientProperty("Synthetica.maximizeIcon.pressed", maximizeIconPressed);
            this.toggleButton.putClientProperty("Synthetica.maximizeIcon.inactive", maximizeIconInactive);
            this.toggleButton.putClientProperty("Synthetica.minimizeIcon", minimizeIcon);
            this.toggleButton.putClientProperty("Synthetica.minimizeIcon.hover", minimizeIconHover);
            this.toggleButton.putClientProperty("Synthetica.minimizeIcon.pressed", minimizeIconPressed);
            this.toggleButton.putClientProperty("Synthetica.minimizeIcon.inactive", minimizeIconInactive);
            this.updateToggleButton();
            this.toggleButton.addMouseListener(listener);
        }
    }

    private void updateToggleButton() {
        if (this.toggleButton == null) {
            return;
        }
        boolean active = this.window.isActive();
        Icon icon = null;
        Icon pressedIcon = null;
        if (!this.isFrameMaximized()) {
            this.toggleButton.setAction(this.maximizeAction);
            this.toggleButton.getAccessibleContext().setAccessibleName("Maximize");
            this.toggleButton.putClientProperty(BUTTON_ID, "maximize");
            icon = !active ? (Icon)this.toggleButton.getClientProperty("Synthetica.maximizeIcon.inactive") : (Icon)this.toggleButton.getClientProperty("Synthetica.maximizeIcon");
            pressedIcon = (Icon)this.toggleButton.getClientProperty("Synthetica.maximizeIcon.pressed");
        } else {
            this.toggleButton.setAction(this.restoreAction);
            this.toggleButton.getAccessibleContext().setAccessibleName("Restore");
            this.toggleButton.putClientProperty(BUTTON_ID, "minimize");
            icon = !active ? (Icon)this.toggleButton.getClientProperty("Synthetica.minimizeIcon.inactive") : (Icon)this.toggleButton.getClientProperty("Synthetica.minimizeIcon");
            pressedIcon = (Icon)this.toggleButton.getClientProperty("Synthetica.minimizeIcon.pressed");
        }
        this.toggleButton.setIcon(icon);
        this.toggleButton.setPressedIcon(pressedIcon);
        this.toggleButton.setEnabled(this.isFrameResizable());
    }

    @Override
    public void paintComponent(Graphics g) {
        boolean logoRendererInstalled;
        double xOff;
        int tx;
        int ty;
        String title;
        super.paintComponent(g);
        SynthContext sc = SyntheticaLookAndFeel.createContext(this.rootPane, Region.ROOT_PANE, this.selected ? 512 : 0);
        ((SyntheticaPainter)SyntheticaPainter.getInstance()).paintRootPaneTitlePaneBackground(sc, g, 0, 0, this.getWidth(), this.getHeight());
        Rectangle rect = this.getControlButtonsBounds();
        if (rect.width > 0 && rect.height > 0) {
            ((SyntheticaPainter)SyntheticaPainter.getInstance()).paintRootPaneButtonAreaBackground(sc, g, rect.x, rect.y, rect.width, rect.height);
        }
        if ((title = this.getTitleText()) == null || title.length() == 0) {
            return;
        }
        GridBagLayout layout = (GridBagLayout)this.getLayout();
        Insets gbcInsets = layout.getConstraints((Component)this.titleLabel).insets;
        FontMetrics fm = this.getFontMetrics(this.titleLabel.getFont());
        boolean useMacStyleOnMac = OS.getCurrentOS() == OS.Mac && this.useMACStyle;
        boolean isCentered = SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.titlePane.title.center", this.window) || useMacStyleOnMac;
        int xGap = this.getXGap();
        Rectangle menuRect = this.getMenuButtonBounds();
        if (this.menuButton != null) {
            menuRect.width += layout.getConstraints((Component)this.menuButton).insets.right;
        }
        Rectangle controlsRect = this.getControlButtonsBounds();
        boolean rtl = this.isRTL();
        int tw = fm.stringWidth(title);
        int th = fm.getHeight();
        int n = ty = this.getTitleLabelAlignment() == 10 ? (this.getHeight() - th + gbcInsets.top - gbcInsets.bottom) / 2 : this.titleLabel.getY();
        if (SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.titlePane.showMenuBarInTitlePane", this.window, false)) {
            ty = this.titleLabel.getY() + this.titleLabel.getInsets().top;
        }
        int txMin = useMacStyleOnMac || rtl ? controlsRect.x + controlsRect.width + gbcInsets.right : menuRect.x + menuRect.width + gbcInsets.left;
        int txMax = useMacStyleOnMac || rtl ? menuRect.x - tw - gbcInsets.left : controlsRect.x - tw - gbcInsets.right;
        txMax = Math.max(txMin, txMax);
        int n2 = tx = rtl ? txMax : txMin;
        int n3 = isCentered ? (rtl ? Math.min(tx, this.getWidth() / 2 - fm.stringWidth(title) / 2) : Math.max(tx, this.getWidth() / 2 - fm.stringWidth(title) / 2)) : (tx = tx);
        if (!useMacStyleOnMac) {
            tx = rtl ? Math.min(tx, txMax) : Math.max(tx, txMin);
            tx = rtl ? Math.max(tx, txMin) : Math.min(tx, txMax);
        }
        Rectangle viewRect = this.getBounds();
        SynthStyle ss = SynthLookAndFeel.getStyle(this.iFrameDelegate, Region.INTERNAL_FRAME_TITLE_PANE);
        sc = new SynthContext(this.iFrameDelegate, Region.INTERNAL_FRAME_TITLE_PANE, ss, this.selected ? 512 : 0);
        viewRect.width -= menuRect.width + controlsRect.width + xGap * 2 + gbcInsets.left + gbcInsets.right;
        if (this.showMenuBarInTitlePane() && this.getLayoutStyle() == LayoutStyle.INLINEMENU) {
            if (rtl) {
                xOff = Math.max(0.0, this.menuBarLabel.getBounds().getX() + this.menuBarLabel.getBounds().getWidth() + (double)gbcInsets.right - (double)tx);
                tx = (int)((double)tx + xOff);
                viewRect.width = (int)((double)viewRect.width - this.menuBarLabel.getBounds().getWidth());
            } else {
                viewRect.width = (int)((double)viewRect.width - (this.menuBarLabel.getBounds().getWidth() + (double)(isCentered ? tx - menuRect.width - xGap - gbcInsets.left : 0)));
            }
        } else if (this.showMenuBarInTitlePane() && this.getLayoutStyle() == LayoutStyle.INLINEMENU_LEADING) {
            if (!rtl) {
                xOff = Math.max(0.0, this.menuBarLabel.getBounds().getX() + this.menuBarLabel.getBounds().getWidth() + (double)gbcInsets.right - (double)tx);
                tx = (int)((double)tx + xOff);
                viewRect.width = (int)((double)viewRect.width - this.menuBarLabel.getBounds().getWidth());
            } else {
                viewRect.width = (int)((double)viewRect.width - (this.menuBarLabel.getBounds().getWidth() + (double)(isCentered ? tx - menuRect.width - xGap - gbcInsets.left : 0)));
            }
        }
        String clippedTitle = ss.getGraphicsUtils(sc).layoutText(sc, fm, title, null, 0, 0, 0, 0, viewRect, new Rectangle(0, 0), new Rectangle(0, 0), 0);
        if ("...".equals(clippedTitle)) {
            clippedTitle = "";
        }
        boolean titleVisible = SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.titlePane.title.visible", this.window, true);
        boolean bl = logoRendererInstalled = this.rootPane.getClientProperty("Synthetica.logoRenderer") != null;
        if (titleVisible && (!logoRendererInstalled || (!logoRendererInstalled || this.rootPane.getClientProperty("Synthetica.paintTitle") != null) && ((Boolean)this.rootPane.getClientProperty("Synthetica.paintTitle")).booleanValue())) {
            if (SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.titlePane.dropShadow", this.window) && this.selected) {
                BufferedImage image = new BufferedImage(tw, th, 2);
                Graphics2D g2 = image.createGraphics();
                g2.setFont(this.titleLabel.getFont());
                ((Graphics)g2).drawString(clippedTitle, 0, fm.getAscent());
                g2.dispose();
                DropShadow ds = new DropShadow(image);
                ds.setDistance(SyntheticaLookAndFeel.getInt("Synthetica.rootPane.titlePane.dropShadow.distance", this.window, -5, true));
                ds.setShadowColor(SyntheticaLookAndFeel.getColor("Synthetica.rootPane.titlePane.dropShadow.color", this.window, ds.getShadowColor()));
                ds.setQuality(SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.titlePane.dropShadow.highQuality", this.window, ds.getHighQuality()));
                ds.setShadowOpacity((float)SyntheticaLookAndFeel.getInt("Synthetica.rootPane.titlePane.dropShadow.opacity", (Component)this.window, (int)(ds.getShadowOpacity() * 100.0f)) / 100.0f);
                ds.setShadowSize(SyntheticaLookAndFeel.getInt("Synthetica.rootPane.titlePane.dropShadow.size", this.window, ds.getShadowSize(), true));
                int xOffset = SyntheticaLookAndFeel.getInt("Synthetica.rootPane.titlePane.dropShadow.xOffset", this.window, 0, true);
                int yOffset = SyntheticaLookAndFeel.getInt("Synthetica.rootPane.titlePane.dropShadow.yOffset", this.window, 0, true);
                ds.paintShadow(g, tx + xOffset, ty + yOffset);
            }
            g.setFont(this.titleLabel.getFont());
            if (SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.titlePane.title.etchedTop", this.window)) {
                g.setColor(Color.BLACK);
                ss.getGraphicsUtils(sc).paintText(sc, g, clippedTitle, tx, ty - 1, -2);
            }
            if (SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.titlePane.title.etchedBottom", this.window)) {
                g.setColor(Color.WHITE);
                ss.getGraphicsUtils(sc).paintText(sc, g, clippedTitle, tx, ty + 1, -2);
            }
            Color foreground = SyntheticaLookAndFeel.getColor("Synthetica.rootPane.titlePane.foreground" + (this.window.isActive() ? ".selected" : ""), this.window, ss.getColor(sc, ColorType.FOREGROUND));
            g.setColor(foreground);
            ss.getGraphicsUtils(sc).paintText(sc, g, clippedTitle, tx, ty, -2);
        }
    }

    public Rectangle getControlButtonsBounds() {
        Rectangle rect = this.closeButton.getBounds();
        if (this.useMACStyle && OS.getCurrentOS() == OS.Mac) {
            if (this.toggleButton != null) {
                rect.width = this.toggleButton.getBounds().x + this.toggleButton.getBounds().width - rect.x;
            }
        } else if (this.iconifyButton != null) {
            Rectangle r = this.iconifyButton.getBounds();
            if (this.isRTL()) {
                rect.width = r.x + r.width - rect.x;
            } else {
                rect.width = rect.x + rect.width - r.x;
                rect.x = r.x;
            }
        }
        return rect;
    }

    public Rectangle getMenuButtonBounds() {
        Rectangle rect;
        Rectangle rectangle = rect = this.menuButton == null ? new Rectangle(0, 0, 0, 0) : this.menuButton.getBounds();
        if (this.menuButton == null) {
            rect.x = this.isRTL() ? this.getBounds().width - 1 : 0;
            rect.y = this.getBounds().y;
        }
        return rect;
    }

    private void close() {
        this.window.dispatchEvent(new WindowEvent(this.window, 201));
    }

    protected void iconify() {
        int state = this.frame.getExtendedState();
        this.frame.setExtendedState(state | 1);
        this.updateState();
    }

    protected void maximize() {
        int state = this.frame.getExtendedState();
        this.rootPaneUI.setMaximizedBounds(this.frame);
        this.frame.setExtendedState(state | 6);
        this.updateState();
        if (OS.getCurrentOS() == OS.Mac && SyntheticaTitlePane.isFullScreenOnMacSupported(this.frame)) {
            this.frame.getGraphicsConfiguration().getDevice().setFullScreenWindow(this.frame);
        }
    }

    protected void restore() {
        int state;
        if (OS.getCurrentOS() == OS.Mac && SyntheticaTitlePane.isFullScreenOnMacSupported(this.frame)) {
            this.frame.getGraphicsConfiguration().getDevice().setFullScreenWindow(null);
        }
        if (((state = this.frame.getExtendedState()) & 1) == 1) {
            this.frame.setExtendedState(state ^ 1);
        } else if ((state & 6) == 6) {
            this.frame.setMaximizedBounds(null);
            this.frame.setExtendedState(state ^ 6);
        }
        this.updateState();
    }

    private void updateState() {
        if (this.frame == null) {
            return;
        }
        if (!this.isFrameResizable()) {
            this.restoreAction.setEnabled(false);
            this.maximizeAction.setEnabled(false);
            this.iconifyAction.setEnabled(true);
            return;
        }
        switch (this.frame.getExtendedState()) {
            case 6: {
                this.restoreAction.setEnabled(true);
                this.maximizeAction.setEnabled(false);
                this.iconifyAction.setEnabled(true);
                break;
            }
            case 1: {
                this.restoreAction.setEnabled(true);
                this.maximizeAction.setEnabled(true);
                this.iconifyAction.setEnabled(false);
                break;
            }
            default: {
                this.restoreAction.setEnabled(false);
                this.maximizeAction.setEnabled(true);
                this.iconifyAction.setEnabled(true);
            }
        }
        if ((this.frame.getExtendedState() & 1) != 0) {
            ExtKeyEventProcessor.resetWinMetaKey();
        }
    }

    static boolean isFullScreenOnMacSupported(Frame f) {
        GraphicsDevice gd = f.getGraphicsConfiguration().getDevice();
        return gd.isFullScreenSupported() && SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.fullScreenOnMaximizeMacOnly.enabled", f, false);
    }

    @Override
    public ComponentOrientation getComponentOrientation() {
        return this.window == null ? this.getRootPane().getComponentOrientation() : this.window.getComponentOrientation();
    }

    private boolean isRTL() {
        return !this.getComponentOrientation().isLeftToRight();
    }

    private class CloseButtonStateListener
    implements PropertyChangeListener,
    ComponentListener {
        private CloseButtonStateListener() {
        }

        @Override
        public void componentResized(ComponentEvent evt) {
        }

        @Override
        public void componentMoved(ComponentEvent evt) {
        }

        @Override
        public void componentShown(ComponentEvent evt) {
            this.updateSystemMenu();
        }

        @Override
        public void componentHidden(ComponentEvent evt) {
            this.updateSystemMenu();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if ("enabled".equals(name)) {
                this.updateSystemMenu();
            }
        }

        private void updateSystemMenu() {
            if (SyntheticaTitlePane.this.systemMenu != null) {
                SyntheticaTitlePane.this.systemMenu.removeAll();
                SyntheticaTitlePane.this.addMenuItems(SyntheticaTitlePane.this.systemMenu);
            }
        }
    }

    public static enum LayoutStyle {
        REGULAR,
        INLINEMENU,
        INLINEMENU_LEADING,
        SECONDARYMENU;

    }

    private static class UserComponentContainer
    extends JComponent {
        public UserComponentContainer() {
            this.setLayout(new BorderLayout());
        }
    }
}

