/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.filechooser;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.io.FileOperationEvent;
import de.javasoft.plaf.synthetica.io.FileOperationListener;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class FileOperationDialog
extends JDialog
implements FileOperationListener,
Runnable {
    public static final int COPY_OPERATION = 1;
    public static final int MOVE_OPERATION = 2;
    public static final int DELETE_OPERATION = 3;
    private boolean abort;
    private JLabel folderName;
    private JLabel fileName;
    private String currentFolderName;
    private String currentFileName;
    private JProgressBar progressBar;
    private static final int xGap = SyntheticaLookAndFeel.getInstance().scaleInteger(10);
    private static final int yGap = SyntheticaLookAndFeel.getInstance().scaleInteger(10);
    String title = "";
    String imagePath = "";
    Insets imageInsets;

    public FileOperationDialog(Window owner, int operation) {
        super(owner);
        this.init(owner, operation);
    }

    private void init(Window owner, int operation) {
        Image iconImage = null;
        switch (operation) {
            case 1: {
                this.title = UIManager.getString("FileOperationDialog.copy.title");
                this.imagePath = UIManager.getString("Synthetica.fileOperationDialog.title.copyBackground");
                this.imageInsets = SyntheticaLookAndFeel.getInsets("Synthetica.fileOperationDialog.title.copyBackground.insets", null, new Insets(0, 0, 4, 100), false);
                iconImage = (Image)UIManager.get("Synthetica.fileOperationDialog.copy.iconImage");
                break;
            }
            case 2: {
                this.title = UIManager.getString("FileOperationDialog.move.title");
                this.imagePath = UIManager.getString("Synthetica.fileOperationDialog.title.moveBackground");
                this.imageInsets = SyntheticaLookAndFeel.getInsets("Synthetica.fileOperationDialog.title.moveBackground.insets", null, new Insets(0, 0, 4, 100), false);
                iconImage = (Image)UIManager.get("Synthetica.fileOperationDialog.move.iconImage");
                break;
            }
            case 3: {
                this.title = UIManager.getString("FileOperationDialog.delete.title");
                this.imagePath = UIManager.getString("Synthetica.fileOperationDialog.title.deleteBackground");
                this.imageInsets = SyntheticaLookAndFeel.getInsets("Synthetica.fileOperationDialog.title.deleteBackground.insets", null, new Insets(0, 0, 4, 100), false);
                iconImage = (Image)UIManager.get("Synthetica.fileOperationDialog.delete.iconImage");
            }
        }
        this.setTitle(this.title);
        this.setLayout(new BorderLayout());
        this.getRootPane().putClientProperty("Synthetica.dialog.iconImage", iconImage);
        JPanel topPanel = new JPanel(){
            private Image background;
            {
                this.background = new ImageIcon(SyntheticaLookAndFeel.getResource(FileOperationDialog.this.imagePath)).getImage();
            }

            @Override
            public void paintComponent(Graphics g) {
                ImagePainter imagePainter = new ImagePainter(this.background, g, 0, 0, this.getWidth(), SyntheticaLookAndFeel.getInstance().scaleInteger(this.background.getHeight(null)), FileOperationDialog.this.imageInsets, FileOperationDialog.this.imageInsets);
                imagePainter.draw();
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                int xPos = SyntheticaLookAndFeel.getInt("Synthetica.fileOperationDialog.title.xPos", null, true);
                int yPos = SyntheticaLookAndFeel.getInt("Synthetica.fileOperationDialog.title.yPos", null, true);
                g2.drawString(FileOperationDialog.this.title, xPos, yPos);
                g2.dispose();
            }

            @Override
            public Dimension getPreferredSize() {
                int w = SyntheticaLookAndFeel.getInstance().scaleInteger(this.background.getWidth(null));
                int h = SyntheticaLookAndFeel.getInstance().scaleInteger(this.background.getHeight(null));
                return new Dimension(w, h);
            }
        };
        float fontSize = SyntheticaLookAndFeel.getInstance().scaleFontSize(UIManager.getInt("Synthetica.fileOperationDialog.title.size"));
        topPanel.setFont(topPanel.getFont().deriveFont(1, fontSize));
        topPanel.setForeground(UIManager.getColor("Synthetica.fileOperationDialog.title.color"));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new EmptyBorder(yGap, xGap, yGap, xGap));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        JPanel aniPanel = new JPanel(new BorderLayout());
        panel.add((Component)aniPanel, gbc);
        gbc.insets = new Insets(0, 0, yGap / 4, xGap);
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        JLabel folderLabel = new JLabel(UIManager.getString("FileOperationDialog.folder"));
        panel.add((Component)folderLabel, gbc);
        gbc.insets = new Insets(0, 0, yGap / 4, 0);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.folderName = new JLabel();
        panel.add((Component)this.folderName, gbc);
        gbc.insets = new Insets(0, 0, yGap, xGap);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        JLabel fileNameLabel = new JLabel(UIManager.getString("FileOperationDialog.file"));
        panel.add((Component)fileNameLabel, gbc);
        gbc.insets = new Insets(0, 0, yGap, 0);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.fileName = new JLabel();
        panel.add((Component)this.fileName, gbc);
        gbc.insets = new Insets(0, 0, yGap * 2, 0);
        gbc.gridwidth = 2;
        gbc.gridx = 0;
        gbc.gridy = 3;
        this.progressBar = new JProgressBar(0, 50);
        panel.add((Component)this.progressBar, gbc);
        gbc.anchor = owner.getComponentOrientation().isLeftToRight() ? 13 : 17;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        JButton cancelButton = new JButton(UIManager.getString("FileOperationDialog.cancel"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileOperationDialog.this.abort = true;
                FileOperationDialog.this.dispose();
            }
        });
        panel.add((Component)cancelButton, gbc);
        this.add((Component)topPanel, "North");
        this.add(panel);
        this.pack();
        int x = owner.getLocation().x + owner.getSize().width / 2;
        int xLoc = x - this.getSize().width / 2;
        int y = owner.getLocation().y + owner.getSize().height / 2;
        int yLoc = y - this.getSize().height / 2;
        this.setLocation(xLoc, yLoc);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FileOperationDialog.this.abort = true;
            }
        });
    }

    @Override
    public boolean processFileOperationEvent(FileOperationEvent evt) {
        this.currentFolderName = evt.getFile().getParentFile().getName();
        this.currentFileName = evt.getFile().getName();
        EventQueue.invokeLater(this);
        return !this.abort;
    }

    @Override
    public void run() {
        this.folderName.setText(this.currentFolderName);
        this.fileName.setText(this.currentFileName);
        this.progressBar.setValue((this.progressBar.getValue() + 1) % 50);
    }
}

