/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaComponentPainter;
import de.javasoft.plaf.synthetica.painter.UIKey;
import de.javasoft.plaf.synthetica.util.Synthetica2DUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.basic.BasicMenuUI;
import javax.swing.plaf.synth.SynthContext;

public class MenuPainter
extends SyntheticaComponentPainter {
    public static final String UI_KEY = "Synthetica.MenuPainter";
    private static Icon topMarkerIcon;
    private static Icon bottomMarkerIcon;

    protected MenuPainter() {
    }

    public static MenuPainter getInstance() {
        return MenuPainter.getInstance(null);
    }

    public static MenuPainter getInstance(SynthContext sc) {
        SyntheticaComponentPainter instance = (SyntheticaComponentPainter)instances.get(MenuPainter.getPainterClassName(sc, MenuPainter.class, UI_KEY));
        if (instance == null) {
            instance = MenuPainter.getInstance(sc, MenuPainter.class, UI_KEY);
        }
        return (MenuPainter)instance;
    }

    public static void reinitialize() {
        topMarkerIcon = null;
        bottomMarkerIcon = null;
    }

    public void paintMenuBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
    }

    public void paintMenuItemBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
    }

    public void paintPopupMenuBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
    }

    public void paintMenuBarBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
    }

    public void paintPopupMenuBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        JPopupMenu popup = (JPopupMenu)sc.getComponent();
        boolean toplevelPopup = SyntheticaLookAndFeel.isToplevelPopupMenu(popup);
        this.paintPopupMenuBackground(popup, toplevelPopup, g, x, y, w, h);
        if (toplevelPopup) {
            Insets toplevelInsets = this.getImageInsets("Synthetica.popupMenu.toplevel.insets", popup);
            this.paintToplevelPopupMenuMarker(popup, toplevelInsets, g, x, y, w, h);
            Component[] componentArray = popup.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component c = componentArray[n2];
                if (c instanceof JComponent && SyntheticaLookAndFeel.getClientProperty("Synthetica.popupMenu.title", (JComponent)c, false).booleanValue()) {
                    Rectangle r = c.getBounds();
                    toplevelInsets = SyntheticaLookAndFeel.getInstance().scaleInsets(toplevelInsets);
                    this.paintToplevelPopupMenuTitleBackground(popup, g, toplevelInsets.left, r.y, w - toplevelInsets.left - toplevelInsets.right, r.height);
                }
                ++n2;
            }
        }
    }

    public void paintPopupMenuBackground(JPopupMenu popup, boolean toplevelPopup, Graphics g, int x, int y, int w, int h) {
        BufferedImage background;
        Insets sInsets;
        boolean comboPopupConfigured;
        Component invoker = popup.getInvoker();
        boolean bl = comboPopupConfigured = SyntheticaLookAndFeel.get("Synthetica.comboPopup.insets", popup) != null;
        if (!comboPopupConfigured && popup.getName() != null && popup.getName().startsWith("ComboPopup")) {
            if (!SyntheticaLookAndFeel.isWindowOpacityEnabled(null)) {
                JList list = SyntheticaLookAndFeel.findComponent(JList.class, (Container)popup);
                if (list != null) {
                    g.setColor(list.getBackground());
                } else {
                    g.setColor(popup.getBackground());
                }
                g.fillRect(x, y, w, h);
            }
            return;
        }
        JComponent panel = (JComponent)popup.getParent();
        String imagePath = this.resolveImagePath("Synthetica.popupMenu.background", popup);
        Insets dInsets = sInsets = this.getImageInsets("Synthetica.popupMenu.background.insets", popup);
        if (toplevelPopup) {
            dInsets = sInsets = this.getImageInsets("Synthetica.popupMenu.toplevel.background.insets", popup);
            Boolean belowInvoker = MenuPainter.popupIsBelowInvoker(invoker, popup);
            if (belowInvoker == null) {
                belowInvoker = false;
            }
            if ((imagePath = this.resolveImagePath("Synthetica.popupMenu.toplevel" + (belowInvoker != false ? ".belowInvoker.background" : ".aboveInvoker.background"), popup)) == null) {
                imagePath = this.resolveImagePath("Synthetica.popupMenu.toplevel.background", popup);
            }
        }
        if ((background = (BufferedImage)panel.getClientProperty("POPUP_BACKGROUND")) != null) {
            if (SyntheticaLookAndFeel.getBoolean("Synthetica.popupMenu.blur.enabled", popup)) {
                if (!((Boolean)panel.getClientProperty("POPUP_LIGHTWEIGHT")).booleanValue()) {
                    ImagePainter ip = new ImagePainter(background, g, x, y, w, h, sInsets, dInsets, false);
                    ip.drawBorder();
                }
                Insets insets = this.getImageInsets("Synthetica.popupMenu.blur.insets", popup);
                int size = SyntheticaLookAndFeel.getInt("Synthetica.popupMenu.blur.size", (Component)popup, 5);
                BufferedImage bg = Synthetica2DUtils.createBlurredImage(background, size);
                ImagePainter ip = new ImagePainter(bg, g, x, y, w, h, insets, insets, false);
                ip.drawCenter();
                String path = this.resolveImagePath("Synthetica.popupMenu.blur.background", popup);
                if (path != null && !toplevelPopup) {
                    imagePath = path;
                }
            } else {
                g.drawImage(background, x, y, null);
            }
        }
        ImagePainter imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
        imagePainter.draw();
        imagePath = this.resolveImagePath("Synthetica.popupMenu.iconSeparator", popup);
        if (imagePath != null && (SyntheticaLookAndFeel.preservePopupIconSpace(popup) || SyntheticaLookAndFeel.popupHasCheckRadio(popup)) && !SyntheticaLookAndFeel.popupHasCheckRadioWithIcon(popup)) {
            boolean ltr = popup.getComponentOrientation().isLeftToRight();
            Insets insets = popup.getInsets();
            int iGap = SyntheticaLookAndFeel.getInt("Synthetica.popupMenu.iconSeparator.gap", popup, 24, true);
            Integer iconWidth = (Integer)popup.getClientProperty("Synthetica.menuItem.maxIconWidth");
            int separatorWidth = SyntheticaLookAndFeel.getInt("Synthetica.popupMenu.iconSeparator.width", popup, 1, true);
            if (iconWidth != null && iconWidth > 0) {
                separatorWidth += iconWidth - SyntheticaLookAndFeel.getInstance().scaleInteger(16);
            }
            popup.putClientProperty("Synthetica.flipHorizontal", !ltr);
            int x_ = x + (ltr ? iGap : w - insets.right - iGap - separatorWidth + insets.left);
            int y_ = y + insets.top;
            int h_ = h - insets.top - insets.bottom;
            dInsets = sInsets = this.getImageInsets("Synthetica.popupMenu.iconSeparator.insets", popup, new Insets(0, 0, 0, 2));
            imagePainter = new ImagePainter(popup, g, x_, y_, separatorWidth, h_, imagePath, sInsets, dInsets, 0, 0);
            imagePainter.draw();
            popup.putClientProperty("Synthetica.flipHorizontal", false);
        }
    }

    protected void paintToplevelPopupMenuMarker(JPopupMenu popup, Insets toplevelInsets, Graphics g, int x, int y, int w, int h) {
        Icon icon;
        Component invoker;
        Boolean belowInvoker;
        if (topMarkerIcon == null) {
            topMarkerIcon = SyntheticaLookAndFeel.loadIcon("Synthetica.popupMenu.toplevel.topMarker.image", popup, true);
        }
        if (bottomMarkerIcon == null) {
            bottomMarkerIcon = SyntheticaLookAndFeel.loadIcon("Synthetica.popupMenu.toplevel.bottomMarker.image", popup, true);
        }
        Icon icon2 = (belowInvoker = MenuPainter.popupIsBelowInvoker(invoker = popup.getInvoker(), popup)) == null ? null : (icon = belowInvoker != false ? topMarkerIcon : bottomMarkerIcon);
        if (icon != null) {
            Point p = SwingUtilities.convertPoint(invoker, invoker.getWidth() / 2, y, popup);
            int y_ = belowInvoker != false ? y : y + h - icon.getIconHeight();
            icon.paintIcon(popup, g, p.x - icon.getIconWidth() / 2, y_);
        }
    }

    protected void paintToplevelPopupMenuTitleBackground(JComponent popup, Graphics g, int x, int y, int w, int h) {
        String imagePath = this.resolveImagePath("Synthetica.popupMenu.toplevel.title.background", popup);
        if (imagePath != null) {
            Insets insets = this.getImageInsets("Synthetica.popupMenu.toplevel.title.background.insets", popup);
            ImagePainter imagePainter = new ImagePainter(g, x, y, w, h, imagePath, insets, insets, 0, 0);
            imagePainter.draw();
        }
    }

    static Boolean popupIsBelowInvoker(Component invoker, JPopupMenu popup) {
        Point p1 = invoker.getLocation();
        SwingUtilities.convertPointToScreen(p1, invoker.getParent());
        Point p2 = new Point(0, popup.getLocation().y);
        SwingUtilities.convertPointToScreen(p2, popup.getParent());
        if (p2.y >= p1.y + invoker.getHeight() / 2) {
            return Boolean.TRUE;
        }
        if (p2.y + popup.getHeight() <= p1.y + invoker.getHeight() / 2) {
            return Boolean.FALSE;
        }
        return null;
    }

    public void paintMenuBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        boolean hover;
        boolean mouseOver;
        String imagePath = null;
        JMenu m = (JMenu)sc.getComponent();
        int state = sc.getComponentState();
        boolean disabled = (state & 8) > 0;
        boolean selected = (state & 0x200) > 0;
        Boolean b = (Boolean)m.getClientProperty("Synthetica.MOUSE_OVER");
        boolean bl = mouseOver = b == null ? false : b;
        if (mouseOver) {
            state |= 2;
        }
        boolean bl2 = hover = (state & 2) > 0;
        if (SyntheticaLookAndFeel.getJVMCompatibilityMode() == SyntheticaLookAndFeel.JVMCompatibilityMode.SUN) {
            try {
                Icon arrow = sc.getStyle().getIcon(sc, "Menu.arrowIcon");
                BasicMenuUI ui = (BasicMenuUI)((JMenu)sc.getComponent()).getUI();
                Class<?> clazz = Class.forName("javax.swing.plaf.basic.BasicMenuItemUI");
                Field field = clazz.getDeclaredField("arrowIcon");
                field.setAccessible(true);
                field.set(ui, arrow);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        imagePath = "Synthetica.menu";
        Insets sInsets = null;
        if (m.isTopLevelMenu()) {
            if (SyntheticaLookAndFeel.getBoolean("Synthetica.menu.toplevel.paintMenuBarBackground", m.getParent())) {
                imagePath = String.valueOf(imagePath) + ".toplevel.menuBarBackground";
                Container parent = m.getParent();
                imagePath = this.isSingleTopLevelMenu(m, parent) ? String.valueOf(imagePath) + ".single" : (this.isFirstTopLevelMenu(m, parent) ? String.valueOf(imagePath) + ".first" : (this.isLastTopLevelMenu(m, parent) ? String.valueOf(imagePath) + ".last" : String.valueOf(imagePath) + ".middle"));
                imagePath = this.resolveImagePath(imagePath, m);
                sInsets = this.getImageInsets("Synthetica.menu.toplevel.menuBarBackground.insets", m);
                ImagePainter imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, sInsets, 0, 0);
                imagePainter.draw();
                imagePath = "Synthetica.menu";
            }
            imagePath = String.valueOf(imagePath) + ".toplevel.background";
            if (disabled) {
                imagePath = String.valueOf(imagePath) + ".disabled";
            } else if (selected) {
                imagePath = String.valueOf(imagePath) + ".selected";
            } else if (hover) {
                imagePath = String.valueOf(imagePath) + (this.resolveImagePath(String.valueOf(imagePath) + ".hover", m) != null ? ".hover" : ".selected");
            }
            imagePath = this.resolveImagePath(imagePath, m);
            sInsets = this.getImageInsets("Synthetica.menu.toplevel.background.insets", m);
        } else {
            if (disabled) {
                imagePath = String.valueOf(imagePath) + ".disabled";
            } else if (hover) {
                imagePath = String.valueOf(imagePath) + ".hover";
            } else if (selected) {
                imagePath = this.resolveImagePath(String.valueOf(imagePath) + ".selected", m) == null ? String.valueOf(imagePath) + ".hover" : String.valueOf(imagePath) + ".selected";
            }
            imagePath = this.resolveImagePath(imagePath, m);
            sInsets = this.getImageInsets("Synthetica.menu.insets", m);
        }
        if (imagePath != null) {
            Insets dInsets = sInsets;
            int cycles = 0;
            int delay = 0;
            int type = 0;
            if (hover || selected) {
                state |= 2;
                cycles = SyntheticaLookAndFeel.getInt("Synthetica.menu.hover.animation.cycles", (Component)m, 1);
                delay = SyntheticaLookAndFeel.getInt("Synthetica.menu.hover.animation.delay", (Component)m, 50);
                type = SyntheticaLookAndFeel.getInt("Synthetica.menu.hover.animation.type", (Component)m, 1);
            } else {
                cycles = SyntheticaLookAndFeel.getInt("Synthetica.menu.animation.cycles", (Component)m, 1);
                delay = SyntheticaLookAndFeel.getInt("Synthetica.menu.animation.delay", (Component)m, 50);
                type = SyntheticaLookAndFeel.getInt("Synthetica.menu.animation.type", (Component)m, 2);
            }
            ImagePainter imagePainter = new ImagePainter((JComponent)m, cycles, delay, type, state, g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
            imagePainter.draw();
        }
    }

    protected boolean isSingleTopLevelMenu(JMenu menu, Container parent) {
        return this.isFirstTopLevelMenu(menu, parent) && this.isLastTopLevelMenu(menu, parent);
    }

    protected boolean isFirstTopLevelMenu(JMenu menu, Container parent) {
        JMenu m = null;
        Component[] componentArray = parent.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (m == null && c == menu) {
                return true;
            }
            if (m != null) {
                return false;
            }
            if (c instanceof JMenu) {
                m = (JMenu)c;
            }
            ++n2;
        }
        return false;
    }

    protected boolean isLastTopLevelMenu(JMenu menu, Container parent) {
        JMenu m = null;
        Component[] componentArray = parent.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c instanceof JMenu) {
                m = (JMenu)c;
            }
            ++n2;
        }
        return m == menu;
    }

    public void paintMenuItemBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        boolean defaultBackground;
        JComponent c = sc.getComponent();
        String imagePath = "Synthetica.menuItem";
        int state = sc.getComponentState();
        boolean disabled = (state & 8) > 0;
        boolean hover = (state & 2) > 0;
        Color background = c.getBackground();
        boolean bl = defaultBackground = background == null || background instanceof ColorUIResource;
        if (!defaultBackground && !hover) {
            g.setColor(background);
            g.fillRect(x, y, w, h);
        }
        if (disabled) {
            imagePath = String.valueOf(imagePath) + ".disabled";
        } else if (hover) {
            imagePath = String.valueOf(imagePath) + ".hover";
        }
        imagePath = this.resolveImagePath(imagePath, c);
        if (imagePath != null) {
            Insets sInsets;
            Insets dInsets = sInsets = this.getImageInsets("Synthetica.menuItem.insets", c);
            int cycles = 0;
            int delay = 0;
            int type = 0;
            if (hover) {
                cycles = SyntheticaLookAndFeel.getInt("Synthetica.menuItem.hover.animation.cycles", (Component)c, 1);
                delay = SyntheticaLookAndFeel.getInt("Synthetica.menuItem.hover.animation.delay", (Component)c, 50);
                type = SyntheticaLookAndFeel.getInt("Synthetica.menuItem.hover.animation.type", (Component)c, 1);
            } else {
                cycles = SyntheticaLookAndFeel.getInt("Synthetica.menuItem.animation.cycles", (Component)c, 1);
                delay = SyntheticaLookAndFeel.getInt("Synthetica.menuItem.animation.delay", (Component)c, 50);
                type = SyntheticaLookAndFeel.getInt("Synthetica.menuItem.animation.type", (Component)c, 2);
            }
            ImagePainter imagePainter = new ImagePainter(c, cycles, delay, type, state, g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
            imagePainter.draw();
        }
    }

    public void paintRadioButtonMenuItemBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        this.paintMenuItemBackground(sc, g, x, y, w, h);
    }

    public void paintRadioButtonMenuItemBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
    }

    public void paintCheckBoxMenuItemBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        this.paintMenuItemBackground(sc, g, x, y, w, h);
    }

    public void paintCheckBoxMenuItemBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
    }

    public void paintMenuBarBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        this.paintMenuBarBackground(sc.getComponent(), new SyntheticaState(sc.getComponentState()), g, x, y, w, h);
    }

    public void paintMenuBarBackground(JComponent c, SyntheticaState state, Graphics g, int x, int y, int w, int h) {
        Container parent = c.getRootPane().getParent();
        boolean active = true;
        if (parent instanceof Window) {
            active = ((Window)parent).isActive();
        } else if (parent instanceof JInternalFrame) {
            active = ((JInternalFrame)parent).isSelected();
        }
        String imagePath = "Synthetica.menuBar.background";
        imagePath = active ? String.valueOf(imagePath) + ".active" : String.valueOf(imagePath) + ".inactive";
        imagePath = this.resolveImagePath(imagePath, c);
        if (imagePath != null) {
            Insets insets;
            Insets sInsets;
            Insets dInsets = sInsets = (insets = this.getImageInsets("Synthetica.menuBar.background.insets", c));
            int xPolicy = 0;
            if (SyntheticaLookAndFeel.getBoolean("Synthetica.menuBar.background.horizontalTiled", c)) {
                xPolicy = 1;
            }
            int yPolicy = 0;
            if (SyntheticaLookAndFeel.getBoolean("Synthetica.menuBar.background.verticalTiled", c)) {
                yPolicy = 1;
            }
            UIKey key = new UIKey("menuBar.background", state);
            int cycles = SyntheticaLookAndFeel.getInt(key.get("animation.cycles"), (Component)c, 1);
            int delay = SyntheticaLookAndFeel.getInt(key.get("animation.delay"), (Component)c, 50);
            int type = SyntheticaLookAndFeel.getInt(key.get("animation.type"), (Component)c, active ? 0 : 6);
            ImagePainter imagePainter = new ImagePainter(c, cycles, delay, type, state.getState(), g, x, y, w, h, imagePath, sInsets, dInsets, xPolicy, yPolicy);
            imagePainter.draw();
            imagePath = "Synthetica.menuBar.background.light";
            imagePath = active ? String.valueOf(imagePath) + ".active" : String.valueOf(imagePath) + ".inactive";
            imagePath = this.resolveImagePath(imagePath, c);
            if (imagePath != null) {
                imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, dInsets, 0, yPolicy);
                imagePainter.draw();
            }
        }
    }
}

