/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaComponentPainter;
import de.javasoft.plaf.synthetica.painter.UIKey;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.SynthContext;

public class SeparatorPainter
extends SyntheticaComponentPainter {
    public static final String UI_KEY = "Synthetica.SeparatorPainter";
    private static HashMap<String, Image> imgCache = new HashMap();

    protected SeparatorPainter() {
    }

    public static SeparatorPainter getInstance() {
        return SeparatorPainter.getInstance(null);
    }

    public static SeparatorPainter getInstance(SynthContext sc) {
        SyntheticaComponentPainter instance = (SyntheticaComponentPainter)instances.get(SeparatorPainter.getPainterClassName(sc, SeparatorPainter.class, UI_KEY));
        if (instance == null) {
            instance = SeparatorPainter.getInstance(sc, SeparatorPainter.class, UI_KEY);
        }
        return (SeparatorPainter)instance;
    }

    public void paintSeparatorBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
    }

    public void paintSeparatorBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        JComponent c = sc.getComponent();
        if (c.getParent() instanceof JPopupMenu || c instanceof JPopupMenu.Separator) {
            JPopupMenu popup = (JPopupMenu)SwingUtilities.getAncestorOfClass(JPopupMenu.class, c);
            String imagePath = "Synthetica.popupMenuSeparator";
            if ((imagePath = this.resolveImagePath(imagePath, popup)) != null) {
                Insets sInsets;
                boolean clip = SyntheticaLookAndFeel.getBoolean("Synthetica.popupMenu.iconSeparator.clip", popup, true);
                if (popup != null && clip && (SyntheticaLookAndFeel.preservePopupIconSpace(popup) || SyntheticaLookAndFeel.popupHasCheckRadio(popup)) && !SyntheticaLookAndFeel.popupHasCheckRadioWithIcon(popup)) {
                    Insets insets = popup.getInsets();
                    boolean ltr = popup.getComponentOrientation().isLeftToRight();
                    int pGap = SyntheticaLookAndFeel.getInt("Synthetica.popupMenuSeparator.iconSeparatorGap", (Component)popup, true);
                    int iGap = SyntheticaLookAndFeel.getInt("Synthetica.popupMenu.iconSeparator.gap", popup, 24, true);
                    Integer iconWidth = (Integer)popup.getClientProperty("Synthetica.menuItem.maxIconWidth");
                    if (iconWidth != null && iconWidth > 16) {
                        iGap += iconWidth - SyntheticaLookAndFeel.getInstance().scaleInteger(16);
                    }
                    int iconSeparatorWidth = SyntheticaLookAndFeel.getInt("Synthetica.popupMenu.iconSeparator.width", popup, 1, true);
                    int w_ = iGap + iconSeparatorWidth + pGap - insets.left;
                    x += ltr ? w_ : 0;
                    w -= w_;
                }
                Insets dInsets = sInsets = this.getImageInsets("Synthetica.popupMenuSeparator.insets", popup);
                int xPolicy = 0;
                if (SyntheticaLookAndFeel.getBoolean("Synthetica.popupMenuSeparator.horizontalTiled", popup)) {
                    xPolicy = 1;
                }
                int yPolicy = 0;
                if (SyntheticaLookAndFeel.getBoolean("Synthetica.popupMenuSeparator.verticalTiled", popup)) {
                    yPolicy = 1;
                }
                ImagePainter imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, dInsets, xPolicy, yPolicy);
                imagePainter.draw();
            }
        }
    }

    public void paintSeparatorForeground(SynthContext sc, Graphics g, int x, int y, int w, int h, int orientation) {
        int h_;
        Insets sInsets;
        String imagePath = "Synthetica.separator";
        JComponent c = sc.getComponent();
        if (c instanceof JPopupMenu.Separator) {
            return;
        }
        Insets stInsets = sc.getStyle().getInsets(sc, null);
        Insets insets = c.getInsets();
        w -= insets.left + insets.right - stInsets.left - stInsets.right;
        h -= insets.top + insets.bottom - stInsets.top - stInsets.bottom;
        x += insets.left - stInsets.left;
        y += insets.top - stInsets.top;
        boolean isToolBarSeparator = c instanceof JToolBar.Separator;
        if (isToolBarSeparator) {
            imagePath = String.valueOf(imagePath) + ".toolBar";
        } else if (c.getParent() instanceof JComponent && (((JComponent)c.getParent()).getUIClassID().equals("StatusBarUI") || "StatusBar".equals(SyntheticaLookAndFeel.getStyleName(c.getParent())))) {
            imagePath = String.valueOf(imagePath) + ".statusBar";
        }
        imagePath = String.valueOf(imagePath) + ".image";
        imagePath = orientation == 0 ? String.valueOf(imagePath) + ".x" : String.valueOf(imagePath) + ".y";
        if (isToolBarSeparator) {
            Container parent = c.getRootPane().getParent();
            boolean active = true;
            if (parent instanceof Window) {
                active = ((Window)parent).isActive();
            } else if (parent instanceof JInternalFrame) {
                active = ((JInternalFrame)parent).isSelected();
            }
            if (!active && this.resolveImagePath(String.valueOf(imagePath) + ".inactive", c) != null) {
                imagePath = String.valueOf(imagePath) + ".inactive";
            }
        }
        UIKey key = new UIKey(imagePath, new SyntheticaState(0), "");
        Insets dInsets = sInsets = (Insets)key.findProperty(sc, "insets", 2);
        imagePath = this.resolveImagePath(imagePath, c);
        if (isToolBarSeparator) {
            if (imagePath == null) {
                return;
            }
            Image image = imgCache.get(imagePath);
            if (image == null) {
                image = new ImageIcon(SyntheticaLookAndFeel.getResource(imagePath)).getImage();
                imgCache.put(imagePath, image);
            }
            this.adjustToolBarSeparatorSize((JToolBar.Separator)c, SyntheticaLookAndFeel.getInstance().scaleInteger(image.getWidth(null)), SyntheticaLookAndFeel.getInstance().scaleInteger(image.getHeight(null)));
        }
        int sepWidth = isToolBarSeparator ? 0 : (Integer)sc.getStyle().get(sc, "Separator.thickness");
        int w_ = orientation == 0 || isToolBarSeparator ? w : sepWidth;
        int n = h_ = orientation == 1 || isToolBarSeparator ? h : sepWidth;
        if (imagePath == null) {
            g.setColor(sc.getStyle().getColor(sc, ColorType.BACKGROUND));
            g.fillRect(x, y, w_, h_);
        } else {
            ImagePainter imagePainter = new ImagePainter(c, 1, 50, 0, 0, g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
            imagePainter.draw();
        }
    }

    protected void adjustToolBarSeparatorSize(JToolBar.Separator separator, int width, int height) {
        if (SyntheticaLookAndFeel.getToolbarSeparatorDimension() == null) {
            int w = 0;
            int h = 0;
            Component[] componentArray = separator.getParent().getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component comp = componentArray[n2];
                if (!(comp instanceof JToolBar.Separator)) {
                    if (comp.getMinimumSize().width > w) {
                        w = comp.getMinimumSize().width;
                    }
                    if (comp.getMinimumSize().height > h) {
                        h = comp.getMinimumSize().height;
                    }
                }
                ++n2;
            }
            DimensionUIResource newSize = null;
            newSize = separator.getOrientation() == 1 ? new DimensionUIResource(width, h) : new DimensionUIResource(w, height);
            if (!newSize.equals(separator.getSize())) {
                separator.setSeparatorSize(newSize);
                separator.revalidate();
            }
        }
    }
}

