/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.FocusPainter;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaComponentPainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaPainterState;
import de.javasoft.plaf.synthetica.painter.UIKey;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.SynthContext;

public class SpinnerPainter
extends SyntheticaComponentPainter {
    public static final String UI_KEY = "Synthetica.SpinnerPainter";

    protected SpinnerPainter() {
    }

    public static SpinnerPainter getInstance() {
        return SpinnerPainter.getInstance(null);
    }

    public static SpinnerPainter getInstance(SynthContext sc) {
        SyntheticaComponentPainter instance = (SyntheticaComponentPainter)instances.get(SpinnerPainter.getPainterClassName(sc, SpinnerPainter.class, UI_KEY));
        if (instance == null) {
            instance = SpinnerPainter.getInstance(sc, SpinnerPainter.class, UI_KEY);
        }
        return (SpinnerPainter)instance;
    }

    public void paintSpinnerBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        JSpinner spinner = (JSpinner)sc.getComponent();
        if (this.hasFocus(spinner)) {
            FocusPainter.paintFocus("focus.spinner", sc, g, x, y, w, h);
        }
    }

    public void paintSpinnerBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        boolean keyExists;
        boolean innerBorderIsDefault;
        JSpinner spinner;
        spinner.putClientProperty("Synthetica.flipHorizontal", !(spinner = (JSpinner)sc.getComponent()).getComponentOrientation().isLeftToRight());
        Color background = spinner.getBackground();
        boolean defaultBackground = background == null || background instanceof ColorUIResource;
        boolean noBorderIfColored = SyntheticaLookAndFeel.getBoolean("Synthetica.spinner.noBorderIfColored", spinner);
        boolean opaque = SyntheticaLookAndFeel.isOpaque(spinner);
        if (!opaque) {
            return;
        }
        if (defaultBackground) {
            background = sc.getStyle().getColor(sc, ColorType.BACKGROUND);
        }
        SyntheticaPainterState state = new SyntheticaPainterState(sc, 0, true);
        UIKey key = new UIKey("spinner", state);
        Boolean fillBackground = (Boolean)SyntheticaLookAndFeel.get(key.get("fillBackground"), spinner);
        Border border = spinner.getBorder();
        Border defaultBorder = SyntheticaLookAndFeel.findDefaultBorder(border);
        boolean bl = innerBorderIsDefault = border instanceof CompoundBorder && ((CompoundBorder)border).getInsideBorder() == defaultBorder;
        if (innerBorderIsDefault) {
            Insets ins = border.getBorderInsets(spinner);
            Insets ins_ = defaultBorder.getBorderInsets(spinner);
            x += ins.left - ins_.left;
            y += ins.top - ins_.top;
            w -= ins.left - ins_.left + ins.right - ins_.right;
            h -= ins.top - ins_.top + ins.bottom - ins_.bottom;
        }
        if (fillBackground == null || fillBackground.booleanValue()) {
            this.fillBackground(spinner, border, defaultBorder, g, background, x, y, w, h);
        }
        if (!defaultBackground && noBorderIfColored) {
            return;
        }
        SyntheticaState state_ = new SyntheticaState(state.getState());
        state_.resetState(SyntheticaState.State.HOVER);
        state_.resetState(SyntheticaState.State.PRESSED);
        key = new UIKey("spinner.border", state_);
        String key_ = key.get();
        boolean bl2 = keyExists = SyntheticaLookAndFeel.get(key_, spinner) != null;
        if (key_.equals("Synthetica.spinner.border.disabled") && !keyExists) {
            key = new UIKey("textField.border", state_);
        }
        String imagePath = key.resolveImagePath(sc, 1);
        if (this.hasFocus(spinner) && this.resolveImagePath(String.valueOf(key.get()) + ".focused", spinner) != null) {
            imagePath = this.resolveImagePath(String.valueOf(key.get()) + ".focused", spinner);
        }
        Insets sInsets = this.getImageInsets("Synthetica.spinner.border.insets", spinner);
        Insets dInsets = this.getImageInsets("Synthetica.spinner.border.dInsets", spinner, sInsets);
        if (defaultBorder == null) {
            Insets insets = spinner.getInsets();
            x += insets.left;
            y += insets.top;
            w += -insets.left - insets.right;
            h += -insets.top - insets.bottom;
            dInsets = new Insets(0, 0, 0, 0);
        }
        ImagePainter imagePainter = new ImagePainter(spinner, g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
        if (!defaultBackground) {
            imagePainter.drawBorder();
        } else if (defaultBorder == null) {
            imagePainter.drawCenter();
        } else {
            imagePainter.draw();
        }
        if (SyntheticaLookAndFeel.getBoolean("Synthetica.spinner.hoverAndPressed.enabled", spinner)) {
            this.paintHoverPressed(spinner, state, border, defaultBorder, innerBorderIsDefault, g, x, y, w, h, sInsets, dInsets);
        }
    }

    private void paintHoverPressed(JSpinner spinner, SyntheticaPainterState state, Border border, Border defaultBorder, boolean innerBorderIsDefault, Graphics g, int x, int y, int w, int h, Insets sInsets, Insets dInsets) {
        if (SyntheticaLookAndFeel.getBoolean("Synthetica.spinner.stateChange4ButtonOnly", spinner)) {
            boolean ltr = spinner.getComponentOrientation().isLeftToRight();
            if (sInsets.equals(dInsets)) {
                dInsets = new Insets(sInsets.top, 0, sInsets.bottom, sInsets.right);
            }
            int buttonWidth = SyntheticaLookAndFeel.findComponent("Spinner.nextButton", (Container)spinner).getWidth();
            Insets insets = innerBorderIsDefault ? defaultBorder.getBorderInsets(spinner) : spinner.getInsets();
            int relX = SyntheticaLookAndFeel.getInt("Synthetica.spinner.buttons.relativeX", spinner, 0, true);
            if (defaultBorder != null) {
                x += ltr ? w - insets.right - buttonWidth + relX : 0;
                w = buttonWidth + (ltr ? insets.right : insets.left) - relX;
            } else {
                x += ltr ? w - buttonWidth + relX : 0;
                w = buttonWidth - relX;
            }
        }
        String bKey = "spinner.border";
        if (SyntheticaLookAndFeel.getBoolean("Synthetica.spinner.stateChange4SingleButton", spinner)) {
            JButton b = (JButton)SyntheticaLookAndFeel.findComponent("Spinner.nextButton", (Container)spinner);
            if (b.getModel().isPressed() || b.getModel().isRollover()) {
                bKey = String.valueOf(bKey) + ".nextButton";
                if (b.getModel().isPressed()) {
                    state.setState(SyntheticaState.State.PRESSED);
                }
            }
            if ((b = (JButton)SyntheticaLookAndFeel.findComponent("Spinner.previousButton", (Container)spinner)).getModel().isPressed() || b.getModel().isRollover()) {
                bKey = String.valueOf(bKey) + ".previousButton";
                if (b.getModel().isPressed()) {
                    state.setState(SyntheticaState.State.PRESSED);
                }
            }
        }
        UIKey borderKey = new UIKey(bKey, state);
        String imagePath = UIKey.resolveImagePath(spinner, borderKey.get(), null, 1);
        UIKey key = new UIKey("spinner", state);
        int cycles = SyntheticaLookAndFeel.getInt(key.get("animation.cycles"), (Component)spinner, 1);
        int delay = SyntheticaLookAndFeel.getInt(key.get("animation.delay"), (Component)spinner, 50);
        int type = SyntheticaLookAndFeel.getInt(key.get("animation.type"), (Component)spinner, 2);
        if (state.isSet(SyntheticaState.State.HOVER) || state.isSet(SyntheticaState.State.PRESSED)) {
            type = SyntheticaLookAndFeel.getInt(key.get("animation.type"), (Component)spinner, 1);
        }
        ImagePainter imagePainter = new ImagePainter((JComponent)spinner, cycles, delay, type, state.getState(), g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
        if (defaultBorder == null) {
            imagePainter.drawCenter();
        } else {
            imagePainter.draw();
        }
    }

    protected boolean hasFocus(JComponent c) {
        if (c.isEnabled() && c.isFocusable()) {
            Component editor = SyntheticaLookAndFeel.findComponent("Spinner.formattedTextField", (Container)c);
            if (c.hasFocus() || editor != null && editor.hasFocus()) {
                return true;
            }
        }
        return false;
    }

    private void fillBackground(JSpinner spinner, Border border, Border defaultBorder, Graphics g, Color background, int x, int y, int w, int h) {
        Color color = g.getColor();
        g.setColor(background);
        Insets insets = spinner.getInsets();
        if (border == null || insets.equals(new Insets(0, 0, 0, 0))) {
            g.fillRect(x, y, w, h);
        } else if (defaultBorder == null) {
            g.fillRect(x + insets.left, y + insets.top, w - insets.left - insets.right, h - insets.top - insets.bottom);
        } else {
            Insets fillInsets = SyntheticaLookAndFeel.getInsets("Synthetica.spinner.border.fillInsets", (Component)spinner, false, true);
            int arcWidth = SyntheticaLookAndFeel.getInt("Synthetica.spinner.border.arcWidth", spinner, 8, true);
            int arcHeight = SyntheticaLookAndFeel.getInt("Synthetica.spinner.border.arcHeight", spinner, 8, true);
            Graphics2D g2 = (Graphics2D)g;
            RenderingHints rh = g2.getRenderingHints();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.fillRoundRect(x + fillInsets.left, y + fillInsets.top, w - fillInsets.left - fillInsets.right, h - fillInsets.top - fillInsets.bottom, arcWidth, arcHeight);
            g2.setRenderingHints(rh);
        }
        g.setColor(color);
    }

    @Override
    public int getCacheHash(SynthContext sc, int w, int h, int meta, String id) {
        JComponent c = sc.getComponent();
        int hash = super.getCacheHash(sc, w, h, meta, id);
        hash = hash * 31 + (this.hasFocus(c) ? 0 : 1);
        return hash;
    }
}

