/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.FocusPainter;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaComponentPainter;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.plaf.synth.SynthContext;

public class ToggleButtonPainter
extends SyntheticaComponentPainter {
    public static final String UI_KEY = "Synthetica.ToggleButtonPainter";

    protected ToggleButtonPainter() {
    }

    public static ToggleButtonPainter getInstance() {
        return ToggleButtonPainter.getInstance(null);
    }

    public static ToggleButtonPainter getInstance(SynthContext sc) {
        SyntheticaComponentPainter instance = (SyntheticaComponentPainter)instances.get(ToggleButtonPainter.getPainterClassName(sc, ToggleButtonPainter.class, UI_KEY));
        if (instance == null) {
            instance = ToggleButtonPainter.getInstance(sc, ToggleButtonPainter.class, UI_KEY);
        }
        return (ToggleButtonPainter)instance;
    }

    public void paintToggleButtonBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        AbstractButton button = (AbstractButton)sc.getComponent();
        if (!button.isContentAreaFilled()) {
            this.paintToggleButtonBackground(sc, g, x, y, w, h);
        }
    }

    public void paintToggleButtonBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        if (!this.paintCheck(sc)) {
            return;
        }
        AbstractButton button = (AbstractButton)sc.getComponent();
        int state = sc.getComponentState();
        if ((state & 4) > 0 && (state & 2) > 0) {
            state ^= 2;
        }
        String segPos = SyntheticaLookAndFeel.getClientProperty("JButton.segmentPosition", button, "");
        if (SyntheticaLookAndFeel.isOpaque(button)) {
            this.paintToggleButtonBackground(button, new SyntheticaState(state), segPos, g, x, y, w, h);
        }
    }

    public void paintToggleButtonBackground(JComponent c, SyntheticaState state, String segmentPosition, Graphics g, int x, int y, int w, int h) {
        String imagePath;
        Insets sInsets;
        boolean isToolBarComponent = this.isToolBarButton(c);
        boolean isSegmentedButton = segmentPosition != null && segmentPosition.length() > 0;
        String segPos = this.createSuffix(segmentPosition);
        Insets dInsets = sInsets = this.getImageInsets("Synthetica.toggleButton.border.insets", c);
        String string = imagePath = isToolBarComponent && isSegmentedButton ? "Synthetica.toolBar.toggleButton" : "Synthetica.toggleButton";
        if (this.isToolBarButtonBarButton(c)) {
            String key = "Synthetica.toolBar.buttonBar.toggleButton.border" + segPos;
            if (state.isSet(SyntheticaState.State.PRESSED)) {
                key = String.valueOf(key) + ".pressed";
            } else {
                if (state.isSet(SyntheticaState.State.SELECTED)) {
                    key = String.valueOf(key) + ".selected";
                }
                if (state.isSet(SyntheticaState.State.HOVER)) {
                    key = String.valueOf(key) + ".hover";
                }
            }
            if (this.resolveImagePath(key, c) != null) {
                imagePath = "Synthetica.toolBar.buttonBar.toggleButton";
            }
        }
        imagePath = String.valueOf(imagePath) + ".border";
        imagePath = String.valueOf(imagePath) + segPos;
        if (state.isSet(SyntheticaState.State.PRESSED) && this.resolveImagePath(String.valueOf(imagePath) + ".pressed", c) != null) {
            imagePath = String.valueOf(imagePath) + ".pressed";
        } else if (state.isSet(SyntheticaState.State.SELECTED)) {
            imagePath = String.valueOf(imagePath) + ".selected";
        }
        if (!c.isEnabled()) {
            imagePath = String.valueOf(imagePath) + ".disabled";
        }
        if (isSegmentedButton) {
            if (state.isSet(SyntheticaState.State.HOVER)) {
                imagePath = String.valueOf(imagePath) + ".hover";
            }
        } else if (isToolBarComponent && state.isSet(SyntheticaState.State.HOVER) && !state.isSet(SyntheticaState.State.SELECTED) && !SyntheticaLookAndFeel.getBoolean("Synthetica.toolBar.buttons.paintBorder", c)) {
            imagePath = "Synthetica.toolBar.button.border.hover";
        } else if (isToolBarComponent && state.isSet(SyntheticaState.State.PRESSED)) {
            imagePath = "Synthetica.toolBar.button.border.pressed";
        } else if (isToolBarComponent && !state.isSet(SyntheticaState.State.SELECTED) && !SyntheticaLookAndFeel.getBoolean("Synthetica.toolBar.buttons.paintBorder", c)) {
            imagePath = "Synthetica.toolBar.button.border";
        } else if (isToolBarComponent && state.isSet(SyntheticaState.State.SELECTED) && !state.isSet(SyntheticaState.State.HOVER) && this.resolveImagePath("Synthetica.toolBar.toggleButton.border.selected", c) != null) {
            imagePath = "Synthetica.toolBar.toggleButton.border.selected";
        } else if (isToolBarComponent && state.isSet(SyntheticaState.State.SELECTED) && state.isSet(SyntheticaState.State.HOVER) && this.resolveImagePath("Synthetica.toolBar.toggleButton.border.selectedAndHover", c) != null) {
            imagePath = "Synthetica.toolBar.toggleButton.border.selectedAndHover";
        } else if (state.isSet(SyntheticaState.State.HOVER)) {
            imagePath = String.valueOf(imagePath) + ".hover";
        }
        if (c.hasFocus() && this.resolveImagePath(String.valueOf(imagePath) + ".focused", c) != null) {
            imagePath = String.valueOf(imagePath) + ".focused";
        }
        if ((imagePath = this.resolveImagePath(imagePath, c)) != null) {
            int cycles = 0;
            int delay = 0;
            int type = 0;
            if (state.isSet(SyntheticaState.State.HOVER)) {
                cycles = SyntheticaLookAndFeel.getInt("Synthetica.toggleButton.hover.animation.cycles", (Component)c, 1);
                delay = SyntheticaLookAndFeel.getInt("Synthetica.toggleButton.hover.animation.delay", (Component)c, 50);
                type = SyntheticaLookAndFeel.getInt("Synthetica.toggleButton.hover.animation.type", (Component)c, 1);
            } else {
                cycles = SyntheticaLookAndFeel.getInt("Synthetica.toggleButton.animation.cycles", (Component)c, 1);
                delay = SyntheticaLookAndFeel.getInt("Synthetica.toggleButton.animation.delay", (Component)c, 50);
                type = SyntheticaLookAndFeel.getInt("Synthetica.toggleButton.animation.type", (Component)c, 2);
            }
            ImagePainter imagePainter = new ImagePainter(c, cycles, delay, type, state.getState(), g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
            this.drawButton(imagePainter, c, state);
        }
        if (c.hasFocus() && ((AbstractButton)c).isFocusPainted()) {
            this.paintFocus(c, state, segmentPosition, g, x, y, w, h);
        }
    }

    protected void drawButton(ImagePainter painter, JComponent c, SyntheticaState state) {
        painter.draw();
    }

    protected void paintFocus(JComponent c, SyntheticaState state, String segmentPosition, Graphics g, int x, int y, int w, int h) {
        String suffix = this.createSuffix(segmentPosition);
        String key = "focus.toggleButton" + suffix;
        if (this.isToolBarButton(c)) {
            key = String.valueOf(key) + ".toolBar";
        } else if (this.isToolBarButtonBarButton(c)) {
            key = String.valueOf(key) + ".buttonBar.toolBar";
        }
        FocusPainter.paintFocus(key, c, state.getState(), null, g, x, y, w, h);
    }

    private String createSuffix(String segmentPosition) {
        return segmentPosition == null || segmentPosition.length() == 0 ? "" : (segmentPosition.startsWith(".") ? segmentPosition : "." + segmentPosition);
    }

    protected boolean paintCheck(SynthContext sc) {
        AbstractButton button = (AbstractButton)sc.getComponent();
        int state = sc.getComponentState();
        boolean hover = (state & 2) > 0;
        boolean selected = (state & 0x200) > 0;
        boolean pressed = (state & 4) > 0;
        boolean isToolBarComponent = this.isToolBarButton(button);
        if (!(!isToolBarComponent || SyntheticaLookAndFeel.getBoolean("Synthetica.toolBar.buttons.paintBorder", button) || SyntheticaLookAndFeel.get("Synthetica.toolBar.toggleButton.border", button) != null || hover || selected || pressed && SyntheticaLookAndFeel.getBoolean("Synthetica.toolBar.button.pressed.paintBorder", button))) {
            return false;
        }
        return this.paintCheckContentBorder(button, new SyntheticaState(state));
    }

    protected boolean paintCheckContentBorder(AbstractButton button, SyntheticaState state) {
        if (button.isBorderPainted() || button.getText() == null || button.getText().length() == 0) {
            if (!(button.isBorderPainted() || state.isSet(SyntheticaState.State.HOVER) || state.isSet(SyntheticaState.State.SELECTED))) {
                return false;
            }
            if (!button.isContentAreaFilled()) {
                return false;
            }
        } else if (!button.isBorderPainted()) {
            return false;
        }
        return true;
    }

    private boolean isToolBarButton(JComponent button) {
        Boolean useToolBarStyle = (Boolean)button.getClientProperty("Synthetica.useToolBarStyle");
        return useToolBarStyle == null || useToolBarStyle != false ? button.getParent() instanceof JToolBar : false;
    }

    private boolean isToolBarButtonBarButton(JComponent button) {
        Container parent = button.getParent();
        return parent != null && parent.getParent() instanceof JToolBar && "ButtonBar".equals(SyntheticaLookAndFeel.getStyleName(parent));
    }

    @Override
    public int getCacheHash(SynthContext sc, int w, int h, int meta, String id) {
        AbstractButton b = (AbstractButton)sc.getComponent();
        String segPos = (String)b.getClientProperty("JButton.segmentPosition");
        Border border = b.getBorder();
        int hash = super.getCacheHash(sc, w, h, meta, id);
        int n = hash = segPos == null ? hash : 31 * hash + segPos.hashCode();
        hash = border == null ? hash : 31 * hash + (b.isBorderPainted() ? 0 : 1);
        hash = 31 * hash + (b.isContentAreaFilled() ? 0 : 1);
        hash = 31 * hash + (b.getParent() instanceof JToolBar ? 0 : 1);
        return hash;
    }
}

