/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.styles;

import de.javasoft.plaf.synthetica.GraphicsUtils;
import de.javasoft.plaf.synthetica.ScalableIcon;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.styles.MenuItemStyle;
import de.javasoft.plaf.synthetica.styles.StyleWrapper;
import de.javasoft.plaf.synthetica.util.Synthetica2DUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Window;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthStyle;

public class MenuStyle
extends StyleWrapper {
    private static MenuStyle instance = new MenuStyle();

    private MenuStyle() {
    }

    public static SynthStyle getStyle(SynthStyle style, JComponent c, Region region) {
        c.setOpaque(false);
        if (SyntheticaLookAndFeel.getStyleName(c) == null) {
            instance.setStyle(style);
            return instance;
        }
        MenuStyle sw = new MenuStyle();
        sw.setStyle(style);
        return sw;
    }

    @Override
    public int getInt(SynthContext sc, Object key, int defaultValue) {
        if ("Menu.delay".equals(key)) {
            Object val = this.get(sc, key);
            return val instanceof Number ? ((Number)val).intValue() : defaultValue;
        }
        return super.getInt(sc, key, defaultValue);
    }

    @Override
    public Font getFont(SynthContext sc) {
        MenuItemStyle.menuItemHtmlColorCorrection(sc);
        Font f = super.getFont(sc);
        JMenu m = (JMenu)sc.getComponent();
        Object size = SyntheticaLookAndFeel.get("Synthetica.menu.toplevel.fontSize", m);
        if (size != null && m.isTopLevelMenu()) {
            float fontSize = SyntheticaLookAndFeel.getInstance().scaleFontSize(Float.valueOf(size.toString()).floatValue());
            f = f.deriveFont(fontSize);
        }
        return f;
    }

    @Override
    public Color getColor(SynthContext sc, ColorType type) {
        Color color;
        boolean enabled;
        JMenu m = (JMenu)sc.getComponent();
        Boolean b = (Boolean)m.getClientProperty("Synthetica.MOUSE_OVER");
        boolean mouseOver = b == null ? false : b;
        boolean selected = (sc.getComponentState() & 0x200) > 0;
        boolean bl = enabled = (sc.getComponentState() & 1) > 0;
        if (m.isTopLevelMenu() && type.equals(ColorType.TEXT_FOREGROUND)) {
            String colorKey = "Synthetica.menu.toplevel.textColor";
            Window w = SwingUtilities.getWindowAncestor(m);
            if (!w.isActive() && SyntheticaLookAndFeel.getBoolean("Synthetica.window.decoration", w) && SyntheticaLookAndFeel.get(String.valueOf(colorKey) + ".inactive", w) != null && !selected && !mouseOver) {
                colorKey = String.valueOf(colorKey) + ".inactive";
            } else if (!enabled) {
                colorKey = String.valueOf(colorKey) + ".disabled";
            } else if (selected || mouseOver) {
                colorKey = String.valueOf(colorKey) + ".selected";
            }
            Color color2 = SyntheticaLookAndFeel.getColor(colorKey, m);
            if (color2 != null) {
                return color2;
            }
        } else if (type.equals(ColorType.TEXT_FOREGROUND) && !((color = m.getForeground()) instanceof UIResource)) {
            return color;
        }
        return this.synthStyle.getColor(sc, type);
    }

    @Override
    public Icon getIcon(SynthContext sc, Object key) {
        Icon icon = super.getIcon(sc, key);
        if ("Menu.arrowIcon".equals(key) && !sc.getComponent().getComponentOrientation().isLeftToRight()) {
            if (icon instanceof ScalableIcon) {
                icon = ((ScalableIcon)icon).getIcon();
            }
            if (icon != null) {
                icon = new ScalableIcon.ScalableIconUIResource(new ImageIcon(Synthetica2DUtils.flipHorizontal(GraphicsUtils.iconToImage(sc, icon))));
            }
        }
        return icon;
    }
}

