/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.styles;

import de.javasoft.plaf.synthetica.StyleFactory;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.styles.StyleWrapper;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;

public class ScrollPaneStyle
extends StyleWrapper {
    private static ScrollPaneStyle instance = new ScrollPaneStyle();
    private static String comboBoxViewportInsetsKey = "Synthetica.comboBox.viewport.border.insets";

    private ScrollPaneStyle() {
    }

    public static SynthStyle getStyle(SynthStyle style, JComponent c, Region region) {
        String className = (String)SyntheticaLookAndFeel.get("Synthetica.scrollPane.layoutManager.className", c);
        if (className != null && c.getLayout() != null) {
            try {
                Class<?> lmClass = Class.forName(className);
                if (!lmClass.isAssignableFrom(c.getLayout().getClass())) {
                    ((StyleFactory)SynthLookAndFeel.getStyleFactory()).getComponentPropertyStore().storeComponentProperty(c, "SYCP_LAYOUT_MANAGER");
                    c.setLayout((LayoutManager)lmClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (SyntheticaLookAndFeel.getStyleName(c) == null) {
            instance.setStyle(style);
            return instance;
        }
        ScrollPaneStyle sw = new ScrollPaneStyle();
        sw.setStyle(style);
        return sw;
    }

    @Override
    public Object get(SynthContext sc, Object key) {
        JScrollPane scroller = (JScrollPane)sc.getComponent();
        if ("ScrollPane.viewportBorderInsets".equals(key) && UIManager.get(comboBoxViewportInsetsKey) != null && scroller.getViewport().getView() != null && "ComboBox.list".equals(scroller.getViewport().getView().getName())) {
            return UIManager.getInsets(comboBoxViewportInsetsKey);
        }
        return super.get(sc, key);
    }

    @Override
    public Color getColor(SynthContext sc, ColorType type) {
        JScrollPane scrollPane = (JScrollPane)sc.getComponent();
        Component component = scrollPane.getViewport().getView();
        if (component == null) {
            return this.synthStyle.getColor(sc, type);
        }
        Color color = component.getBackground();
        if (component.getBackground() == null || component.getBackground() instanceof ColorUIResource) {
            color = Color.WHITE;
        }
        if (component instanceof JEditorPane && component.getBackground() instanceof ColorUIResource) {
            JEditorPane editorPane = (JEditorPane)component;
            if (!editorPane.isEditable()) {
                color = UIManager.getColor("Synthetica.editorPane.lockedColor");
            }
            if (!editorPane.isEnabled()) {
                color = UIManager.getColor("Synthetica.editorPane.disabledColor");
            }
        } else if (component instanceof JTextArea && component.getBackground() instanceof ColorUIResource) {
            JTextArea textArea = (JTextArea)component;
            if (!textArea.isEditable()) {
                color = UIManager.getColor("Synthetica.textArea.lockedColor");
            } else if (!textArea.isEnabled()) {
                color = UIManager.getColor("Synthetica.textArea.disabledColor");
            }
        }
        if (color != null) {
            return new ColorUIResource(color);
        }
        return super.getColor(sc, type);
    }
}

