/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.styles;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.styles.StyleWrapper;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthStyle;

public class TabbedPaneStyle
extends StyleWrapper {
    private static TabbedPaneStyle instance = new TabbedPaneStyle();

    private TabbedPaneStyle() {
    }

    public static SynthStyle getStyle(SynthStyle style, JComponent c, Region region) {
        if (SyntheticaLookAndFeel.getJVMCompatibilityMode() == SyntheticaLookAndFeel.JVMCompatibilityMode.SUN) {
            TabbedPaneStyle.installTabLayoutManager((JTabbedPane)c);
        }
        if (SyntheticaLookAndFeel.getStyleName(c) == null) {
            instance.setStyle(style);
            return instance;
        }
        TabbedPaneStyle sw = new TabbedPaneStyle();
        sw.setStyle(style);
        return sw;
    }

    @Override
    public Font getFont(SynthContext sc) {
        if (SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.tab.selected.bold", sc.getComponent())) {
            return super.getFont(sc).deriveFont(1);
        }
        return super.getFont(sc);
    }

    private static void installTabLayoutManager(JTabbedPane tp) {
        if (tp.getLayout().getClass().getName().contains(TabbedPaneStyle.class.getName())) {
            return;
        }
        if (!SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.tabs.stretch", tp) && (SyntheticaLookAndFeel.get("Synthetica.tabbedPane.rotateTabRuns", tp) == null || SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.rotateTabRuns", tp))) {
            return;
        }
        if (tp.getTabLayoutPolicy() == 1) {
            TabbedPaneStyle.installScrollLayout(tp);
        } else {
            TabbedPaneStyle.installWrapLayout(tp);
        }
    }

    private static void installWrapLayout(final JTabbedPane tp) {
        BasicTabbedPaneUI ui;
        BasicTabbedPaneUI basicTabbedPaneUI = ui = (BasicTabbedPaneUI)tp.getUI();
        basicTabbedPaneUI.getClass();
        tp.setLayout(new BasicTabbedPaneUI.TabbedPaneLayout(basicTabbedPaneUI){

            @Override
            protected void calculateTabRects(int tabPlacement, int tabCount) {
                super.calculateTabRects(tabPlacement, tabCount);
                if (SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.tabs.stretch", tp) && tabCount > 0) {
                    Rectangle[] rects = null;
                    try {
                        Class<?> clazz = Class.forName("javax.swing.plaf.basic.BasicTabbedPaneUI");
                        Field field = clazz.getDeclaredField("rects");
                        field.setAccessible(true);
                        rects = (Rectangle[])field.get(ui);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    Insets insets = tp.getInsets();
                    Insets tabAreaInsets = new Insets(0, 0, 0, 0);
                    try {
                        Class<?> clazz = Class.forName("javax.swing.plaf.basic.BasicTabbedPaneUI");
                        Method m = clazz.getDeclaredMethod("getTabAreaInsets", Integer.TYPE);
                        m.setAccessible(true);
                        tabAreaInsets = (Insets)m.invoke((Object)ui, tabPlacement);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    int width = tp.getWidth() - (insets.right + tabAreaInsets.right + insets.left + tabAreaInsets.left);
                    int maxStretch = SyntheticaLookAndFeel.getInt("Synthetica.tabbedPane.tabs.maxStretchFactor", (Component)tp, 3);
                    int start = 0;
                    int end = tabCount - 1;
                    Rectangle lastRect = rects[end];
                    int runWidth = lastRect.x + lastRect.width - rects[start].x;
                    if (runWidth >= width || runWidth < 1) {
                        return;
                    }
                    boolean maxStretchExceeded = width / runWidth > maxStretch;
                    tp.putClientProperty("Synthetica.maxStretchExceeded", maxStretchExceeded);
                    int centeredTabsFactor = SyntheticaLookAndFeel.getInt("Synthetica.tabbedPane.tabs.centeredTabsFactor", (Component)tp, maxStretch);
                    int maxWidth = maxStretchExceeded ? runWidth * centeredTabsFactor : width;
                    int deltaWidth = maxWidth - (lastRect.x + lastRect.width) + insets.left + tabAreaInsets.left;
                    int offset = (width - maxWidth) / 2;
                    float factor = (float)deltaWidth / (float)runWidth;
                    int i = start;
                    while (i <= end) {
                        Rectangle rect = rects[i];
                        rect.x = i == start ? (rect.x += offset) : rects[i - 1].x + rects[i - 1].width;
                        rect.width += Math.round((float)rect.width * factor);
                        ++i;
                    }
                }
            }

            @Override
            protected void rotateTabRuns(int tabPlacement, int selectedRun) {
                if (SyntheticaLookAndFeel.get("Synthetica.tabbedPane.rotateTabRuns", tp) == null || SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.rotateTabRuns", tp)) {
                    super.rotateTabRuns(tabPlacement, selectedRun);
                }
            }
        });
    }

    private static void installScrollLayout(JTabbedPane tp) {
    }
}

