/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.styles;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.styles.StyleWrapper;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthStyle;

public class ToolBarButtonStyle
extends StyleWrapper {
    private static ToolBarButtonStyle instance = new ToolBarButtonStyle();

    private ToolBarButtonStyle() {
    }

    public static SynthStyle getStyle(SynthStyle style, JComponent c, Region region) {
        if (SyntheticaLookAndFeel.getStyleName(c) == null) {
            instance.setStyle(style);
            return instance;
        }
        ToolBarButtonStyle sw = new ToolBarButtonStyle();
        sw.setStyle(style);
        return sw;
    }

    @Override
    public Object get(SynthContext sc, Object key) {
        Object val = super.get(sc, key);
        if ("Button.margin".equals(key) && val != null) {
            val = SyntheticaLookAndFeel.getInstance().scaleInsets((Insets)val);
        } else if ("Button.iconTextGap".equals(key) && val != null) {
            val = SyntheticaLookAndFeel.getInstance().scaleInteger((Integer)val);
        }
        return val;
    }

    @Override
    public Font getFont(SynthContext sc) {
        Font font = super.getFont(sc);
        JComponent c = sc.getComponent();
        if (SyntheticaLookAndFeel.get("Synthetica.toolBar.button.font.style", c) != null) {
            float size;
            int style = 0;
            String fontStyle = SyntheticaLookAndFeel.getString("Synthetica.toolBar.button.font.style", c);
            if (fontStyle.contains("BOLD")) {
                style |= 1;
            }
            if (fontStyle.contains("ITALIC")) {
                style |= 2;
            }
            if ((size = SyntheticaLookAndFeel.getInstance().scaleFontSize(SyntheticaLookAndFeel.getInt("Synthetica.toolBar.button.font.size", (Component)c, 0))) == 0.0f) {
                size = font.getSize2D();
            }
            font = new FontUIResource(font.deriveFont(style, size));
        } else if (SyntheticaLookAndFeel.get("Synthetica.toolBar.toggleButton.font.style", c) != null) {
            float size;
            int style = 0;
            String fontStyle = SyntheticaLookAndFeel.getString("Synthetica.toolBar.toggleButton.font.style", c);
            if (fontStyle.contains("BOLD")) {
                style |= 1;
            }
            if (fontStyle.contains("ITALIC")) {
                style |= 2;
            }
            if ((size = SyntheticaLookAndFeel.getInstance().scaleFontSize(SyntheticaLookAndFeel.getInt("Synthetica.toolBar.toggleButton.font.size", (Component)c, 0))) == 0.0f) {
                size = font.getSize2D();
            }
            font = new FontUIResource(font.deriveFont(style, size));
        }
        return font;
    }
}

