/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.ContextSensitiveCellEditor;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.JideTable;
import com.jidesoft.spinner.SpinnerWheelSupport;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Component;
import java.text.ParseException;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellEditor;

public class SpinnerCellEditor
extends ContextSensitiveCellEditor
implements TableCellEditor,
ChangeListener {
    public static EditorContext CONTEXT = new EditorContext("Spinner");
    protected JSpinner _spinner;
    private static final long serialVersionUID = -2261305860140664189L;

    public SpinnerCellEditor() {
        this(new SpinnerNumberModel());
    }

    public SpinnerCellEditor(SpinnerModel spinnerModel) {
        this.setAutoStopCellEditing(false);
        this._spinner = this.createSpinner(spinnerModel);
    }

    protected void customizeSpinner() {
        this._spinner.setOpaque(false);
        this._spinner.setBorder(DEFAULT_CELL_EDITOR_BORDER);
    }

    protected JSpinner createSpinner(SpinnerModel spinnerModel) {
        JSpinner jSpinner = new JSpinner(spinnerModel){

            @Override
            protected JComponent createEditor(SpinnerModel spinnerModel) {
                String[] stringArray = JideTable.w();
                boolean bl = spinnerModel instanceof SpinnerDateModel;
                if (stringArray == null) {
                    if (bl) {
                        return new JSpinner.DateEditor(this){

                            @Override
                            public void stateChanged(ChangeEvent changeEvent) {
                                block3: {
                                    b b2;
                                    block2: {
                                        String[] stringArray = JideTable.w();
                                        b2 = this;
                                        if (stringArray != null) break block2;
                                        if (b2.SpinnerCellEditor.this.getEditorStyle() == 2) break block3;
                                        b2 = this;
                                    }
                                    super.stateChanged(changeEvent);
                                }
                            }
                        };
                    }
                    bl = spinnerModel instanceof SpinnerListModel;
                }
                if (stringArray == null) {
                    if (bl) {
                        return new JSpinner.ListEditor(this){

                            @Override
                            public void stateChanged(ChangeEvent changeEvent) {
                                block3: {
                                    d d2;
                                    block2: {
                                        String[] stringArray = JideTable.w();
                                        d2 = this;
                                        if (stringArray != null) break block2;
                                        if (d2.SpinnerCellEditor.this.getEditorStyle() == 2) break block3;
                                        d2 = this;
                                    }
                                    super.stateChanged(changeEvent);
                                }
                            }
                        };
                    }
                    bl = spinnerModel instanceof SpinnerNumberModel;
                }
                if (bl) {
                    return new JSpinner.NumberEditor(this){

                        @Override
                        public void stateChanged(ChangeEvent changeEvent) {
                            block3: {
                                e e2;
                                block2: {
                                    String[] stringArray = JideTable.w();
                                    e2 = this;
                                    if (stringArray != null) break block2;
                                    if (e2.SpinnerCellEditor.this.getEditorStyle() == 2) break block3;
                                    e2 = this;
                                }
                                super.stateChanged(changeEvent);
                            }
                        }
                    };
                }
                return new JSpinner.DefaultEditor(this){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        block3: {
                            c c2;
                            block2: {
                                String[] stringArray = JideTable.w();
                                c2 = this;
                                if (stringArray != null) break block2;
                                if (c2.SpinnerCellEditor.this.getEditorStyle() == 2) break block3;
                                c2 = this;
                            }
                            super.stateChanged(changeEvent);
                        }
                    }
                };
            }
        };
        SpinnerWheelSupport.installMouseWheelSupport(jSpinner);
        return jSpinner;
    }

    @Override
    public Object getCellEditorValue() {
        try {
            this._spinner.commitEdit();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return this._spinner.getValue();
    }

    public void setCellEditorValue(Object object) {
        this._spinner.setValue(object);
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n2, int n3) {
        JSpinner jSpinner;
        block14: {
            SpinnerCellEditor spinnerCellEditor;
            block16: {
                block15: {
                    String[] stringArray;
                    block13: {
                        SpinnerCellEditor spinnerCellEditor2;
                        block11: {
                            block12: {
                                JTable jTable2;
                                block10: {
                                    stringArray = JideTable.w();
                                    jTable2 = jTable;
                                    if (stringArray != null) break block10;
                                    if (jTable2 != null) {
                                        this.customizeSpinner();
                                        JideSwingUtilities.installColorsAndFont(this._spinner, jTable.getBackground(), jTable.getForeground(), jTable.getFont());
                                    }
                                    spinnerCellEditor2 = this;
                                    if (stringArray != null) break block11;
                                    spinnerCellEditor2.setCellEditorValue(object);
                                    jTable2 = jTable;
                                }
                                if (jTable2 == null) break block12;
                                jSpinner = this.getSpinner();
                                if (stringArray != null) break block13;
                                if (jSpinner != null) {
                                    this.getSpinner().addChangeListener(this);
                                }
                            }
                            spinnerCellEditor2 = this;
                        }
                        jSpinner = spinnerCellEditor2.getSpinner();
                    }
                    if (stringArray != null) break block14;
                    if (jSpinner == null) break block15;
                    jSpinner = this.getSpinner();
                    if (stringArray != null) break block14;
                    if (!(jSpinner.getEditor() instanceof JSpinner.DefaultEditor)) break block15;
                    jSpinner = this.getSpinner();
                    if (stringArray != null) break block14;
                    JFormattedTextField jFormattedTextField = ((JSpinner.DefaultEditor)jSpinner.getEditor()).getTextField();
                    if (jFormattedTextField == null) break block15;
                    spinnerCellEditor = this;
                    if (stringArray != null) break block16;
                    if (spinnerCellEditor.getEditorStyle() != 0) {
                        boolean bl2 = this.getEditorStyle();
                        if (stringArray == null) {
                            bl2 = bl2;
                        }
                        jFormattedTextField.setEditable(bl2);
                    }
                }
                spinnerCellEditor = this;
            }
            jSpinner = spinnerCellEditor._spinner;
        }
        return jSpinner;
    }

    public JSpinner getSpinner() {
        return this._spinner;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        block3: {
            JSpinner jSpinner;
            block4: {
                SpinnerCellEditor spinnerCellEditor;
                String[] stringArray;
                block2: {
                    stringArray = JideTable.w();
                    spinnerCellEditor = this;
                    if (stringArray != null) break block2;
                    if (!spinnerCellEditor.isAutoStopCellEditing()) break block3;
                    spinnerCellEditor = this;
                }
                jSpinner = spinnerCellEditor.getSpinner();
                if (stringArray != null) break block4;
                if (jSpinner == null) break block3;
                jSpinner = this.getSpinner();
            }
            jSpinner.removeChangeListener(this);
            this.stopCellEditing();
        }
    }

    @Override
    public boolean isEditorStyleSupported(int n2) {
        return true;
    }
}

