/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.geo;

import com.macrofocus.geo.controller.GeoController;
import com.macrofocus.geo.model.GeoModel;
import com.macrofocus.geo.view.GeoView;
import com.macrofocus.util.java2d.RenderingHintsModel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.OverlayLayout;

public class MGeo
extends JComponent {
    private GeoView view;
    private GeoModel interactiveModel;
    private List<GeoModel> models;
    private GeoController controller;

    public MGeo() {
        this(null);
    }

    public MGeo(RenderingHintsModel renderingHintsModel) {
        this.setLayout(new OverlayLayout(this));
        this.models = new ArrayList<GeoModel>();
        this.view = new GeoView(renderingHintsModel);
        this.view.setRenderingHintsModel(renderingHintsModel);
        this.controller = new GeoController(this.view);
        this.add((Component)((Object)this.view));
        this.validate();
    }

    public void setInteractiveModel(GeoModel interactiveModel) {
        if (this.interactiveModel != interactiveModel) {
            this.interactiveModel = interactiveModel;
            if (this.view != null) {
                this.view.setInteractiveModel(interactiveModel);
            }
        }
    }

    public void setModel(GeoModel model) {
        this.view.setModel(model);
    }

    public void addModel(GeoModel model) {
        this.view.addModel(model);
    }

    public void removeModels() {
        this.view.removeModels();
    }

    public GeoView getView() {
        return this.view;
    }

    public void setView(GeoView view) {
        if (this.view != null) {
            this.view.setInteractiveModel(null);
            this.view.removeModels();
            this.removeAll();
        }
        this.view = view;
        if (this.controller != null) {
            this.controller.setView(view);
        }
        if (view != null) {
            this.add((Component)((Object)view));
        }
        this.validate();
    }

    public GeoModel getInteractiveModel() {
        return this.view.getInteractiveModel();
    }

    public GeoController getController() {
        return this.controller;
    }
}

