/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.geo.controller;

import com.macrofocus.data.table.Row;
import com.macrofocus.geo.view.GeoView;
import com.macrofocus.util.range.MBoundedRangeModel;
import com.macrofocus.util.swing.mouse.MMouseAdapter;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

public class GeoController {
    private GeoView view;
    private Mode mode = Mode.Selection;
    private final MMouseAdapter mouseListener = new MMouseAdapter(){

        public void mousePressed(MouseEvent e) {
            if (GeoController.this.view.getInteractiveModel() != null) {
                Row row = GeoController.this.view.getRow(e.getPoint());
                GeoController.this.view.getInteractiveModel().getSelection().setSelected((Object)row);
            }
        }

        public void mouseEntered(MouseEvent e) {
            if (GeoController.this.view.getInteractiveModel() != null) {
                Row row = GeoController.this.view.getRow(e.getPoint());
                GeoController.this.view.getInteractiveModel().getProbing().setSelected((Object)row);
            }
        }

        public void mouseMoved(MouseEvent e) {
            if (GeoController.this.view.getInteractiveModel() != null) {
                Row row = GeoController.this.view.getRow(e.getPoint());
                GeoController.this.view.getInteractiveModel().getProbing().setSelected((Object)row);
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (GeoController.this.view.getInteractiveModel() != null) {
                Row row = GeoController.this.view.getRow(e.getPoint());
                GeoController.this.view.getInteractiveModel().getProbing().setSelected((Object)row);
                GeoController.this.view.getInteractiveModel().getSelection().setSelected((Object)row);
            }
        }

        public void mouseExited(MouseEvent e) {
            if (GeoController.this.view.getInteractiveModel() != null) {
                GeoController.this.view.getInteractiveModel().getProbing().clearSelection();
            }
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
            int amount = e.getWheelRotation();
            Point p = e.getPoint();
            GeoController.this.zoom((double)amount / 20.0, GeoController.this.view.getXCoordinateAxis().screenToWorld(p.x), GeoController.this.view.getYCoordinateAxis().screenToWorld(p.y));
        }
    };

    public GeoController(GeoView view) {
        this.setView(view);
    }

    public void setView(GeoView view) {
        if (this.view != view) {
            if (this.view != null) {
                this.view.removeMouseListener((MouseListener)this.mouseListener);
                this.view.removeMouseMotionListener((MouseMotionListener)this.mouseListener);
                this.view.removeMouseWheelListener((MouseWheelListener)this.mouseListener);
            }
            this.view = view;
            if (this.view != null) {
                view.setFocusable(true);
                view.addMouseListener((MouseListener)this.mouseListener);
                view.addMouseMotionListener((MouseMotionListener)this.mouseListener);
                view.addMouseWheelListener((MouseWheelListener)this.mouseListener);
            }
        }
    }

    private void zoom(double amount, Double xCenter, Double yCenter) {
        MBoundedRangeModel xRangeModel = this.view.getXRangeModel();
        MBoundedRangeModel yRangeModel = this.view.getYRangeModel();
        Range xRange = new Range(amount, xCenter, xRangeModel).invoke();
        double xMin = xRange.getMin();
        double xMax = xRange.getMax();
        Range yRange = new Range(amount, yCenter, yRangeModel).invoke();
        double yMin = yRange.getMin();
        double yMax = yRange.getMax();
        if (xMin < xMax && yMin < yMax) {
            this.view.zoom(false, xMin, xMax, yMin, yMax);
        }
    }

    private class Range {
        private final double amount;
        private final Double center;
        private final MBoundedRangeModel rangeModel;
        private double min;
        private double max;

        public Range(double amount, Double center, MBoundedRangeModel rangeModel) {
            this.amount = amount;
            this.center = center;
            this.rangeModel = rangeModel;
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }

        public Range invoke() {
            double yRange = this.rangeModel.getExtent();
            double newYRange = yRange + yRange * this.amount;
            if (this.center != null) {
                this.min = this.center - newYRange * ((this.center - this.rangeModel.getValue()) / yRange);
                this.max = this.center + newYRange * ((this.rangeModel.getValue() + this.rangeModel.getExtent() - this.center) / yRange);
            } else {
                this.min = this.rangeModel.getValue();
                this.max = this.rangeModel.getValue() + newYRange;
            }
            if (this.min < this.rangeModel.getMinimum()) {
                this.max += this.rangeModel.getMinimum() - this.min;
                this.min = this.rangeModel.getMinimum();
            }
            if (this.max > this.rangeModel.getMaximum()) {
                this.min -= this.max - this.rangeModel.getMaximum();
                this.max = this.rangeModel.getMaximum();
            }
            this.min = Math.max(this.rangeModel.getMinimum(), this.min);
            this.max = Math.min(this.rangeModel.getMaximum(), this.max);
            return this;
        }
    }

    public static enum Mode {
        Selection,
        Zooming,
        Panning;

    }
}

