/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.geo.map;

import com.macrofocus.geo.map.LayerModel;
import com.macrofocus.geo.map.LayerView;
import com.macrofocus.geo.map.Polygon;
import com.macrofocus.geo.map.RelationModel;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;

public class CategoricalPolygonRenderer
implements LayerView.PolygonRenderer {
    private final RelationModel relation;

    public CategoricalPolygonRenderer(RelationModel relation) {
        this.relation = relation;
    }

    @Override
    public Color getColor(Polygon polygon, int row, LayerModel layerModel) {
        int id = this.relation.getPrimaryRow(row);
        if (id >= 0) {
            float b;
            float g;
            float r;
            int maxid = this.relation.getPrimaryRowCount();
            if (id % 3 == 0) {
                r = (float)id / (float)maxid;
                g = 1.0f - (float)id / (float)maxid;
                b = Math.abs(1.0f - 2.0f * (float)id / (float)maxid);
            } else if (id % 3 == 1) {
                b = (float)id / (float)maxid;
                r = 1.0f - (float)id / (float)maxid;
                g = Math.abs(1.0f - 2.0f * (float)id / (float)maxid);
            } else {
                g = (float)id / (float)maxid;
                b = 1.0f - (float)id / (float)maxid;
                r = Math.abs(1.0f - 2.0f * (float)id / (float)maxid);
            }
            return new Color(r, g, b);
        }
        return null;
    }

    @Override
    public void paint(Graphics2D g2, Polygon polygon, int row, LayerModel layerModel) {
        Shape shape = polygon.getShape();
        int id = this.relation.getPrimaryRow(row);
        if (id >= 0) {
            g2.setColor(this.getColor(polygon, row, layerModel));
            g2.fill(shape);
        }
        g2.setColor(Color.black);
        g2.draw(shape);
    }
}

