/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.geo.map;

import com.macrofocus.data.DataHelper;
import com.macrofocus.data.DataModel;
import com.macrofocus.data.row.RowModel;
import com.macrofocus.data.row.SimpleRowModel;
import com.macrofocus.geo.map.LayerModel;
import com.macrofocus.geo.map.LayerView;
import com.macrofocus.geo.map.Point;
import com.macrofocus.geo.map.Polygon;
import com.macrofocus.geo.map.SimpleLayerController;
import com.macrofocus.geo.map.SimpleLayerModel;
import com.macrofocus.geo.map.SimpleLayerView;
import com.macrofocus.geo.map.SimplePoint;
import com.macrofocus.geo.map.SimplePolygon;
import com.macrofocus.util.file.FileHelper;
import com.macrofocus.util.java2d.RenderingHintsModel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentFeatureSource;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeType;

public class LayerFactory {
    public static final LayerView createLayerView(LayerModel layerModel, RenderingHintsModel renderingHintsModel) {
        SimpleLayerView layerView = new SimpleLayerView(layerModel, renderingHintsModel);
        new SimpleLayerController(layerModel, layerView);
        return layerView;
    }

    public static final LayerModel loadShpMap(File file) {
        SimpleLayerModel<SimplePolygon> map = new SimpleLayerModel<SimplePolygon>(FileHelper.removeSuffix((File)file));
        try {
            ShapefileDataStore store = new ShapefileDataStore(file.toURL());
            ContentFeatureSource source = store.getFeatureSource(store.getTypeNames()[0]);
            SimpleFeatureCollection collection = source.getFeatures();
            SimpleFeatureType schema = (SimpleFeatureType)collection.getSchema();
            Class[] cl = new Class[]{String.class, Long.class, Integer.class, Float.class, Double.class};
            HashSet<Class> compatibleClasses = new HashSet<Class>(Arrays.asList(cl));
            int columnCount = 0;
            for (int i = 0; i < schema.getAttributeCount(); ++i) {
                AttributeType type = schema.getType(i);
                if (!compatibleClasses.contains(type.getBinding())) continue;
                ++columnCount;
            }
            Class[] memberships = new Class[columnCount];
            Object[] names = new String[columnCount];
            columnCount = 0;
            for (int i = 0; i < schema.getAttributeCount(); ++i) {
                AttributeType type = schema.getType(i);
                if (compatibleClasses.contains(type.getBinding())) {
                    memberships[columnCount] = type.getBinding().equals(Long.class) ? Integer.class : type.getBinding();
                    names[columnCount] = type.getName().toString();
                    ++columnCount;
                    continue;
                }
                if (!type.getBinding().equals(Long.class)) continue;
                names[columnCount] = type.getName().toString();
                ++columnCount;
            }
            SimpleFeatureIterator iterator = collection.features();
            while (iterator.hasNext()) {
                try {
                    Coordinate coordinate;
                    int j;
                    Coordinate[] coordinates;
                    org.locationtech.jts.geom.Polygon polygon;
                    ArrayList<Point> points;
                    Geometry geometry;
                    SimpleFeature feature = (SimpleFeature)iterator.next();
                    Object[] objects = new Object[columnCount];
                    for (int i = 0; i < columnCount; ++i) {
                        String name = names[i];
                        objects[i] = feature.getAttribute(name);
                        if (!(objects[i] instanceof Long)) continue;
                        Long l = (Long)objects[i];
                        objects[i] = l.intValue();
                    }
                    if (feature.getDefaultGeometry() instanceof MultiPolygon) {
                        MultiPolygon multiPolygon = (MultiPolygon)feature.getDefaultGeometry();
                        for (int i = 0; i < multiPolygon.getNumGeometries(); ++i) {
                            geometry = multiPolygon.getGeometryN(i);
                            if (geometry instanceof org.locationtech.jts.geom.Polygon) {
                                points = new ArrayList<Point>();
                                polygon = (org.locationtech.jts.geom.Polygon)geometry;
                                coordinates = polygon.getExteriorRing().getCoordinates();
                                for (j = 0; j < coordinates.length; ++j) {
                                    coordinate = coordinates[j];
                                    points.add(new SimplePoint(coordinate.getX() * 100000.0, coordinate.getY() * 100000.0));
                                }
                                map.addGeometry(new SimplePolygon(points), (RowModel)new SimpleRowModel(objects, memberships, names));
                                continue;
                            }
                            System.err.println("Unsupported geometry " + geometry);
                        }
                        continue;
                    }
                    if (feature.getDefaultGeometry() instanceof MultiLineString) {
                        MultiLineString multiPolygon = (MultiLineString)feature.getDefaultGeometry();
                        for (int i = 0; i < multiPolygon.getNumGeometries(); ++i) {
                            geometry = multiPolygon.getGeometryN(i);
                            if (geometry instanceof LineString) {
                                points = new ArrayList();
                                polygon = (LineString)geometry;
                                coordinates = polygon.getCoordinates();
                                for (j = 0; j < coordinates.length; ++j) {
                                    coordinate = coordinates[j];
                                    points.add(new SimplePoint(coordinate.getX() * 100000.0, coordinate.getY() * 100000.0));
                                }
                                map.addGeometry(new SimplePolygon(points), (RowModel)new SimpleRowModel(objects, memberships, names));
                                continue;
                            }
                            System.err.println("Unsupported geometry " + geometry);
                        }
                        continue;
                    }
                    System.err.println("Unsupported geometry " + feature.getDefaultGeometry().getClass());
                }
                catch (IllegalAttributeException e) {
                    e.printStackTrace();
                }
            }
            iterator.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        map.pack();
        return map;
    }

    public static final LayerModel loadGenMap(File file) {
        SimpleLayerModel<SimplePolygon> map = new SimpleLayerModel<SimplePolygon>(FileHelper.removeSuffix((File)file));
        try {
            BufferedReader infile = new BufferedReader(new FileReader(file));
            String line = infile.readLine();
            StringTokenizer tokenizer = new StringTokenizer(line, " ");
            String id = tokenizer.nextToken().trim();
            ArrayList<Point> points = new ArrayList<Point>();
            Class[] memberships = new Class[]{String.class};
            Object[] names = new Object[]{"Id"};
            while ((line = infile.readLine()) != null) {
                if (!line.startsWith("E")) {
                    tokenizer = new StringTokenizer(line, " ");
                    double xcoord = Double.parseDouble(tokenizer.nextToken());
                    double ycoord = Double.parseDouble(tokenizer.nextToken());
                    points.add(new SimplePoint(xcoord, ycoord));
                    continue;
                }
                line = infile.readLine();
                Object[] objects = new String[]{id};
                map.addGeometry(new SimplePolygon(points), (RowModel)new SimpleRowModel(objects, memberships, names));
                if (line.startsWith("E")) break;
                tokenizer = new StringTokenizer(line, " ");
                id = tokenizer.nextToken().trim();
                points = new ArrayList();
            }
            infile.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return map;
    }

    public static LayerModel loadTxtMap(File file) {
        SimpleLayerModel<Polygon> map = new SimpleLayerModel<Polygon>(FileHelper.removeSuffix((File)file));
        DataModel dataModel = DataHelper.loadTxt((File)file);
        int coordinatesColumn = dataModel.getColumnIndex((Object)"Coordinates");
        Class[] memberships = new Class[dataModel.getColumnCount() - 1];
        Object[] names = new Object[dataModel.getColumnCount() - 1];
        int c = 0;
        for (int column = 0; column < dataModel.getColumnCount(); ++column) {
            if (column == coordinatesColumn) continue;
            memberships[c] = dataModel.getColumnClass(column);
            names[c] = dataModel.getColumnName(column);
            ++c;
        }
        int subNameColumn = dataModel.getColumnIndex((Object)"Sub-name");
        int typeColumn = dataModel.getColumnIndex((Object)"Type");
        int colorColumn = dataModel.getColumnIndex((Object)"Color");
        for (int row = 0; row < dataModel.getRowCount(); ++row) {
            String type = (String)dataModel.getValueAt(row, typeColumn);
            String coordinates = (String)dataModel.getValueAt(row, coordinatesColumn);
            Object[] objects = new Object[dataModel.getColumnCount() - 1];
            int c2 = 0;
            for (int column = 0; column < dataModel.getColumnCount(); ++column) {
                if (column == coordinatesColumn) continue;
                objects[c2] = dataModel.getValueAt(row, column);
                ++c2;
            }
            if (type.equals("region")) {
                map.addGeometry(LayerFactory.parseCoordinates(coordinates), (RowModel)new SimpleRowModel(objects, memberships, names));
                continue;
            }
            if (type.equals("border")) {
                map.addGeometry(LayerFactory.parseCoordinates(coordinates), (RowModel)new SimpleRowModel(objects, memberships, names));
                continue;
            }
            if (!type.equals("hole")) continue;
            map.addGeometry(LayerFactory.parseCoordinates(coordinates), (RowModel)new SimpleRowModel(objects, memberships, names));
        }
        return map;
    }

    private static Polygon parseCoordinates(String coordinates) {
        StringTokenizer st = new StringTokenizer(coordinates, ";");
        ArrayList<Point> points = new ArrayList<Point>();
        while (st.hasMoreTokens()) {
            try {
                String point = st.nextToken();
                StringTokenizer st2 = new StringTokenizer(point, ",");
                int x = Integer.parseInt(st2.nextToken());
                int y = Integer.parseInt(st2.nextToken());
                points.add(new SimplePoint(x, y));
            }
            catch (NoSuchElementException e) {
                throw new NoSuchElementException(coordinates);
            }
        }
        return new SimplePolygon(points);
    }
}

