/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.geo.map;

import com.macrofocus.common.logging.Logging;
import com.macrofocus.geo.map.Geometry;
import com.macrofocus.geo.map.LayerModel;
import com.macrofocus.geo.map.MapModel;
import com.macrofocus.geo.map.MapView;
import com.macrofocus.geo.map.Point;
import com.macrofocus.geo.map.Polygon;
import com.macrofocus.helper.Disposable;
import com.macrofocus.soom.lens.coordinate.CoordinateAxisEvent;
import com.macrofocus.soom.lens.coordinate.CoordinateAxisListener;
import com.macrofocus.soom.lens.coordinate.CoordinateAxisModel;
import com.macrofocus.soom.lens.coordinate.OptimizedCoordinateAxisModel;
import com.macrofocus.soom.lens.zoom.CartesianFisheyeZoom;
import com.macrofocus.soom.lens.zoom.ZoomStrategy;
import com.macrofocus.soom.lens.zoom.selection.ZoomConfiguration;
import com.macrofocus.soom.lens.zoom.selection.ZoomSelectionEvent;
import com.macrofocus.soom.lens.zoom.selection.ZoomSelectionListener;
import com.macrofocus.soom.lens.zoom.selection.ZoomSelectionModel;
import com.macrofocus.util.interpolation.Interpolator;
import com.macrofocus.util.java2d.RenderingHintsModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.util.HashMap;
import java.util.Map;

public class SimpleMapView
extends MapView
implements Disposable {
    private MapModel map;
    private final boolean maintainAspectRatio = true;
    private MapView.PolygonRenderer polygonRenderer = new DefaultPolygonRenderer();
    private RenderingHintsModel renderingHintsModel;
    private CoordinateAxisModel xCoordinateAxis;
    private CoordinateAxisModel yCoordinateAxis;
    private CartesianFisheyeZoom xZoom;
    private CartesianFisheyeZoom yZoom;
    private Map<LayerModel, MapView.PolygonRenderer> renderers;
    private Map<Geometry, Shape> shapeCache;
    private InterpolatorThread interpolatorThread = null;
    private Object mutex = new Object();
    private ComponentAdapter componentListener = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent e) {
            Dimension size = SimpleMapView.this.getSize();
            SimpleMapView.this.xCoordinateAxis.setScreenSize(size.width);
            SimpleMapView.this.yCoordinateAxis.setScreenSize(size.height);
        }
    };

    public SimpleMapView(MapModel map, final ZoomSelectionModel zoomSelectionModel, RenderingHintsModel renderingHintsModel) {
        this.map = map;
        this.renderingHintsModel = renderingHintsModel;
        this.shapeCache = new HashMap<Geometry, Shape>();
        double x1 = map.getBounds().getMinX();
        double x2 = map.getBounds().getMaxX();
        double y1 = map.getBounds().getMinY();
        double y2 = map.getBounds().getMaxY();
        this.xCoordinateAxis = new OptimizedCoordinateAxisModel(x1, x2);
        this.yCoordinateAxis = new OptimizedCoordinateAxisModel(y1, y2);
        this.yCoordinateAxis.setWorldCoordinatesInverted(true);
        this.xZoom = new CartesianFisheyeZoom();
        this.xCoordinateAxis.setZoomStrategy((ZoomStrategy)this.xZoom);
        this.yZoom = new CartesianFisheyeZoom();
        this.yCoordinateAxis.setZoomStrategy((ZoomStrategy)this.yZoom);
        this.xCoordinateAxis.addCoordinateListener(new CoordinateAxisListener(){

            public void rangeChanged(CoordinateAxisEvent e) {
                SimpleMapView.this.shapeCache.clear();
                SimpleMapView.this.repaint();
            }
        });
        this.yCoordinateAxis.addCoordinateListener(new CoordinateAxisListener(){

            public void rangeChanged(CoordinateAxisEvent e) {
                SimpleMapView.this.shapeCache.clear();
                SimpleMapView.this.repaint();
            }
        });
        this.addComponentListener(this.componentListener);
        zoomSelectionModel.addZoomSelectionListener(new ZoomSelectionListener(){

            public void configurationSelected(ZoomSelectionEvent event) {
                ZoomConfiguration configuration = zoomSelectionModel.getSelectedConfiguration();
                SimpleMapView.this.zoom(configuration);
            }

            public void configurationChanged(ZoomSelectionEvent event) {
            }
        });
        this.renderers = new HashMap<LayerModel, MapView.PolygonRenderer>();
    }

    @Override
    public void setPolygonRenderer(LayerModel layerModel, MapView.PolygonRenderer polygonRenderer) {
        this.renderers.put(layerModel, polygonRenderer);
        this.repaint();
    }

    @Override
    public void setPolygonRenderer(MapView.PolygonRenderer polygonRenderer) {
        this.polygonRenderer = polygonRenderer;
        this.repaint();
    }

    @Override
    public MapView.PolygonRenderer getPolygonRenderer() {
        return this.polygonRenderer;
    }

    @Override
    public MapModel getModel() {
        return this.map;
    }

    @Override
    public RenderingHintsModel getRenderingHintsModel() {
        return this.renderingHintsModel;
    }

    @Override
    public CoordinateAxisModel getXCoordinateAxis() {
        return this.xCoordinateAxis;
    }

    @Override
    public CoordinateAxisModel getYCoordinateAxis() {
        return this.yCoordinateAxis;
    }

    @Override
    public Map<LayerModel, MapView.PolygonRenderer> getRenderers() {
        return this.renderers;
    }

    @Override
    public Object getMutex() {
        return this.mutex;
    }

    @Override
    public void setZoomFocus(int x, int y) {
        this.xZoom.setLensNormalized(this.xCoordinateAxis.worldToNormalized(this.xCoordinateAxis.screenToWorld(x)), 0.05);
        this.xZoom.setZoomFactor(3.0);
        this.yZoom.setLensNormalized(this.yCoordinateAxis.worldToNormalized(this.yCoordinateAxis.screenToWorld(y)), 0.05);
        this.yZoom.setZoomFactor(3.0);
        this.shapeCache.clear();
        this.repaint();
    }

    public void zoom(final ZoomConfiguration newZoomConfiguration) {
        if (this.interpolatorThread != null && this.interpolatorThread.isAlive()) {
            this.interpolatorThread.cancel();
            try {
                this.interpolatorThread.join();
            }
            catch (Exception e) {
                Logging.getInstance().process((Throwable)e);
            }
        }
        this.interpolatorThread = new InterpolatorThread(){
            private boolean stopped = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                double startFocusWidth = SimpleMapView.this.xZoom.getFocusSizeNormalized();
                double startFocusHeight = SimpleMapView.this.yZoom.getFocusSizeNormalized();
                double startFocusX = SimpleMapView.this.xZoom.getFocusPositionNormalized();
                double startFocusY = SimpleMapView.this.yZoom.getFocusPositionNormalized();
                double startZoomFactorX = SimpleMapView.this.xZoom.getZoomFactor();
                double startZoomFactorY = SimpleMapView.this.yZoom.getZoomFactor();
                Interpolator interpolator = new Interpolator(0.0, 1.0, 2000L);
                do {
                    double factor = interpolator.getSmoothValue();
                    double focusWidth = startFocusWidth + factor * (newZoomConfiguration.getFocusWidth() - startFocusWidth);
                    double focusHeight = startFocusHeight + factor * (newZoomConfiguration.getFocusHeight() - startFocusHeight);
                    double focusX = startFocusX + factor * (newZoomConfiguration.getFocusX() - startFocusX);
                    double focusY = startFocusY + factor * (newZoomConfiguration.getFocusY() - startFocusY);
                    double zoomFactorX = startZoomFactorX + factor * (newZoomConfiguration.getZoomFactor() - startZoomFactorX);
                    double zoomFactorY = startZoomFactorY + factor * (newZoomConfiguration.getZoomFactor() - startZoomFactorY);
                    Object object = SimpleMapView.this.mutex;
                    synchronized (object) {
                        SimpleMapView.this.xZoom.setLensNormalized(focusX, focusWidth);
                        SimpleMapView.this.yZoom.setLensNormalized(focusY, focusHeight);
                        SimpleMapView.this.xZoom.setZoomFactor(zoomFactorX);
                        SimpleMapView.this.yZoom.setZoomFactor(zoomFactorY);
                        SimpleMapView.this.shapeCache.clear();
                        SimpleMapView.this.repaint();
                    }
                } while (!interpolator.finished() && !this.stopped);
            }

            @Override
            public void cancel() {
                this.stopped = true;
            }
        };
        this.interpolatorThread.setPriority(1);
        this.interpolatorThread.start();
    }

    @Override
    public Shape getShape(Geometry geometry) {
        if (this.shapeCache.containsKey(geometry)) {
            return this.shapeCache.get(geometry);
        }
        if (geometry instanceof Polygon) {
            Polygon polygon = (Polygon)geometry;
            GeneralPath shape = new GeneralPath();
            Point p0 = polygon.getPoint(0);
            shape.moveTo(this.xCoordinateAxis.worldToScreen(p0.getX()), this.yCoordinateAxis.worldToScreen(p0.getY()));
            for (int pi = 1; pi < polygon.getPointCount(); ++pi) {
                Point p = polygon.getPoint(pi);
                shape.lineTo(this.xCoordinateAxis.worldToScreen(p.getX()), this.yCoordinateAxis.worldToScreen(p.getY()));
            }
            shape.closePath();
            this.shapeCache.put(geometry, shape);
            return shape;
        }
        if (geometry instanceof Point) {
            Point p = (Point)geometry;
            Ellipse2D.Double shape = new Ellipse2D.Double(this.xCoordinateAxis.worldToScreen(p.getX()), this.yCoordinateAxis.worldToScreen(p.getY()), 1.0, 1.0);
            this.shapeCache.put(geometry, shape);
            return shape;
        }
        return null;
    }

    public void dispose() {
        this.removeComponentListener(this.componentListener);
        this.map = null;
        this.polygonRenderer = null;
        this.renderingHintsModel = null;
        this.xCoordinateAxis = null;
        this.yCoordinateAxis = null;
        this.xZoom = null;
        this.yZoom = null;
        this.renderers = null;
        this.shapeCache = null;
        if (this.interpolatorThread != null) {
            this.interpolatorThread.stop();
        }
        this.interpolatorThread = null;
        this.mutex = null;
    }

    public class DefaultPolygonRenderer
    implements MapView.PolygonRenderer {
        public Color getColor(Geometry polygon, int row, LayerModel layerModel) {
            return Color.black;
        }

        @Override
        public void paint(Graphics2D g, CoordinateAxisModel xCoordinateAxis, CoordinateAxisModel yCoordinateAxis, LayerModel<Geometry> layer) {
            int row = 0;
            for (Geometry geometry : layer.getGeometries()) {
                g.setColor(this.getColor(geometry, row, layer));
                g.draw(SimpleMapView.this.getShape(geometry));
                ++row;
            }
        }
    }

    public abstract class InterpolatorThread
    extends Thread {
        public abstract void cancel();
    }
}

