/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.geo.map;

import com.macrofocus.geo.map.MapView;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;

public class ZoomingMapController {
    public ZoomingMapController(final MapView view) {
        view.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                ZoomingMapController.this.zoom(event, view);
            }
        });
        view.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent event) {
                ZoomingMapController.this.zoom(event, view);
            }
        });
    }

    private void zoom(MouseEvent event, MapView view) {
        if ((event.getModifiers() & 0x10) == 16 && event.isShiftDown()) {
            int y;
            Dimension d = view.getSize();
            int x = event.getX();
            if (x < 0) {
                x = 0;
            }
            if (x >= d.width) {
                x = d.width - 1;
            }
            if ((y = event.getY()) < 0) {
                y = 0;
            }
            if (y >= d.height) {
                y = d.height - 1;
            }
            view.setZoomFocus(x, y);
        }
    }
}

