/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.beans;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EventListener;
import org.jdesktop.beans.AbstractBean;

public abstract class AbstractSerializableBean
extends AbstractBean
implements Serializable {
    protected AbstractSerializableBean() {
    }

    protected AbstractSerializableBean(PropertyChangeSupport pcs, VetoableChangeSupport vcs) {
        super(pcs, vcs);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        EventListener l;
        s.defaultWriteObject();
        EventListener[] eventListenerArray = this.getPropertyChangeListeners();
        int n = eventListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            l = eventListenerArray[n2];
            if (l instanceof Serializable) {
                s.writeObject(l);
            }
            ++n2;
        }
        eventListenerArray = this.getVetoableChangeListeners();
        n = eventListenerArray.length;
        n2 = 0;
        while (n2 < n) {
            l = eventListenerArray[n2];
            if (l instanceof Serializable) {
                s.writeObject(l);
            }
            ++n2;
        }
        s.writeObject(null);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        Object listenerOrNull;
        s.defaultReadObject();
        while ((listenerOrNull = s.readObject()) != null) {
            if (listenerOrNull instanceof PropertyChangeListener) {
                this.addPropertyChangeListener((PropertyChangeListener)listenerOrNull);
                continue;
            }
            if (!(listenerOrNull instanceof VetoableChangeListener)) continue;
            this.addVetoableChangeListener((VetoableChangeListener)listenerOrNull);
        }
    }
}

