/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.autocomplete;

import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.text.JTextComponent;
import org.jdesktop.swingx.autocomplete.AutoCompleteDocument;

public class ComboBoxCellEditor
extends DefaultCellEditor {
    public ComboBoxCellEditor(final JComboBox comboBox) {
        super(comboBox);
        comboBox.removeActionListener(this.delegate);
        this.delegate = new DefaultCellEditor.EditorDelegate(this){

            @Override
            public void setValue(Object value) {
                comboBox.setSelectedItem(value);
            }

            @Override
            public Object getCellEditorValue() {
                return comboBox.getSelectedItem();
            }

            @Override
            public boolean shouldSelectCell(EventObject anEvent) {
                if (anEvent instanceof MouseEvent) {
                    MouseEvent e = (MouseEvent)anEvent;
                    return e.getID() != 506;
                }
                return true;
            }

            @Override
            public boolean stopCellEditing() {
                if (comboBox.isEditable()) {
                    comboBox.actionPerformed(new ActionEvent(ComboBoxCellEditor.this, 0, ""));
                }
                return super.stopCellEditing();
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                JTextComponent editorComponent = (JTextComponent)comboBox.getEditor().getEditorComponent();
                if (editorComponent.getDocument() instanceof AutoCompleteDocument) {
                    AutoCompleteDocument document = (AutoCompleteDocument)editorComponent.getDocument();
                    if (!document.selecting) {
                        ComboBoxCellEditor.this.stopCellEditing();
                    }
                } else {
                    ComboBoxCellEditor.this.stopCellEditing();
                }
            }
        };
        comboBox.addActionListener(this.delegate);
    }
}

