/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.hyperlink;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.jdesktop.swingx.hyperlink.AbstractHyperlinkAction;
import org.jdesktop.swingx.hyperlink.LinkModel;

public class LinkModelAction<T extends LinkModel>
extends AbstractHyperlinkAction<T> {
    private ActionListener delegate;
    public static final String VISIT_ACTION = "visit";
    private PropertyChangeListener linkListener;

    public LinkModelAction() {
        this(null);
    }

    public LinkModelAction(ActionListener visitingDelegate) {
        this(null, visitingDelegate);
    }

    public LinkModelAction(T target) {
        this(target, null);
    }

    public LinkModelAction(T target, ActionListener visitingDelegate) {
        super(target);
        this.setVisitingDelegate(visitingDelegate);
    }

    public void setVisitingDelegate(ActionListener delegate) {
        this.delegate = delegate;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.delegate != null && this.getTarget() != null) {
            this.delegate.actionPerformed(new ActionEvent(this.getTarget(), 1001, VISIT_ACTION));
        }
    }

    @Override
    protected void installTarget() {
        if (this.getTarget() != null) {
            ((LinkModel)this.getTarget()).addPropertyChangeListener(this.getTargetListener());
        }
        this.updateFromTarget();
    }

    @Override
    protected void uninstallTarget() {
        if (this.getTarget() == null) {
            return;
        }
        ((LinkModel)this.getTarget()).removePropertyChangeListener(this.getTargetListener());
    }

    protected void updateFromTarget() {
        if (this.getTarget() != null) {
            this.putValue("Name", ((LinkModel)this.getTarget()).getText());
            this.putValue("ShortDescription", ((LinkModel)this.getTarget()).getURL().toString());
            this.putValue("visited", new Boolean(((LinkModel)this.getTarget()).getVisited()));
        } else {
            Object[] keys = this.getKeys();
            if (keys == null) {
                return;
            }
            int i = 0;
            while (i < keys.length) {
                this.putValue(keys[i].toString(), null);
                ++i;
            }
        }
    }

    private PropertyChangeListener getTargetListener() {
        if (this.linkListener == null) {
            this.linkListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    LinkModelAction.this.updateFromTarget();
                }
            };
        }
        return this.linkListener;
    }
}

