/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.image;

import java.awt.image.BufferedImage;
import org.jdesktop.swingx.image.AbstractFilter;
import org.jdesktop.swingx.util.GraphicsUtilities;

public class GaussianBlurFilter
extends AbstractFilter {
    private final int radius;

    public GaussianBlurFilter() {
        this(3);
    }

    public GaussianBlurFilter(int radius) {
        if (radius < 1) {
            radius = 1;
        }
        this.radius = radius;
    }

    public int getRadius() {
        return this.radius;
    }

    @Override
    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        int width = src.getWidth();
        int height = src.getHeight();
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, null);
        }
        int[] srcPixels = new int[width * height];
        int[] dstPixels = new int[width * height];
        float[] kernel = GaussianBlurFilter.createGaussianKernel(this.radius);
        GraphicsUtilities.getPixels(src, 0, 0, width, height, srcPixels);
        GaussianBlurFilter.blur(srcPixels, dstPixels, width, height, kernel, this.radius);
        GaussianBlurFilter.blur(dstPixels, srcPixels, height, width, kernel, this.radius);
        GraphicsUtilities.setPixels(dst, 0, 0, width, height, srcPixels);
        return dst;
    }

    static void blur(int[] srcPixels, int[] dstPixels, int width, int height, float[] kernel, int radius) {
        int y = 0;
        while (y < height) {
            int index = y;
            int offset = y * width;
            int x = 0;
            while (x < width) {
                float b = 0.0f;
                float g = 0.0f;
                float r = 0.0f;
                float a = 0.0f;
                int i = -radius;
                while (i <= radius) {
                    int subOffset = x + i;
                    if (subOffset < 0 || subOffset >= width) {
                        subOffset = (x + width) % width;
                    }
                    int pixel = srcPixels[offset + subOffset];
                    float blurFactor = kernel[radius + i];
                    a += blurFactor * (float)(pixel >> 24 & 0xFF);
                    r += blurFactor * (float)(pixel >> 16 & 0xFF);
                    g += blurFactor * (float)(pixel >> 8 & 0xFF);
                    b += blurFactor * (float)(pixel & 0xFF);
                    ++i;
                }
                int ca = (int)(a + 0.5f);
                int cr = (int)(r + 0.5f);
                int cg = (int)(g + 0.5f);
                int cb = (int)(b + 0.5f);
                dstPixels[index] = (ca > 255 ? 255 : ca) << 24 | (cr > 255 ? 255 : cr) << 16 | (cg > 255 ? 255 : cg) << 8 | (cb > 255 ? 255 : cb);
                index += height;
                ++x;
            }
            ++y;
        }
    }

    static float[] createGaussianKernel(int radius) {
        if (radius < 1) {
            throw new IllegalArgumentException("Radius must be >= 1");
        }
        float[] data = new float[radius * 2 + 1];
        float sigma = (float)radius / 3.0f;
        float twoSigmaSquare = 2.0f * sigma * sigma;
        float sigmaRoot = (float)Math.sqrt((double)twoSigmaSquare * Math.PI);
        float total = 0.0f;
        int i = -radius;
        while (i <= radius) {
            float distance = i * i;
            int index = i + radius;
            data[index] = (float)Math.exp(-distance / twoSigmaSquare) / sigmaRoot;
            total += data[index];
            ++i;
        }
        i = 0;
        while (i < data.length) {
            int n = i++;
            data[n] = data[n] / total;
        }
        return data;
    }
}

