/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.slider.plaf.basic;

import com.macrofocus.slider.RangeSliderModel;
import com.macrofocus.slider.plaf.RangeSliderUI;
import com.macrofocus.slider.swing.JRangeSlider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class BasicRangeSliderUI
extends RangeSliderUI {
    private static final BasicRangeSliderUI rangeSliderUI = new BasicRangeSliderUI();
    private Color background;
    private Color shadow;
    private Color darkShadow;
    private Color highlight;
    protected Color backgroundColor = UIManager.getColor("ScrollBar.background");
    private static Color foregroundColor;
    private static Color shadowColor;
    private static Color highlightColor;
    private static Color darkShadowColor;
    protected Color thumbColor;
    protected Color backgroundControlColor;
    private static Color thumbShadow;
    private static Color thumbHighlightColor;
    private Color thumbLightShadowColor;
    private Color thumbDarkShadowColor;
    private Color trackColor;
    private Color trackHighlightColor;
    private boolean isFreeStanding = true;
    private boolean leftToRight = true;
    protected static final int NO_HIGHLIGHT = 0;
    protected static final int DECREASE_HIGHLIGHT = 1;
    protected static final int INCREASE_HIGHLIGHT = 2;
    protected int trackHighlight;

    public static ComponentUI createUI(JComponent c) {
        return rangeSliderUI;
    }

    public BasicRangeSliderUI() {
        foregroundColor = UIManager.getColor("ScrollBar.foreground");
        thumbHighlightColor = UIManager.getColor("ScrollBar.thumbHighlight");
        this.thumbLightShadowColor = UIManager.getColor("ScrollBar.thumbShadow");
        this.thumbDarkShadowColor = UIManager.getColor("ScrollBar.thumbDarkShadow");
        this.thumbColor = UIManager.getColor("ScrollBar.thumb");
        this.trackColor = UIManager.getColor("ScrollBar.track");
        this.trackHighlightColor = UIManager.getColor("ScrollBar.trackHighlight");
        this.trackHighlight = 1;
        Color control = UIManager.getColor("control");
        this.background = new Color(control.getRed(), control.getGreen(), control.getBlue(), 127);
        this.shadow = UIManager.getColor("controlShadow");
        this.darkShadow = UIManager.getColor("controlDkShadow");
        this.highlight = UIManager.getColor("controlLtHighlight");
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        JRangeSlider view = (JRangeSlider)c;
        view.updateRectangles();
        this.paintRange(view.getRangeSliderModel(), view, g, view.getOrientation(), view.getTrackBounds(), view.getThumbBounds());
        this.paintThumb(view, g, view.getOrientation(), view.getThumbBounds());
        this.paintHandles(g, view);
    }

    private void paintHandles(Graphics g, JRangeSlider view) {
        if (view.isPaintHandles()) {
            Rectangle maxRectangle = view.getMaxRectangle();
            Rectangle minRectangle = view.getMinRectangle();
            if (view.getOrientation() == 1) {
                g.translate(maxRectangle.x, maxRectangle.y);
                this.paintArrowButton(view, g, 5, new Rectangle(0, 0, maxRectangle.width, maxRectangle.height));
                g.translate(-maxRectangle.x, -maxRectangle.y);
                g.translate(minRectangle.x, minRectangle.y);
                this.paintArrowButton(view, g, 1, new Rectangle(0, 0, minRectangle.width, minRectangle.height));
                g.translate(-minRectangle.x, -minRectangle.y);
            } else {
                g.translate(maxRectangle.x, maxRectangle.y);
                this.paintArrowButton(view, g, 7, new Rectangle(0, 0, maxRectangle.width, maxRectangle.height));
                g.translate(-maxRectangle.x, -maxRectangle.y);
                g.translate(minRectangle.x, minRectangle.y);
                this.paintArrowButton(view, g, 3, new Rectangle(0, 0, minRectangle.width, minRectangle.height));
                g.translate(-minRectangle.x, -minRectangle.y);
            }
        }
    }

    @Override
    public void paintRange(RangeSliderModel rangeSliderModel, JRangeSlider view, Graphics g, int orientation, Rectangle trackBounds, Rectangle thumbBounds) {
        if (view.isPaintTrack()) {
            if (view.getHistogramRenderer() != null) {
                Component c = view.getHistogramRenderer().getRangeSliderHistogramRendererComponent(view, rangeSliderModel.getHistogram());
                if (c != null) {
                    c.setSize(trackBounds.width, trackBounds.height);
                    Graphics g2 = g.create(trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height);
                    c.paint(g2);
                    g2.dispose();
                }
            } else if (view.isOpaque()) {
                g.setColor(this.backgroundColor);
                g.fillRect(trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height);
            }
        }
    }

    @Override
    public void paintThumb(JRangeSlider sliderView, Graphics g, int orientation, Rectangle thumbBounds) {
        if (sliderView.isPaintThumb() && sliderView.getHistogramRenderer() == null) {
            if (thumbBounds.isEmpty() || !sliderView.isEnabled()) {
                return;
            }
            int w = thumbBounds.width;
            int h = thumbBounds.height;
            g.translate(thumbBounds.x, thumbBounds.y);
            g.setColor(this.thumbDarkShadowColor);
            g.drawRect(0, 0, w - 1, h - 1);
            g.setColor(this.thumbColor);
            g.fillRect(0, 0, w - 1, h - 1);
            g.setColor(thumbHighlightColor);
            g.drawLine(1, 1, 1, h - 2);
            g.drawLine(2, 1, w - 3, 1);
            g.setColor(this.thumbLightShadowColor);
            g.drawLine(2, h - 2, w - 2, h - 2);
            g.drawLine(w - 2, 1, w - 2, h - 3);
            g.translate(-thumbBounds.x, -thumbBounds.y);
        }
    }

    private static boolean isLeftToRight(Component c) {
        return c.getComponentOrientation().isLeftToRight();
    }

    @Override
    public void paintArrowButton(JComponent sliderView, Graphics g, int direction, Rectangle bounds) {
        int w = bounds.width;
        int h = bounds.height;
        Color origColor = g.getColor();
        boolean isPressed = false;
        boolean isEnabled = sliderView.isEnabled();
        g.setColor(this.background);
        g.fillRect(1, 1, w - 2, h - 2);
        if (isPressed) {
            g.setColor(this.shadow);
            g.drawRect(0, 0, w - 1, h - 1);
        } else {
            g.drawLine(0, 0, 0, h - 1);
            g.drawLine(1, 0, w - 2, 0);
            g.setColor(this.highlight);
            g.drawLine(1, 1, 1, h - 3);
            g.drawLine(2, 1, w - 3, 1);
            g.setColor(this.shadow);
            g.drawLine(1, h - 2, w - 2, h - 2);
            g.drawLine(w - 2, 1, w - 2, h - 3);
            g.setColor(this.darkShadow);
            g.drawLine(0, h - 1, w - 1, h - 1);
            g.drawLine(w - 1, h - 1, w - 1, 0);
        }
        if (h < 5 || w < 5) {
            g.setColor(origColor);
            return;
        }
        if (isPressed) {
            g.translate(1, 1);
        }
        int size = Math.min((h - 4) / 3, (w - 4) / 3);
        size = Math.max(size, 2);
        this.paintTriangle(g, (w - size) / 2, (h - size) / 2, size, direction, isEnabled);
        if (isPressed) {
            g.translate(-1, -1);
        }
        g.setColor(origColor);
    }

    public void paintTriangle(Graphics g, int x, int y, int size, int direction, boolean isEnabled) {
        Color oldColor = g.getColor();
        int j = 0;
        size = Math.max(size, 2);
        int mid = size / 2;
        g.translate(x, y);
        if (isEnabled) {
            g.setColor(UIManager.getColor("controlDkShadow"));
        } else {
            g.setColor(UIManager.getColor("controlShadow"));
        }
        switch (direction) {
            case 1: {
                int i;
                --mid;
                for (i = 0; i < size; ++i) {
                    g.drawLine(mid - i, i, mid + i, i);
                }
                if (isEnabled) break;
                g.setColor(UIManager.getColor("controlLtHighlight"));
                g.drawLine(mid - i + 2, i, mid + i, i);
                break;
            }
            case 5: {
                int i;
                --mid;
                if (!isEnabled) {
                    g.translate(1, 1);
                    g.setColor(UIManager.getColor("controlLtHighlight"));
                    for (i = size - 1; i >= 0; --i) {
                        g.drawLine(mid - i, j, mid + i, j);
                        ++j;
                    }
                    g.translate(-1, -1);
                    g.setColor(UIManager.getColor("controlShadow"));
                }
                j = 0;
                for (i = size - 1; i >= 0; --i) {
                    g.drawLine(mid - i, j, mid + i, j);
                    ++j;
                }
                break;
            }
            case 7: {
                int i;
                for (i = 0; i < size; ++i) {
                    g.drawLine(i, mid - i, i, mid + i);
                }
                if (isEnabled) break;
                g.setColor(UIManager.getColor("controlLtHighlight"));
                g.drawLine(i, mid - i + 2, i, mid + i);
                break;
            }
            case 3: {
                int i;
                if (!isEnabled) {
                    g.translate(1, 1);
                    g.setColor(UIManager.getColor("controlLtHighlight"));
                    for (i = size - 1; i >= 0; --i) {
                        g.drawLine(j, mid - i, j, mid + i);
                        ++j;
                    }
                    g.translate(-1, -1);
                    g.setColor(UIManager.getColor("controlShadow"));
                }
                j = 0;
                for (i = size - 1; i >= 0; --i) {
                    g.drawLine(j, mid - i, j, mid + i);
                    ++j;
                }
                break;
            }
        }
        g.translate(-x, -y);
        g.setColor(oldColor);
    }
}

