/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.slider.plaf.metal;

import com.macrofocus.slider.RangeSliderModel;
import com.macrofocus.slider.plaf.basic.BasicRangeSliderUI;
import com.macrofocus.slider.swing.JRangeSlider;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class MetalRangeSliderUI
extends BasicRangeSliderUI {
    private static final MetalRangeSliderUI rangeSliderUI = new MetalRangeSliderUI();
    private static Color shadowColor;
    private static Color highlightColor;
    private static Color darkShadowColor;
    private static Color thumbColor;
    private static Color thumbShadow;
    private static Color thumbHighlightColor;
    private static Color thumbLightShadowColor;
    private static Color thumbDarkShadowColor;
    private static Color trackColor;
    private static Color trackHighlightColor;
    private MetalBumps bumps;
    private boolean isFreeStanding = true;
    private boolean leftToRight = true;

    public static ComponentUI createUI(JComponent c) {
        return rangeSliderUI;
    }

    public MetalRangeSliderUI() {
        shadowColor = UIManager.getColor("ScrollBar.shadow");
        highlightColor = UIManager.getColor("ScrollBar.highlight");
        darkShadowColor = UIManager.getColor("ScrollBar.darkShadow");
        thumbColor = UIManager.getColor("ScrollBar.thumb");
        thumbShadow = UIManager.getColor("ScrollBar.thumbShadow");
        thumbHighlightColor = UIManager.getColor("ScrollBar.thumbHighlight");
        thumbLightShadowColor = UIManager.getColor("ScrollBar.thumbLightShadow");
        thumbDarkShadowColor = UIManager.getColor("ScrollBar.thumbDarkShadow");
        trackColor = UIManager.getColor("ScrollBar.track");
        this.bumps = new MetalBumps(10, 10, thumbHighlightColor, thumbShadow, thumbColor);
    }

    @Override
    public void paintRange(RangeSliderModel rangeSliderModel, JRangeSlider view, Graphics g, int orientation, Rectangle trackBounds, Rectangle thumbBounds) {
        if (view.isPaintTrack()) {
            g.translate(trackBounds.x, trackBounds.y);
            if (view.getHistogramRenderer() != null) {
                Component c = view.getHistogramRenderer().getRangeSliderHistogramRendererComponent(view, rangeSliderModel.getHistogram());
                if (c != null) {
                    c.setSize(trackBounds.width, trackBounds.height);
                    Graphics g2 = g.create(trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height);
                    c.paint(g2);
                    g2.dispose();
                }
            } else if (view.isOpaque()) {
                g.setColor(this.backgroundColor);
                g.fillRect(trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height);
            }
            if (orientation == 1) {
                if (!this.isFreeStanding) {
                    if (!this.leftToRight) {
                        ++trackBounds.width;
                        g.translate(-1, 0);
                    } else {
                        trackBounds.width += 2;
                    }
                }
                if (view.isEnabled()) {
                    g.setColor(darkShadowColor);
                    g.drawLine(0, 0, 0, trackBounds.height - 1);
                    g.drawLine(trackBounds.width - 2, 0, trackBounds.width - 2, trackBounds.height - 1);
                    g.drawLine(2, trackBounds.height - 1, trackBounds.width - 1, trackBounds.height - 1);
                    g.drawLine(2, 0, trackBounds.width - 2, 0);
                    g.setColor(shadowColor);
                    g.drawLine(1, 1, 1, trackBounds.height - 2);
                    g.drawLine(1, 1, trackBounds.width - 3, 1);
                    if (rangeSliderModel.getCurrentMaximum() != rangeSliderModel.getMaximum()) {
                        int y = thumbBounds.y + thumbBounds.height - trackBounds.y;
                        g.drawLine(1, y, trackBounds.width - 1, y);
                    }
                    g.setColor(highlightColor);
                    g.drawLine(trackBounds.width - 1, 0, trackBounds.width - 1, trackBounds.height - 1);
                } else {
                    MetalRangeSliderUI.drawDisabledBorder(g, 0, 0, trackBounds.width, trackBounds.height);
                }
                if (!this.isFreeStanding) {
                    if (!this.leftToRight) {
                        --trackBounds.width;
                        g.translate(1, 0);
                    } else {
                        trackBounds.width -= 2;
                    }
                }
            } else {
                if (!this.isFreeStanding) {
                    trackBounds.height += 2;
                }
                if (view.isEnabled()) {
                    g.setColor(darkShadowColor);
                    g.drawLine(0, 0, trackBounds.width - 1, 0);
                    g.drawLine(0, 2, 0, trackBounds.height - 2);
                    g.drawLine(0, trackBounds.height - 2, trackBounds.width - 1, trackBounds.height - 2);
                    g.drawLine(trackBounds.width - 1, 2, trackBounds.width - 1, trackBounds.height - 1);
                    g.setColor(shadowColor);
                    g.drawLine(1, 1, trackBounds.width - 2, 1);
                    g.drawLine(1, 1, 1, trackBounds.height - 3);
                    g.drawLine(0, trackBounds.height - 1, trackBounds.width - 1, trackBounds.height - 1);
                    if (rangeSliderModel.getCurrentMaximum() != rangeSliderModel.getMaximum()) {
                        int x = thumbBounds.x + thumbBounds.width - trackBounds.x;
                        g.drawLine(x, 1, x, trackBounds.height - 1);
                    }
                    g.setColor(highlightColor);
                    g.drawLine(0, trackBounds.height - 1, trackBounds.width - 1, trackBounds.height - 1);
                } else {
                    MetalRangeSliderUI.drawDisabledBorder(g, 0, 0, trackBounds.width, trackBounds.height);
                }
                if (!this.isFreeStanding) {
                    trackBounds.height -= 2;
                }
            }
            g.translate(-trackBounds.x, -trackBounds.y);
        }
    }

    public void paintThumb(JComponent sliderView, Graphics g, int orientation, Rectangle thumbBounds) {
        if (!sliderView.isEnabled()) {
            return;
        }
        g.translate(thumbBounds.x, thumbBounds.y);
        if (orientation == 1) {
            if (!this.isFreeStanding) {
                if (!this.leftToRight) {
                    ++thumbBounds.width;
                    g.translate(-1, 0);
                } else {
                    thumbBounds.width += 2;
                }
            }
            g.setColor(thumbColor);
            g.fillRect(0, 0, thumbBounds.width - 2, thumbBounds.height - 1);
            g.setColor(thumbShadow);
            g.drawRect(0, 0, thumbBounds.width - 2, thumbBounds.height - 1);
            g.setColor(thumbHighlightColor);
            g.drawLine(1, 1, thumbBounds.width - 3, 1);
            g.drawLine(1, 1, 1, thumbBounds.height - 2);
            this.bumps.setBumpArea(thumbBounds.width - 6, thumbBounds.height - 7);
            this.bumps.paintIcon(sliderView, g, 3, 4);
            if (!this.isFreeStanding) {
                if (!this.leftToRight) {
                    --thumbBounds.width;
                    g.translate(1, 0);
                } else {
                    thumbBounds.width -= 2;
                }
            }
        } else {
            if (!this.isFreeStanding) {
                if (!this.leftToRight) {
                    ++thumbBounds.height;
                    g.translate(0, -1);
                } else {
                    thumbBounds.height += 2;
                }
            }
            g.setColor(thumbColor);
            g.fillRect(0, 0, thumbBounds.width - 1, thumbBounds.height - 2);
            g.setColor(thumbShadow);
            g.drawRect(0, 0, thumbBounds.width - 1, thumbBounds.height - 2);
            g.setColor(thumbHighlightColor);
            g.drawLine(1, 1, thumbBounds.width - 3, 1);
            g.drawLine(1, 1, 1, thumbBounds.height - 2);
            this.bumps.setBumpArea(thumbBounds.width - 7, thumbBounds.height - 6);
            this.bumps.paintIcon(sliderView, g, 4, 3);
            if (!this.isFreeStanding) {
                if (!this.leftToRight) {
                    --thumbBounds.height;
                    g.translate(0, 1);
                } else {
                    thumbBounds.height -= 2;
                }
            }
        }
        g.translate(-thumbBounds.x, -thumbBounds.y);
    }

    private static void drawFlush3DBorder(Graphics g, Rectangle r) {
        MetalRangeSliderUI.drawFlush3DBorder(g, r.x, r.y, r.width, r.height);
    }

    private static void drawFlush3DBorder(Graphics g, int x, int y, int w, int h) {
        g.translate(x, y);
        g.setColor(MetalLookAndFeel.getControlDarkShadow());
        g.drawRect(0, 0, w - 2, h - 2);
        g.setColor(MetalLookAndFeel.getControlHighlight());
        g.drawRect(1, 1, w - 2, h - 2);
        g.setColor(MetalLookAndFeel.getControl());
        g.drawLine(0, h - 1, 1, h - 2);
        g.drawLine(w - 1, 0, w - 2, 1);
        g.translate(-x, -y);
    }

    private static void drawPressed3DBorder(Graphics g, Rectangle r) {
        MetalRangeSliderUI.drawPressed3DBorder(g, r.x, r.y, r.width, r.height);
    }

    private static void drawDisabledBorder(Graphics g, int x, int y, int w, int h) {
        g.translate(x, y);
        g.setColor(MetalLookAndFeel.getControlShadow());
        g.drawRect(0, 0, w - 1, h - 1);
    }

    private static void drawPressed3DBorder(Graphics g, int x, int y, int w, int h) {
        g.translate(x, y);
        MetalRangeSliderUI.drawFlush3DBorder(g, 0, 0, w, h);
        g.setColor(MetalLookAndFeel.getControlShadow());
        g.drawLine(1, 1, 1, h - 2);
        g.drawLine(1, 1, w - 2, 1);
        g.translate(-x, -y);
    }

    private static void drawDark3DBorder(Graphics g, Rectangle r) {
        MetalRangeSliderUI.drawDark3DBorder(g, r.x, r.y, r.width, r.height);
    }

    private static void drawDark3DBorder(Graphics g, int x, int y, int w, int h) {
        g.translate(x, y);
        MetalRangeSliderUI.drawFlush3DBorder(g, 0, 0, w, h);
        g.setColor(MetalLookAndFeel.getControl());
        g.drawLine(1, 1, 1, h - 2);
        g.drawLine(1, 1, w - 2, 1);
        g.setColor(MetalLookAndFeel.getControlShadow());
        g.drawLine(1, h - 2, 1, h - 2);
        g.drawLine(w - 2, 1, w - 2, 1);
        g.translate(-x, -y);
    }

    private static void drawButtonBorder(Graphics g, int x, int y, int w, int h, boolean active) {
        if (active) {
            MetalRangeSliderUI.drawActiveButtonBorder(g, x, y, w, h);
        } else {
            MetalRangeSliderUI.drawFlush3DBorder(g, x, y, w, h);
        }
    }

    private static void drawActiveButtonBorder(Graphics g, int x, int y, int w, int h) {
        MetalRangeSliderUI.drawFlush3DBorder(g, x, y, w, h);
        g.setColor(MetalLookAndFeel.getPrimaryControl());
        g.drawLine(x + 1, y + 1, x + 1, h - 3);
        g.drawLine(x + 1, y + 1, w - 3, x + 1);
        g.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
        g.drawLine(x + 2, h - 2, w - 2, h - 2);
        g.drawLine(w - 2, y + 2, w - 2, h - 2);
    }

    private static void drawDefaultButtonBorder(Graphics g, int x, int y, int w, int h, boolean active) {
        MetalRangeSliderUI.drawButtonBorder(g, x + 1, y + 1, w - 1, h - 1, active);
        g.setColor(MetalLookAndFeel.getControlDarkShadow());
        g.drawRect(x, y, w - 3, h - 3);
        g.drawLine(w - 2, 0, w - 2, 0);
        g.drawLine(0, h - 2, 0, h - 2);
    }

    private static boolean isLeftToRight(Component c) {
        return c.getComponentOrientation().isLeftToRight();
    }

    @Override
    public void paintArrowButton(JComponent sliderView, Graphics g, int direction, Rectangle bounds) {
        boolean leftToRight = MetalRangeSliderUI.isLeftToRight(sliderView);
        boolean isEnabled = sliderView.getParent().isEnabled();
        ColorUIResource arrowColor = isEnabled ? MetalLookAndFeel.getControlInfo() : MetalLookAndFeel.getControlDisabled();
        boolean isPressed = false;
        int width = bounds.width;
        int height = bounds.height;
        int w = width;
        int h = height;
        int arrowHeight = (height + 1) / 4;
        int arrowWidth = (height + 1) / 2;
        if (isPressed) {
            g.setColor(MetalLookAndFeel.getControlShadow());
        } else {
            g.setColor(sliderView.getBackground());
        }
        g.fillRect(0, 0, width, height);
        if (direction == 1) {
            if (!this.isFreeStanding) {
                ++height;
                g.translate(0, -1);
                if (!leftToRight) {
                    ++width;
                    g.translate(-1, 0);
                } else {
                    width += 2;
                }
            }
            g.setColor(arrowColor);
            int startY = (h + 1 - arrowHeight) / 2 - 1;
            int startX = w / 2 - 1;
            for (int line = 0; line < arrowHeight; ++line) {
                g.drawLine(startX - line, startY + line, startX + line + 1, startY + line);
            }
            if (isEnabled) {
                g.setColor(highlightColor);
                if (!isPressed) {
                    g.drawLine(1, 0, width - 3, 0);
                    g.drawLine(1, 0, 1, height - 3);
                }
                g.drawLine(1, height - 1, width - 1, height - 1);
                g.drawLine(width - 1, 0, width - 1, height - 1);
                g.setColor(darkShadowColor);
                g.drawLine(0, 0, 0, height - 2);
                g.drawLine(width - 2, 0, width - 2, height - 2);
                g.drawLine(2, height - 2, width - 2, height - 2);
            } else {
                MetalRangeSliderUI.drawDisabledBorder(g, 0, -1, width, height + 1);
            }
            if (!this.isFreeStanding) {
                --height;
                g.translate(0, 1);
                if (!leftToRight) {
                    --width;
                    g.translate(1, 0);
                } else {
                    width -= 2;
                }
            }
        } else if (direction == 5) {
            if (!this.isFreeStanding) {
                ++height;
                if (!leftToRight) {
                    ++width;
                    g.translate(-1, 0);
                } else {
                    width += 2;
                }
            }
            g.setColor(arrowColor);
            int startY = (h + 1 - arrowHeight) / 2 + arrowHeight - 1 + 1;
            int startX = w / 2 - 1;
            for (int line = 0; line < arrowHeight; ++line) {
                g.drawLine(startX - line, startY - line, startX + line + 1, startY - line);
            }
            if (isEnabled) {
                g.setColor(highlightColor);
                if (!isPressed) {
                    g.drawLine(1, 1, width - 3, 1);
                    g.drawLine(1, 1, 1, height - 1);
                }
                g.drawLine(width - 1, 1, width - 1, height - 1);
                g.setColor(darkShadowColor);
                g.drawLine(0, 0, width - 2, 0);
                g.drawLine(0, 0, 0, height - 1);
                g.drawLine(width - 2, 2, width - 2, height - 1);
            } else {
                MetalRangeSliderUI.drawDisabledBorder(g, 0, 0, width, height + 1);
            }
            if (!this.isFreeStanding) {
                --height;
                if (!leftToRight) {
                    --width;
                    g.translate(1, 0);
                } else {
                    width -= 2;
                }
            }
        } else if (direction == 3) {
            if (!this.isFreeStanding) {
                height += 2;
                ++width;
            }
            g.setColor(arrowColor);
            int startX = (w + 1 - arrowHeight) / 2 + arrowHeight - 1 + 1;
            int startY = h / 2 - 1;
            for (int line = 0; line < arrowHeight; ++line) {
                g.drawLine(startX - line, startY - line, startX - line, startY + line + 1);
            }
            if (isEnabled) {
                g.setColor(highlightColor);
                if (!isPressed) {
                    g.drawLine(1, 1, width - 1, 1);
                    g.drawLine(1, 1, 1, height - 3);
                }
                g.drawLine(1, height - 1, width - 1, height - 1);
                g.setColor(darkShadowColor);
                g.drawLine(0, 0, width - 1, 0);
                g.drawLine(0, 0, 0, height - 2);
                g.drawLine(2, height - 2, width - 1, height - 2);
            } else {
                MetalRangeSliderUI.drawDisabledBorder(g, 0, 0, width + 1, height);
            }
            if (!this.isFreeStanding) {
                height -= 2;
                --width;
            }
        } else if (direction == 7) {
            if (!this.isFreeStanding) {
                height += 2;
                ++width;
                g.translate(-1, 0);
            }
            g.setColor(arrowColor);
            int startX = (w + 1 - arrowHeight) / 2 - 1;
            int startY = h / 2 - 1;
            for (int line = 0; line < arrowHeight; ++line) {
                g.drawLine(startX + line, startY - line, startX + line, startY + line + 1);
            }
            if (isEnabled) {
                g.setColor(highlightColor);
                if (!isPressed) {
                    g.drawLine(0, 1, width - 3, 1);
                    g.drawLine(0, 1, 0, height - 3);
                }
                g.drawLine(width - 1, 1, width - 1, height - 1);
                g.drawLine(0, height - 1, width - 1, height - 1);
                g.setColor(darkShadowColor);
                g.drawLine(0, 0, width - 2, 0);
                g.drawLine(width - 2, 2, width - 2, height - 2);
                g.drawLine(0, height - 2, width - 2, height - 2);
            } else {
                MetalRangeSliderUI.drawDisabledBorder(g, -1, 0, width + 1, height);
            }
            if (!this.isFreeStanding) {
                height -= 2;
                --width;
                g.translate(1, 0);
            }
        }
    }

    class BumpBuffer {
        Frame frame;
        Component component;
        final int IMAGE_SIZE = 64;
        final Dimension imageSize = new Dimension(64, 64);
        transient Image image;
        Color topColor;
        Color shadowColor;
        Color backColor;

        public BumpBuffer(Color aTopColor, Color aShadowColor, Color aBackColor) {
            this.createComponent();
            this.image = this.getComponent().createImage(64, 64);
            this.topColor = aTopColor;
            this.shadowColor = aShadowColor;
            this.backColor = aBackColor;
            this.fillBumpBuffer();
        }

        public boolean hasSameColors(Color aTopColor, Color aShadowColor, Color aBackColor) {
            return this.topColor != null && this.topColor.equals(aTopColor) && this.shadowColor != null && this.shadowColor.equals(aShadowColor) && this.backColor != null && this.backColor.equals(aBackColor);
        }

        public Image getImage() {
            if (this.image == null) {
                this.image = this.getComponent().createImage(64, 64);
                this.fillBumpBuffer();
            }
            return this.image;
        }

        public Dimension getImageSize() {
            return this.imageSize;
        }

        protected void fillBumpBuffer() {
            int y;
            int x;
            Graphics g = this.image.getGraphics();
            g.setColor(this.backColor);
            g.fillRect(0, 0, 64, 64);
            g.setColor(this.topColor);
            for (x = 0; x < 64; x += 4) {
                for (y = 0; y < 64; y += 4) {
                    g.drawLine(x, y, x, y);
                    g.drawLine(x + 2, y + 2, x + 2, y + 2);
                }
            }
            g.setColor(this.shadowColor);
            for (x = 0; x < 64; x += 4) {
                for (y = 0; y < 64; y += 4) {
                    g.drawLine(x + 1, y + 1, x + 1, y + 1);
                    g.drawLine(x + 3, y + 3, x + 3, y + 3);
                }
            }
            g.dispose();
        }

        protected Component getComponent() {
            return this.component;
        }

        protected void createComponent() {
            if (this.frame == null) {
                this.frame = new Frame("bufferCreator");
            }
            if (this.component == null) {
                this.component = new Canvas();
                this.frame.add(this.component, "Center");
            }
            this.frame.addNotify();
        }
    }

    class MetalBumps
    implements Icon {
        protected int xBumps;
        protected int yBumps;
        protected Color topColor = MetalLookAndFeel.getPrimaryControlHighlight();
        protected Color shadowColor = MetalLookAndFeel.getPrimaryControlDarkShadow();
        protected Color backColor = MetalLookAndFeel.getPrimaryControlShadow();
        protected final Vector buffers = new Vector();
        protected BumpBuffer buffer;

        public MetalBumps(Dimension bumpArea) {
            this(bumpArea.width, bumpArea.height);
        }

        public MetalBumps(int width, int height) {
            this.setBumpArea(width, height);
            this.buffer = this.getBuffer(this.topColor, this.shadowColor, this.backColor);
            if (this.buffer == null) {
                this.createBuffer();
            }
        }

        public MetalBumps(int width, int height, Color newTopColor, Color newShadowColor, Color newBackColor) {
            this.setBumpArea(width, height);
            this.setBumpColors(newTopColor, newShadowColor, newBackColor);
            this.buffer = this.getBuffer(this.topColor, this.shadowColor, this.backColor);
            if (this.buffer == null) {
                this.createBuffer();
            }
        }

        protected void createBuffer() {
            this.buffer = new BumpBuffer(this.topColor, this.shadowColor, this.backColor);
            this.buffers.addElement(this.buffer);
        }

        protected BumpBuffer getBuffer(Color aTopColor, Color aShadowColor, Color aBackColor) {
            BumpBuffer result = null;
            Enumeration elements = this.buffers.elements();
            while (elements.hasMoreElements()) {
                BumpBuffer aBuffer = (BumpBuffer)elements.nextElement();
                if (!aBuffer.hasSameColors(aTopColor, aShadowColor, aBackColor)) continue;
                result = aBuffer;
                break;
            }
            return result;
        }

        public void setBumpArea(Dimension bumpArea) {
            this.setBumpArea(bumpArea.width, bumpArea.height);
        }

        public void setBumpArea(int width, int height) {
            this.xBumps = width / 2;
            this.yBumps = height / 2;
        }

        public void setBumpColors(Color newTopColor, Color newShadowColor, Color newBackColor) {
            this.topColor = newTopColor;
            this.shadowColor = newShadowColor;
            this.backColor = newBackColor;
            this.buffer = this.getBuffer(this.topColor, this.shadowColor, this.backColor);
            if (this.buffer == null) {
                this.createBuffer();
            }
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            int bufferWidth = this.buffer.getImageSize().width;
            int bufferHeight = this.buffer.getImageSize().height;
            int iconWidth = this.getIconWidth();
            int iconHeight = this.getIconHeight();
            int x2 = x + iconWidth;
            int y2 = y + iconHeight;
            int savex = x;
            while (y < y2) {
                int h = Math.min(y2 - y, bufferHeight);
                for (x = savex; x < x2; x += bufferWidth) {
                    int w = Math.min(x2 - x, bufferWidth);
                    g.drawImage(this.buffer.getImage(), x, y, x + w, y + h, 0, 0, w, h, null);
                }
                y += bufferHeight;
            }
        }

        @Override
        public int getIconWidth() {
            return this.xBumps * 2;
        }

        @Override
        public int getIconHeight() {
            return this.yBumps * 2;
        }
    }
}

