/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.slider.swing;

import com.macrofocus.slider.RangeSliderEvent;
import com.macrofocus.slider.RangeSliderListener;
import com.macrofocus.slider.RangeSliderModel;
import com.macrofocus.slider.swing.JSliderView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.UIManager;

public class RectangleSliderView
extends JSliderView {
    protected Rectangle thumbBounds = new Rectangle();
    private int orientation;
    protected RangeSliderModel rangeSliderModel;
    protected Rectangle minRectangle = new Rectangle();
    protected Rectangle maxRectangle = new Rectangle();

    public RectangleSliderView(RangeSliderModel rangeSliderModel, int orientation) {
        this.rangeSliderModel = rangeSliderModel;
        this.orientation = orientation;
        this.updateRectangles();
        rangeSliderModel.addSliderListener(new RangeSliderListener(){

            public void sliderChanged(RangeSliderEvent e) {
                RectangleSliderView.this.updateRectangles();
                RectangleSliderView.this.repaint();
            }

            public void sliderScaleChanged(RangeSliderEvent e) {
                RectangleSliderView.this.updateRectangles();
                RectangleSliderView.this.repaint();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                RectangleSliderView.this.updateRectangles();
                RectangleSliderView.this.repaint();
            }
        });
    }

    public RangeSliderModel getRangeSliderModel() {
        return this.rangeSliderModel;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public Rectangle getTrackBounds() {
        return null;
    }

    public Rectangle getThumbBounds() {
        return this.thumbBounds;
    }

    public Rectangle getMinBounds() {
        return this.minRectangle;
    }

    public Rectangle getMaxBounds() {
        return this.maxRectangle;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(Color.lightGray);
        g.fillRect(this.thumbBounds.x, this.thumbBounds.y, this.thumbBounds.width, this.thumbBounds.height);
    }

    @Override
    public Dimension getMinimumSize() {
        if (UIManager.get("ScrollBar.width") != null) {
            int scrollBarWidth = (Integer)UIManager.get("ScrollBar.width");
            if (this.getOrientation() == 1) {
                return new Dimension(scrollBarWidth, scrollBarWidth * 3 + 10);
            }
            return new Dimension(scrollBarWidth * 3 + 10, scrollBarWidth);
        }
        return this.getOrientation() == 1 ? new Dimension(16, 48) : new Dimension(48, 16);
    }

    protected void updateRectangles() {
        if (this.getOrientation() == 1) {
            int width;
            Dimension size = this.getSize();
            int screenWidth = size.width;
            int screenHeight = size.height;
            int x = 0;
            int height = width = screenWidth - 0;
            int minY = this.toScreen(this.rangeSliderModel.getCurrentMinimum());
            int maxY = this.toScreen(this.rangeSliderModel.getCurrentMaximum());
            this.maxRectangle.setBounds(x, maxY, width, height);
            this.minRectangle.setBounds(x, minY, width, height);
            this.thumbBounds.setBounds(0, maxY, this.getWidth(), minY - maxY);
        } else {
            int height;
            Dimension size = this.getSize();
            int screenWidth = size.width;
            int screenHeight = size.height;
            int y = 0;
            int width = height = screenHeight - 0;
            int minX = this.toScreen(this.rangeSliderModel.getCurrentMinimum());
            int maxX = this.toScreen(this.rangeSliderModel.getCurrentMaximum());
            this.maxRectangle.setBounds(maxX, y, width, height);
            this.minRectangle.setBounds(minX, y, width, height);
            this.thumbBounds.setBounds(minX, 0, maxX - minX, this.getHeight());
        }
    }

    public int toScreen(double value) {
        if (this.getOrientation() == 1) {
            double screenRange = this.getHeight();
            double worldRange = this.rangeSliderModel.getMaximum() - this.rangeSliderModel.getMinimum();
            return (int)Math.round(screenRange * (worldRange - (value - this.rangeSliderModel.getMinimum())) / worldRange);
        }
        double screenRange = this.getWidth();
        double worldRange = this.rangeSliderModel.getMaximum() - this.rangeSliderModel.getMinimum();
        return (int)Math.round(screenRange * (value - this.rangeSliderModel.getMinimum()) / worldRange);
    }

    public double toWorld(int value) {
        if (this.getOrientation() == 1) {
            Dimension size = this.getSize();
            int screenWidth = size.width;
            int screenHeight = size.height;
            double screenRange = this.getHeight();
            double worldRange = this.rangeSliderModel.getMaximum() - this.rangeSliderModel.getMinimum();
            return worldRange * (screenRange - (double)value) / screenRange;
        }
        Dimension size = this.getSize();
        int screenWidth = size.width;
        int screenHeight = size.height;
        double screenRange = this.getWidth();
        double worldRange = this.rangeSliderModel.getMaximum() - this.rangeSliderModel.getMinimum();
        return worldRange * (double)value / screenRange;
    }

    public int getScreenRange() {
        if (this.getOrientation() == 1) {
            return this.getHeight();
        }
        return this.getWidth();
    }

    public Component getComponent() {
        return this;
    }
}

