/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.slider.swing;

import com.macrofocus.slider.RangeSliderModel;
import com.macrofocus.slider.SliderController;
import com.macrofocus.slider.SliderView;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;

public class SimpleRangeSliderController
implements SliderController {
    private int savedX;
    private int savedY;
    private Rectangle selectedRectangle;

    public SimpleRangeSliderController(SliderView sliderView) {
        this(sliderView, 1.0, false);
    }

    public SimpleRangeSliderController(SliderView sliderView, boolean symetric) {
        this(sliderView, 1.0, symetric);
    }

    public SimpleRangeSliderController(final SliderView sliderView, final double accelerationFactor, final boolean symetric) {
        sliderView.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (sliderView.isEnabled() && e.getClickCount() > 1) {
                    sliderView.getRangeSliderModel().reset((Object)this);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (sliderView.isEnabled()) {
                    sliderView.getComponent().requestFocus();
                    SimpleRangeSliderController.this.savedX = e.getX();
                    SimpleRangeSliderController.this.savedY = e.getY();
                    int x = e.getX();
                    int y = e.getY();
                    if (sliderView.getMinBounds().contains(x, y)) {
                        SimpleRangeSliderController.this.selectedRectangle = sliderView.getMinBounds();
                        e.consume();
                    } else if (sliderView.getMaxBounds().contains(x, y)) {
                        SimpleRangeSliderController.this.selectedRectangle = sliderView.getMaxBounds();
                        e.consume();
                    } else if (sliderView.getThumbBounds().contains(x, y)) {
                        SimpleRangeSliderController.this.selectedRectangle = sliderView.getThumbBounds();
                        RangeSliderModel model = sliderView.getRangeSliderModel();
                        if (!model.isFullRange()) {
                            e.consume();
                        }
                    } else {
                        RangeSliderModel model = sliderView.getRangeSliderModel();
                        if (sliderView.getOrientation() == 1) {
                            if (!model.isInvertedScale()) {
                                if (y > sliderView.getMinBounds().y) {
                                    double translatedMin = model.getCurrentMinimum() - model.getCurrentExtent();
                                    double translatedMax = model.getCurrentMaximum() - model.getCurrentExtent();
                                    if (translatedMin < model.getMinimum()) {
                                        translatedMin = model.getMinimum();
                                        translatedMax = model.getMinimum() + model.getCurrentExtent();
                                    }
                                    SimpleRangeSliderController.this.setValues(model, translatedMin, translatedMax);
                                } else {
                                    double translatedMin = model.getCurrentMinimum() + model.getCurrentExtent();
                                    double translatedMax = model.getCurrentMaximum() + model.getCurrentExtent();
                                    if (translatedMax > model.getMaximum()) {
                                        translatedMin = model.getMaximum() - model.getCurrentExtent();
                                        translatedMax = model.getMaximum();
                                    }
                                    SimpleRangeSliderController.this.setValues(model, translatedMin, translatedMax);
                                }
                            } else if (y > sliderView.getMinBounds().y) {
                                double translatedMin = model.getCurrentMinimum() + model.getCurrentExtent();
                                double translatedMax = model.getCurrentMaximum() + model.getCurrentExtent();
                                if (translatedMin > model.getMinimum()) {
                                    translatedMin = model.getMinimum();
                                    translatedMax = model.getMinimum() - model.getCurrentExtent();
                                }
                                SimpleRangeSliderController.this.setValues(model, translatedMin, translatedMax);
                            } else {
                                double translatedMin = model.getCurrentMinimum() - model.getCurrentExtent();
                                double translatedMax = model.getCurrentMaximum() - model.getCurrentExtent();
                                if (translatedMax < model.getMaximum()) {
                                    translatedMin = model.getMaximum() + model.getCurrentExtent();
                                    translatedMax = model.getMaximum();
                                }
                                SimpleRangeSliderController.this.setValues(model, translatedMin, translatedMax);
                            }
                        } else if (!model.isInvertedScale()) {
                            if (x < sliderView.getMinBounds().x) {
                                double translatedMin = model.getCurrentMinimum() - model.getCurrentExtent();
                                double translatedMax = model.getCurrentMaximum() - model.getCurrentExtent();
                                if (translatedMin < model.getMinimum()) {
                                    translatedMin = model.getMinimum();
                                    translatedMax = model.getMinimum() + model.getCurrentExtent();
                                }
                                SimpleRangeSliderController.this.setValues(model, translatedMin, translatedMax);
                            } else {
                                double translatedMin = model.getCurrentMinimum() + model.getCurrentExtent();
                                double translatedMax = model.getCurrentMaximum() + model.getCurrentExtent();
                                if (translatedMax > model.getMaximum()) {
                                    translatedMin = model.getMaximum() - model.getCurrentExtent();
                                    translatedMax = model.getMaximum();
                                }
                                SimpleRangeSliderController.this.setValues(model, translatedMin, translatedMax);
                            }
                        } else if (x < sliderView.getMinBounds().x) {
                            double translatedMin = model.getCurrentMinimum() + model.getCurrentExtent();
                            double translatedMax = model.getCurrentMaximum() + model.getCurrentExtent();
                            if (translatedMin > model.getMinimum()) {
                                translatedMin = model.getMinimum();
                                translatedMax = model.getMinimum() - model.getCurrentExtent();
                            }
                            SimpleRangeSliderController.this.setValues(model, translatedMin, translatedMax);
                        } else {
                            double translatedMin = model.getCurrentMinimum() - model.getCurrentExtent();
                            double translatedMax = model.getCurrentMaximum() - model.getCurrentExtent();
                            if (translatedMax < model.getMaximum()) {
                                translatedMin = model.getMaximum() + model.getCurrentExtent();
                                translatedMax = model.getMaximum();
                            }
                            SimpleRangeSliderController.this.setValues(model, translatedMin, translatedMax);
                        }
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                SimpleRangeSliderController.this.selectedRectangle = null;
            }
        });
        sliderView.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (sliderView.isEnabled() && SimpleRangeSliderController.this.selectedRectangle != null) {
                    boolean changed = false;
                    int deltaMouse = sliderView.getOrientation() == 1 ? SimpleRangeSliderController.this.savedY - e.getY() : e.getX() - SimpleRangeSliderController.this.savedX;
                    RangeSliderModel sliderModel = sliderView.getRangeSliderModel();
                    if (sliderModel.isInvertedScale()) {
                        deltaMouse = -deltaMouse;
                    }
                    double ratio = sliderView.getScreenRange() > 0 ? (double)deltaMouse / (double)sliderView.getScreenRange() * accelerationFactor : 0.0;
                    double delta = sliderModel.getExtent() * ratio;
                    if (SimpleRangeSliderController.this.selectedRectangle == sliderView.getThumbBounds()) {
                        double translatedMin = sliderModel.getCurrentMinimum() + delta;
                        double translatedMax = sliderModel.getCurrentMaximum() + delta;
                        if (sliderModel.getCurrentMinimum() != sliderModel.getMinimum() || sliderModel.getCurrentMaximum() != sliderModel.getMaximum()) {
                            if (!sliderModel.isInvertedScale()) {
                                if (translatedMin < sliderModel.getMinimum()) {
                                    translatedMin = sliderModel.getMinimum();
                                    translatedMax = sliderModel.getMinimum() + sliderModel.getCurrentExtent();
                                }
                                if (translatedMax > sliderModel.getMaximum()) {
                                    translatedMin = sliderModel.getMaximum() - sliderModel.getCurrentExtent();
                                    translatedMax = sliderModel.getMaximum();
                                }
                                if (translatedMin < sliderModel.getLowerMinimumValue()) {
                                    translatedMin = sliderModel.getLowerMinimumValue();
                                    translatedMax = sliderModel.getLowerMinimumValue() + sliderModel.getCurrentExtent();
                                }
                                if (translatedMin > sliderModel.getLowerMaximumValue()) {
                                    translatedMin = sliderModel.getLowerMaximumValue();
                                    translatedMax = sliderModel.getLowerMaximumValue() + sliderModel.getCurrentExtent();
                                }
                                if (translatedMax < sliderModel.getUpperMinimumValue()) {
                                    translatedMin = sliderModel.getUpperMinimumValue() - sliderModel.getCurrentExtent();
                                    translatedMax = sliderModel.getUpperMinimumValue();
                                }
                                if (translatedMax > sliderModel.getUpperMaximumValue()) {
                                    translatedMin = sliderModel.getUpperMaximumValue() - sliderModel.getCurrentExtent();
                                    translatedMax = sliderModel.getUpperMaximumValue();
                                }
                            } else {
                                if (translatedMin > sliderModel.getMinimum()) {
                                    translatedMin = sliderModel.getMinimum();
                                    translatedMax = sliderModel.getMinimum() + sliderModel.getCurrentExtent();
                                }
                                if (translatedMax < sliderModel.getMaximum()) {
                                    translatedMin = sliderModel.getMaximum() - sliderModel.getCurrentExtent();
                                    translatedMax = sliderModel.getMaximum();
                                }
                                if (translatedMin > sliderModel.getLowerMinimumValue()) {
                                    translatedMin = sliderModel.getLowerMinimumValue();
                                    translatedMax = sliderModel.getLowerMinimumValue() + sliderModel.getCurrentExtent();
                                }
                                if (translatedMin < sliderModel.getLowerMaximumValue()) {
                                    translatedMin = sliderModel.getLowerMaximumValue();
                                    translatedMax = sliderModel.getLowerMaximumValue() + sliderModel.getCurrentExtent();
                                }
                                if (translatedMax > sliderModel.getUpperMinimumValue()) {
                                    translatedMin = sliderModel.getUpperMinimumValue() - sliderModel.getCurrentExtent();
                                    translatedMax = sliderModel.getUpperMinimumValue();
                                }
                                if (translatedMax < sliderModel.getUpperMaximumValue()) {
                                    translatedMin = sliderModel.getUpperMaximumValue() - sliderModel.getCurrentExtent();
                                    translatedMax = sliderModel.getUpperMaximumValue();
                                }
                            }
                            changed = SimpleRangeSliderController.this.setValues(sliderModel, translatedMin, translatedMax);
                        }
                    } else if (SimpleRangeSliderController.this.selectedRectangle == sliderView.getMinBounds()) {
                        double translatedMin = sliderModel.getCurrentMinimum() + delta;
                        double translatedMax = sliderModel.getCurrentMaximum() - delta;
                        if (!sliderModel.isInvertedScale()) {
                            if (translatedMin < sliderModel.getMinimum()) {
                                translatedMin = sliderModel.getMinimum();
                            }
                            if (translatedMax > sliderModel.getMaximum()) {
                                translatedMax = sliderModel.getMaximum();
                            }
                            if (translatedMin < sliderModel.getLowerMinimumValue()) {
                                translatedMin = sliderModel.getLowerMinimumValue();
                            }
                            if (translatedMin > sliderModel.getLowerMaximumValue()) {
                                translatedMin = sliderModel.getLowerMaximumValue();
                            }
                            if (translatedMax < sliderModel.getUpperMinimumValue()) {
                                translatedMax = sliderModel.getUpperMinimumValue();
                            }
                            if (translatedMax > sliderModel.getUpperMaximumValue()) {
                                translatedMax = sliderModel.getUpperMaximumValue();
                            }
                            if (sliderModel.getCurrentMaximum() - translatedMin > sliderModel.getMaximumExtent()) {
                                translatedMin = sliderModel.getCurrentMaximum() - sliderModel.getMaximumExtent();
                            }
                            if (sliderModel.getCurrentMaximum() - translatedMin < sliderModel.getMinimumExtent()) {
                                translatedMin = sliderModel.getCurrentMaximum() - sliderModel.getMinimumExtent();
                            }
                        } else {
                            if (translatedMin > sliderModel.getMinimum()) {
                                translatedMin = sliderModel.getMinimum();
                            }
                            if (translatedMax < sliderModel.getMaximum()) {
                                translatedMax = sliderModel.getMaximum();
                            }
                            if (translatedMin > sliderModel.getLowerMinimumValue()) {
                                translatedMin = sliderModel.getLowerMinimumValue();
                            }
                            if (translatedMin < sliderModel.getLowerMaximumValue()) {
                                translatedMin = sliderModel.getLowerMaximumValue();
                            }
                            if (translatedMax > sliderModel.getUpperMinimumValue()) {
                                translatedMax = sliderModel.getUpperMinimumValue();
                            }
                            if (translatedMax < sliderModel.getUpperMaximumValue()) {
                                translatedMax = sliderModel.getUpperMaximumValue();
                            }
                            if (translatedMax - sliderModel.getCurrentMinimum() > sliderModel.getMaximumExtent()) {
                                translatedMax = sliderModel.getCurrentMinimum() + sliderModel.getMaximumExtent();
                            }
                            if (translatedMax - sliderModel.getCurrentMinimum() < sliderModel.getMinimumExtent()) {
                                translatedMax = sliderModel.getCurrentMinimum() + sliderModel.getMinimumExtent();
                            }
                        }
                        changed = !symetric ? SimpleRangeSliderController.this.setValues(sliderModel, translatedMin, sliderModel.getCurrentMaximum()) : SimpleRangeSliderController.this.setValues(sliderModel, translatedMin, translatedMax);
                    } else if (SimpleRangeSliderController.this.selectedRectangle == sliderView.getMaxBounds()) {
                        double translatedMin = sliderModel.getCurrentMinimum() - delta;
                        double translatedMax = sliderModel.getCurrentMaximum() + delta;
                        if (!sliderModel.isInvertedScale()) {
                            if (translatedMin < sliderModel.getMinimum()) {
                                translatedMin = sliderModel.getMinimum();
                            }
                            if (translatedMax > sliderModel.getMaximum()) {
                                translatedMax = sliderModel.getMaximum();
                            }
                            if (translatedMax < sliderModel.getUpperMinimumValue()) {
                                translatedMax = sliderModel.getUpperMinimumValue();
                            }
                            if (translatedMax > sliderModel.getUpperMaximumValue()) {
                                translatedMax = sliderModel.getUpperMaximumValue();
                            }
                            if (translatedMin < sliderModel.getLowerMinimumValue()) {
                                translatedMin = sliderModel.getLowerMinimumValue();
                            }
                            if (translatedMin > sliderModel.getLowerMaximumValue()) {
                                translatedMin = sliderModel.getLowerMaximumValue();
                            }
                            if (translatedMax - sliderModel.getCurrentMinimum() > sliderModel.getMaximumExtent()) {
                                translatedMax = sliderModel.getCurrentMinimum() + sliderModel.getMaximumExtent();
                            }
                            if (translatedMax - sliderModel.getCurrentMinimum() < sliderModel.getMinimumExtent()) {
                                translatedMax = sliderModel.getCurrentMinimum() + sliderModel.getMinimumExtent();
                            }
                        } else {
                            if (translatedMin > sliderModel.getMinimum()) {
                                translatedMin = sliderModel.getMinimum();
                            }
                            if (translatedMax < sliderModel.getMaximum()) {
                                translatedMax = sliderModel.getMaximum();
                            }
                            if (translatedMax > sliderModel.getUpperMinimumValue()) {
                                translatedMax = sliderModel.getUpperMinimumValue();
                            }
                            if (translatedMax < sliderModel.getUpperMaximumValue()) {
                                translatedMax = sliderModel.getUpperMaximumValue();
                            }
                            if (translatedMin > sliderModel.getLowerMinimumValue()) {
                                translatedMin = sliderModel.getLowerMinimumValue();
                            }
                            if (translatedMin < sliderModel.getLowerMaximumValue()) {
                                translatedMin = sliderModel.getLowerMaximumValue();
                            }
                            if (sliderModel.getCurrentMaximum() - translatedMin > sliderModel.getMaximumExtent()) {
                                translatedMin = sliderModel.getCurrentMaximum() - sliderModel.getMaximumExtent();
                            }
                            if (sliderModel.getCurrentMaximum() - translatedMin < sliderModel.getMinimumExtent()) {
                                translatedMin = sliderModel.getCurrentMaximum() - sliderModel.getMinimumExtent();
                            }
                        }
                        changed = !symetric ? SimpleRangeSliderController.this.setValues(sliderModel, sliderModel.getCurrentMinimum(), translatedMax) : SimpleRangeSliderController.this.setValues(sliderModel, translatedMin, translatedMax);
                    }
                    if (changed) {
                        SimpleRangeSliderController.this.savedX = e.getX();
                        SimpleRangeSliderController.this.savedY = e.getY();
                    }
                }
            }
        });
    }

    private boolean setValues(RangeSliderModel model, double translatedMin, double translatedMax) {
        if (model.getCurrentMinimum() != translatedMin || model.getCurrentMaximum() != translatedMax) {
            model.setValues((Object)this, translatedMin, translatedMax);
            return true;
        }
        return false;
    }
}

