/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.shadow.com.formdev.flatlaf.ui;

import com.install4j.shadow.com.formdev.flatlaf.util.LoggingFacade;
import com.install4j.shadow.com.formdev.flatlaf.util.NativeLibrary;
import com.install4j.shadow.com.formdev.flatlaf.util.SystemInfo;
import java.io.File;

class FlatNativeLibrary {
    private static NativeLibrary nativeLibrary;

    FlatNativeLibrary() {
    }

    static synchronized boolean isLoaded() {
        FlatNativeLibrary.initialize();
        return nativeLibrary != null ? nativeLibrary.isLoaded() : false;
    }

    private static void initialize() {
        String libraryName;
        if (nativeLibrary != null) {
            return;
        }
        if (SystemInfo.isWindows_10_orLater && (SystemInfo.isX86 || SystemInfo.isX86_64)) {
            libraryName = "flatlaf-windows-x86";
            if (SystemInfo.isX86_64) {
                libraryName = libraryName + "_64";
            }
            if (!SystemInfo.isJava_9_orLater) {
                FlatNativeLibrary.loadJAWT();
            }
        } else if (SystemInfo.isLinux && SystemInfo.isX86_64) {
            libraryName = "flatlaf-linux-x86_64";
            FlatNativeLibrary.loadJAWT();
        } else {
            return;
        }
        nativeLibrary = FlatNativeLibrary.createNativeLibrary(libraryName);
    }

    private static NativeLibrary createNativeLibrary(String libraryName) {
        String libraryPath = System.getProperty("flatlaf.nativeLibraryPath");
        if (libraryPath != null) {
            File libraryFile = new File(libraryPath, System.mapLibraryName(libraryName));
            if (libraryFile.exists()) {
                return new NativeLibrary(libraryFile, true);
            }
            LoggingFacade.INSTANCE.logSevere("Did not find external library " + libraryFile + ", using extracted library instead", null);
        }
        return new NativeLibrary("com/install4j/shadow/com/formdev/flatlaf/natives/" + libraryName, null, true);
    }

    private static void loadJAWT() {
        try {
            System.loadLibrary("jawt");
        }
        catch (UnsatisfiedLinkError ex) {
            String message = ex.getMessage();
            if (message == null || !message.contains("already loaded in another classloader")) {
                LoggingFacade.INSTANCE.logSevere(null, ex);
            }
        }
        catch (Exception ex) {
            LoggingFacade.INSTANCE.logSevere(null, ex);
        }
    }
}

