/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.molap.dataframe;

import com.macrofocus.common.annotations.GwtIncompatible;
import com.macrofocus.common.collection.PluggableCollectionFactory;
import com.macrofocus.filter.MutableFilter;
import com.macrofocus.molap.aggregates.AggregateDataFrame;
import com.macrofocus.molap.aggregates.aggregation.Aggregation;
import com.macrofocus.molap.aggregates.aggregation.CentroidAggregation;
import com.macrofocus.molap.aggregates.aggregation.ConstantAggregation;
import com.macrofocus.molap.aggregates.aggregation.CountAggregation;
import com.macrofocus.molap.aggregates.aggregation.CountDistinctAggregation;
import com.macrofocus.molap.aggregates.aggregation.CountDistinctWithNullAggregation;
import com.macrofocus.molap.aggregates.aggregation.DataFrameAggregation;
import com.macrofocus.molap.aggregates.aggregation.DistributiveStatisticsAggregation;
import com.macrofocus.molap.aggregates.aggregation.FirstAggregation;
import com.macrofocus.molap.aggregates.aggregation.FirstQuartileAggregation;
import com.macrofocus.molap.aggregates.aggregation.MaxAggregation;
import com.macrofocus.molap.aggregates.aggregation.MeanAggregation;
import com.macrofocus.molap.aggregates.aggregation.MedianAggregation;
import com.macrofocus.molap.aggregates.aggregation.MinAggregation;
import com.macrofocus.molap.aggregates.aggregation.RandomAggregation;
import com.macrofocus.molap.aggregates.aggregation.StdDevAggregation;
import com.macrofocus.molap.aggregates.aggregation.SumAggregation;
import com.macrofocus.molap.aggregates.aggregation.ThirdQuartileAggregation;
import com.macrofocus.molap.aggregates.aggregation.UnivariateStatisticsAggregation;
import com.macrofocus.molap.aggregates.aggregation.VarianceAggregation;
import com.macrofocus.molap.aggregates.cube.Cube;
import com.macrofocus.molap.aggregates.cube.InMemoryCube;
import com.macrofocus.molap.aggregates.cube.UnivariateStatistics;
import com.macrofocus.molap.aggregates.query.CuboidQuery;
import com.macrofocus.molap.aggregates.query.QueryDataFrame;
import com.macrofocus.molap.dataframe.AppendAndReindexDataFrame;
import com.macrofocus.molap.dataframe.AppendDataFrame;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.DataFrameEvent;
import com.macrofocus.molap.dataframe.DataFrameListener;
import com.macrofocus.molap.dataframe.FilterDataFrame;
import com.macrofocus.molap.dataframe.MutableDataFrame;
import com.macrofocus.molap.dataframe.ReIndexRecipe;
import com.macrofocus.molap.dataframe.ReIndexedDataFrame;
import com.macrofocus.molap.dataframe.ReMappedDataFrame;
import com.macrofocus.molap.dataframe.ReMappedRecipe;
import com.macrofocus.molap.dataframe.SortKey;
import com.macrofocus.molap.index.DefaultUniqueIndex;
import com.macrofocus.molap.index.IntegerRangeUniqueIndex;
import com.macrofocus.molap.index.MultiKey;
import com.macrofocus.molap.index.UniqueIndex;
import com.macrofocus.molap.series.AbstractSeries;
import com.macrofocus.molap.series.Series;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public abstract class AbstractDataFrame<Row, Column, V>
implements DataFrame<Row, Column, V> {
    private final List<DataFrameListener<Row, Column>> a = PluggableCollectionFactory.getInstance().copyOnWriteArrayList();
    private final Map<Column, UnivariateStatistics> b = new HashMap<Column, UnivariateStatistics>();
    private Cube c = null;

    protected AbstractDataFrame() {
    }

    @Override
    public Iterable<Row> rows() {
        return this.getRowIndex().keys();
    }

    @Override
    public Iterable<Column> columns() {
        return this.getColumnIndex().keys();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Row getRowKey(int index) {
        void var1_1;
        return (Row)this.getRowIndex().getKey((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Column getColumnKey(int index) {
        void var1_1;
        return (Column)this.getColumnIndex().getKey((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getRowAddress(Row row) {
        void var1_1;
        return this.getRowIndex().getAddress(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getColumnAddress(Column column) {
        void var1_1;
        return this.getColumnIndex().getAddress(var1_1);
    }

    @Override
    public int getRowCount() {
        return this.getRowIndex().getSize();
    }

    @Override
    public int getColumnCount() {
        return this.getColumnIndex().getSize();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Series<Row, V> getColumn(Column column) {
        void var1_1;
        return new ColumnSeries(this, var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DataFrame<Row, Column, V> orderRows(SortKey<Column> ... sortKeys) {
        void var1_1;
        return new ReMappedDataFrame(this, new e(this, var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <C> DataFrame<Row, C, V> reindexColumns(C ... columns) {
        void var1_1;
        return new ReIndexedDataFrame(this, new b(this, var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DataFrame<Row, Column, V> remapColumns(Column ... columns) {
        void var1_1;
        return new ReMappedDataFrame(this, new c(this, var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DataFrame<Row, Column, V> removeColumns(Column ... columns) {
        void var1_1;
        return new ReMappedDataFrame(this, new g(this, var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DataFrame<Row, Column, V> append(DataFrame<Row, Column, V> dataFrame) {
        void var1_1;
        return new AppendDataFrame(this, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DataFrame<Integer, Column, V> appendAndReindex(DataFrame<Row, Column, V> dataFrame) {
        void var1_1;
        return new AppendAndReindexDataFrame(this, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public FilterDataFrame filter(MutableFilter<Row> filter) {
        void var1_1;
        return new FilterDataFrame(this, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DataFrame<Row, Column, V> removeDuplicates(Column ... columns) {
        void var1_1;
        return new ReMappedDataFrame(this, new f(this, var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public UnivariateStatistics getStatistics(Column column) {
        void var1_1;
        if (this.b.containsKey(column)) {
            return this.b.get(column);
        }
        UnivariateStatistics univariateStatistics = new UnivariateStatistics(this.rows(), this.getColumn(column));
        this.b.put(var1_1, univariateStatistics);
        return univariateStatistics;
    }

    protected Cube getCube() {
        if (this.c == null) {
            this.c = new InMemoryCube(this);
        }
        return this.c;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public AggregateDataFrame<Column> aggregate(Aggregation ... aggregations) {
        void var1_1;
        return this.aggregate(true, (Aggregation[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public AggregateDataFrame<Column> aggregate(boolean includeIndex, Aggregation ... aggregations) {
        void var1_1;
        void var2_2;
        return new QueryDataFrame(new CuboidQuery(this.getCube().getApexCuboid(), (Aggregation[])var2_2), (boolean)var1_1);
    }

    @Override
    public DataFrameAggregation getDataFrameAggregation() {
        return new DataFrameAggregation();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public FirstAggregation getFirst(Column column) {
        void var1_1;
        return new FirstAggregation(this.getColumn(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ConstantAggregation getConstant(Object value) {
        void var1_1;
        return new ConstantAggregation(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public RandomAggregation getRandom(double min, double max) {
        void var3_2;
        void var1_1;
        return new RandomAggregation((double)var1_1, (double)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SumAggregation getSum(Column column) {
        void var1_1;
        return new SumAggregation(this.getColumn(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CountAggregation getCount(Column column) {
        void var1_1;
        return new CountAggregation(this.getColumn(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DistributiveStatisticsAggregation getDistributiveStatistics(Column column) {
        void var1_1;
        return new DistributiveStatisticsAggregation(this.getColumn(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MinAggregation getMin(Column column) {
        void var1_1;
        return new MinAggregation(this.getColumn(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MaxAggregation getMax(Column column) {
        void var1_1;
        return new MaxAggregation(this.getColumn(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MeanAggregation getMean(Column column) {
        void var1_1;
        return new MeanAggregation(this.getColumn(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public VarianceAggregation getVariance(Column column) {
        void var1_1;
        return new VarianceAggregation(this.getColumn(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public VarianceAggregation getVarianceByPopulation(Column column, Column population) {
        void var2_2;
        void var1_1;
        return new VarianceAggregation(this.getColumn(var1_1), this.getColumn(var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public StdDevAggregation getStdDev(Column column) {
        void var1_1;
        return new StdDevAggregation(this.getColumn(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public UnivariateStatisticsAggregation getUnivariateStatistics(Column column) {
        void var1_1;
        return new UnivariateStatisticsAggregation(this.getColumn(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MedianAggregation getMedian(Column column) {
        void var1_1;
        return new MedianAggregation(this.getColumn(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public FirstQuartileAggregation getFirstQuartile(Column column) {
        void var1_1;
        return new FirstQuartileAggregation(this.getColumn(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ThirdQuartileAggregation getThirdQuartile(Column column) {
        void var1_1;
        return new ThirdQuartileAggregation(this.getColumn(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Aggregation getWeightedSum(Column weight, Column column) {
        void var1_1;
        void var2_2;
        return new SumAggregation(this.getColumn(var2_2).multiply(this.getColumn(var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Aggregation getWeightedMean(Column weight, Column column) {
        void var1_1;
        void var2_2;
        return this.getWeightedSum(weight, var2_2).divide(this.getSum(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CountDistinctAggregation getCountDistinct(Column column) {
        void var1_1;
        return new CountDistinctAggregation(this.getColumn(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CountDistinctWithNullAggregation getCountDistinctWithNull(Column column) {
        void var1_1;
        return new CountDistinctWithNullAggregation(this.getColumn(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CentroidAggregation getCentroid(Column column) {
        void var1_1;
        return new CentroidAggregation(this.getColumn(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getColumnName(Column column) {
        if (column != null) {
            void var1_1;
            return var1_1.toString();
        }
        return null;
    }

    @Override
    @GwtIncompatible
    public void printSchema() {
        PrintStream printStream = System.out;
        for (Object object : this.columns()) {
            printStream.printf("%20s", AbstractDataFrame.a(this.getColumnName(object), 19));
            printStream.print(": ");
            object = this.getColumnClass(object);
            printStream.printf("%20s", AbstractDataFrame.a(object != null ? ((Class)object).getSimpleName() : "", 19));
            printStream.println();
        }
    }

    @Override
    @GwtIncompatible
    public void print() {
        PrintStream printStream = System.out;
        printStream.printf("%10s", AbstractDataFrame.a("<Index>", 9));
        for (Object object : this.columns()) {
            printStream.printf("%20s", AbstractDataFrame.a(this.getColumnName(object), 19));
        }
        printStream.println();
        printStream.printf("%10s", "", 9);
        for (Object object : this.columns()) {
            Class clazz = this.getColumnClass(object);
            printStream.printf("%20s", AbstractDataFrame.a(clazz != null ? clazz.getSimpleName() : "", 19));
        }
        printStream.println();
        for (Object object : this.rows()) {
            printStream.printf("%10s", AbstractDataFrame.a(object.toString(), 9));
            for (Object object2 : this.columns()) {
                if ((object2 = this.getValueAt(object, object2)) != null) {
                    if (object2 instanceof Number) {
                        printStream.printf("%20s", AbstractDataFrame.a(DecimalFormat.getNumberInstance().format(object2), 19));
                        continue;
                    }
                    printStream.printf("%20s", AbstractDataFrame.a(object2.toString(), 19));
                    continue;
                }
                printStream.printf("%20s", "(null)", 19);
            }
            printStream.println();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @GwtIncompatible
    public void print(PrintStream out, String caption, boolean html) {
        void var1_1;
        String string;
        void var2_2;
        int n2;
        if (!html) {
            String string2;
            if (caption != null) {
                System.out.println(caption);
            }
            int n3 = this.getColumnCount();
            for (n2 = 0; n2 < n3; ++n2) {
                AbstractDataFrame abstractDataFrame = this;
                String string3 = abstractDataFrame.getColumnName(abstractDataFrame.getColumnKey(n2));
                string2 = string3 != null ? string3 : "n.a.";
                out.printf("%20s", AbstractDataFrame.a(string2, 19));
            }
            out.println();
            for (n2 = 0; n2 < this.getRowCount(); ++n2) {
                for (int i2 = 0; i2 < n3; ++i2) {
                    AbstractDataFrame abstractDataFrame = this;
                    string2 = abstractDataFrame.getValueAt(abstractDataFrame.getRowKey(n2), this.getColumnKey(i2));
                    String string4 = string2 != null ? string2.toString() : "n.a.";
                    out.printf("%20s", AbstractDataFrame.a(string4, 19));
                }
                out.println();
            }
            return;
        }
        out.println("<table style=\"width: auto; border-collapse: separate;\">");
        if (var2_2 != null) {
            out.println("<caption>" + (String)var2_2 + "</caption>");
        }
        out.println("<tbody>");
        out.println("<tr>");
        int n4 = this.getColumnCount();
        for (n2 = 0; n2 < n4; ++n2) {
            AbstractDataFrame abstractDataFrame = this;
            String string5 = abstractDataFrame.getColumnName(abstractDataFrame.getColumnKey(n2));
            string = string5 != null ? string5 : "n.a.";
            out.print("<th>");
            out.print(string);
            out.println("</th>");
        }
        out.println("</tr>");
        for (n2 = 0; n2 < this.getRowCount(); ++n2) {
            out.println("<tr>");
            for (int i3 = 0; i3 < n4; ++i3) {
                AbstractDataFrame abstractDataFrame = this;
                string = abstractDataFrame.getValueAt(abstractDataFrame.getRowKey(n2), this.getColumnKey(i3));
                String string6 = string != null ? string.toString() : "n.a.";
                if (string instanceof Number) {
                    out.print("<td align=\"right\">");
                } else {
                    out.print("<td>");
                }
                out.print(string6);
                out.println("</td>");
            }
            out.println("</tr>");
        }
        out.println("</tbody>");
        var1_1.println("</table>");
    }

    private static String a(String string, int n2) {
        if (string == null) {
            return null;
        }
        if (string.length() <= n2) {
            return string;
        }
        return string.substring(0, n2 - 3) + "...";
    }

    @Override
    public void benchmark() {
        long l2 = System.currentTimeMillis();
        for (int i2 = 0; i2 < 100; ++i2) {
            for (Object object : this.columns()) {
                object = this.getColumn(object);
                for (Row Row2 : this.rows()) {
                    object.get(Row2);
                }
            }
        }
        System.out.println("Benchmark: " + (System.currentTimeMillis() - l2) + " ms");
    }

    @Override
    public DataFrame<Integer, Column, V> reindexRows() {
        return new ReIndexedDataFrame(this, new d(this, 0));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MutableDataFrame<V, Column, V> reindexRowsUsingColumn(Column column) {
        void var1_1;
        return this.reindexRowsUsingColumnDefault(true, (Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MutableDataFrame<V, Column, V> reindexRowsUsingColumnDefault(boolean keepColumn, Column column) {
        void var1_1;
        void var2_2;
        return new ReIndexedDataFrame(this, new a(this, var2_2, (boolean)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DataFrame<MultiKey, Column, V> reindexRowsUsingColumns(Column ... columns) {
        void var1_1;
        return this.reindexRowsDefault(true, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DataFrame<MultiKey, Column, V> reindexRowsDefault(boolean keepColumns, Column ... columns) {
        void var2_2;
        void var1_1;
        return new ReIndexedDataFrame(this, new h(this, (boolean)var1_1, var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addDataFrameListener(DataFrameListener<Row, Column> listener) {
        List<DataFrameListener<Row, Column>> list = this.a;
        synchronized (list) {
            void var1_1;
            this.a.add((DataFrameListener<Row, Column>)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addWeakDataFrameListener(DataFrameListener<Row, Column> listener) {
        List<DataFrameListener<Row, Column>> list = this.a;
        synchronized (list) {
            void var1_1;
            this.a.add(new j(this, var1_1));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeDataFrameListener(DataFrameListener<Row, Column> listener) {
        List<DataFrameListener<Row, Column>> list = this.a;
        synchronized (list) {
            if (listener instanceof j) {
                boolean bl = this.a.remove(listener);
                assert (bl) : listener;
            } else {
                DataFrameListener<Row, Column> dataFrameListener = null;
                for (DataFrameListener<Row, Column> dataFrameListener2 : this.a) {
                    DataFrameListener<Object, Object> dataFrameListener3 = dataFrameListener2 instanceof j ? ((j)dataFrameListener2).a() : dataFrameListener2;
                    if (!listener.equals(dataFrameListener3)) continue;
                    dataFrameListener = dataFrameListener2;
                }
                if (dataFrameListener != null) {
                    boolean bl = this.a.remove(dataFrameListener);
                    if (!d && !bl) {
                        void var1_1;
                        throw new AssertionError(var1_1);
                    }
                }
            }
            return;
        }
    }

    @Override
    public void removeDataFrameListeners() {
        List<DataFrameListener<Row, Column>> list = this.a;
        synchronized (list) {
            this.a.clear();
            return;
        }
    }

    protected void notifyDataFrameChanged(DataFrameEvent<Row, Column> event) {
        this.b.clear();
        for (DataFrameListener<Row, Column> dataFrameListener : this.a) {
            dataFrameListener.dataFrameChanged(event);
        }
    }

    final class h
    implements ReIndexRecipe<MultiKey, Column> {
        private final boolean a;
        private final Column[] b;
        private /* synthetic */ AbstractDataFrame c;

        public h(AbstractDataFrame abstractDataFrame, boolean bl, Column ... ColumnArray) {
            this.c = abstractDataFrame;
            this.a = bl;
            this.b = ColumnArray;
        }

        @Override
        public final UniqueIndex<MultiKey> buildRowIndex() {
            int n2 = 0;
            MultiKey[] multiKeyArray = new MultiKey[this.c.getRowCount()];
            for (Object Row2 : this.c.rows()) {
                Object[] objectArray = new Object[this.b.length];
                int n3 = 0;
                Object object = this.b;
                int n4 = this.b.length;
                for (int i2 = 0; i2 < n4; ++i2) {
                    Object Column2 = object[i2];
                    objectArray[n3++] = this.c.getValueAt(Row2, Column2);
                }
                object = new MultiKey(objectArray);
                multiKeyArray[n2++] = object;
            }
            DefaultUniqueIndex<MultiKey> defaultUniqueIndex = DefaultUniqueIndex.fromArray(multiKeyArray);
            return defaultUniqueIndex;
        }

        @Override
        public final UniqueIndex<Column> buildColumnIndex() {
            if (this.a) {
                return this.c.getColumnIndex();
            }
            return this.c.getColumnIndex().difference(DefaultUniqueIndex.fromArray(this.b));
        }
    }

    final class a
    implements ReIndexRecipe<V, Column> {
        private final Column a;
        private final boolean b;
        private /* synthetic */ AbstractDataFrame c;

        public a(AbstractDataFrame abstractDataFrame, Column Column2, boolean bl) {
            this.c = abstractDataFrame;
            this.a = Column2;
            this.b = bl;
        }

        @Override
        public final UniqueIndex<V> buildRowIndex() {
            int n2 = 0;
            Object[] objectArray = new Object[this.c.getRowCount()];
            for (Object Row2 : this.c.rows()) {
                objectArray[n2++] = this.c.getValueAt(Row2, this.a);
            }
            DefaultUniqueIndex<Object> defaultUniqueIndex = new DefaultUniqueIndex<Object>(objectArray);
            return defaultUniqueIndex;
        }

        @Override
        public final UniqueIndex<Column> buildColumnIndex() {
            if (this.b) {
                return this.c.getColumnIndex();
            }
            return this.c.getColumnIndex().difference(new DefaultUniqueIndex<Object>(this.a));
        }
    }

    final class d
    implements ReIndexRecipe<Integer, Column> {
        private /* synthetic */ AbstractDataFrame a;

        private d(AbstractDataFrame abstractDataFrame) {
            this.a = abstractDataFrame;
        }

        @Override
        public final UniqueIndex<Integer> buildRowIndex() {
            IntegerRangeUniqueIndex integerRangeUniqueIndex = new IntegerRangeUniqueIndex(0, this.a.getRowCount() - 1);
            return integerRangeUniqueIndex;
        }

        @Override
        public final UniqueIndex<Column> buildColumnIndex() {
            return this.a.getColumnIndex();
        }

        /* synthetic */ d(AbstractDataFrame abstractDataFrame, byte by) {
            this(abstractDataFrame);
        }
    }

    final class f
    implements ReMappedRecipe<Row, Column> {
        private final Column[] a;
        private /* synthetic */ AbstractDataFrame b;

        public f(AbstractDataFrame abstractDataFrame, Column ... ColumnArray) {
            this.b = abstractDataFrame;
            this.a = ColumnArray;
        }

        @Override
        public final UniqueIndex<Row> buildRowIndex() {
            ArrayList arrayList = new ArrayList();
            HashSet<Column[]> hashSet = new HashSet<Column[]>();
            for (Object Row2 : this.b.rows()) {
                Object[] objectArray = new Object[this.a.length];
                int n2 = 0;
                Object object = this.a;
                int n3 = this.a.length;
                for (int i2 = 0; i2 < n3; ++i2) {
                    Object Column2 = object[i2];
                    objectArray[n2++] = this.b.getValueAt(Row2, Column2);
                }
                object = new MultiKey(objectArray);
                if (hashSet.contains(object)) continue;
                arrayList.add(Row2);
                hashSet.add((Column[])object);
            }
            return DefaultUniqueIndex.fromArray(arrayList.toArray());
        }

        @Override
        public final UniqueIndex<Column> buildColumnIndex() {
            return this.b.getColumnIndex();
        }
    }

    final class g
    implements ReMappedRecipe<Row, Column> {
        private final Column[] a;
        private /* synthetic */ AbstractDataFrame b;

        public g(AbstractDataFrame abstractDataFrame, Column ... ColumnArray) {
            this.b = abstractDataFrame;
            this.a = ColumnArray;
        }

        @Override
        public final UniqueIndex<Row> buildRowIndex() {
            return this.b.getRowIndex();
        }

        @Override
        public final UniqueIndex<Column> buildColumnIndex() {
            return this.b.getColumnIndex().difference(new DefaultUniqueIndex(this.a));
        }
    }

    final class c
    implements ReMappedRecipe<Row, Column> {
        private final Column[] a;
        private /* synthetic */ AbstractDataFrame b;

        public c(AbstractDataFrame abstractDataFrame, Column ... ColumnArray) {
            this.b = abstractDataFrame;
            this.a = ColumnArray;
        }

        @Override
        public final UniqueIndex<Row> buildRowIndex() {
            return this.b.getRowIndex();
        }

        @Override
        public final UniqueIndex<Column> buildColumnIndex() {
            return DefaultUniqueIndex.fromArray(this.a);
        }
    }

    final class e
    implements ReMappedRecipe<Row, Column> {
        private final SortKey<Column>[] a;
        private /* synthetic */ AbstractDataFrame b;

        public e(AbstractDataFrame abstractDataFrame, SortKey<Column> ... sortKeyArray) {
            this.b = abstractDataFrame;
            this.a = sortKeyArray;
        }

        @Override
        public final UniqueIndex<Row> buildRowIndex() {
            return new DefaultUniqueIndex(this.b.getRowIndex(), new i(this.b, this.a));
        }

        @Override
        public final UniqueIndex<Column> buildColumnIndex() {
            return this.b.getColumnIndex();
        }
    }

    final class b<C>
    implements ReIndexRecipe<Row, C> {
        private final C[] a;
        private /* synthetic */ AbstractDataFrame b;

        public b(AbstractDataFrame abstractDataFrame, C ... CArray) {
            this.b = abstractDataFrame;
            this.a = CArray;
        }

        @Override
        public final UniqueIndex<Row> buildRowIndex() {
            return this.b.getRowIndex();
        }

        @Override
        public final UniqueIndex<C> buildColumnIndex() {
            return DefaultUniqueIndex.fromArray(this.a);
        }
    }

    final class i
    implements Comparator<Row> {
        private final SortKey<Column>[] a;
        private /* synthetic */ AbstractDataFrame b;

        public i(AbstractDataFrame abstractDataFrame, SortKey<Column> ... sortKeyArray) {
            this.b = abstractDataFrame;
            this.a = sortKeyArray;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int compare(Row o1, Row o2) {
            void var2_2;
            void var1_1;
            SortKey<Column>[] sortKeyArray = this.a;
            int n2 = this.a.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object = sortKeyArray[i2];
                if ((object = object.compare(this.b, o1, o2)) == null || (Integer)object == 0) continue;
                return (Integer)object;
            }
            int n3 = this.b.getRowAddress(var1_1);
            if (n3 < (n2 = this.b.getRowAddress(var2_2))) {
                return -1;
            }
            if (n3 == n2) {
                return 0;
            }
            return 1;
        }
    }

    public class ColumnSeries
    extends AbstractSeries<Row, V> {
        private Column a;
        private /* synthetic */ AbstractDataFrame c;

        /*
         * WARNING - void declaration
         */
        private ColumnSeries(AbstractDataFrame this$0, Column column) {
            void var2_2;
            void var1_1;
            this.c = var1_1;
            assert (column != null);
            this.a = var2_2;
        }

        @Override
        public Object getName() {
            return this.a;
        }

        @Override
        public Class getType() {
            return this.c.getColumnClass(this.a);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V get(Row key) {
            void var1_1;
            return this.c.getValueAt(var1_1, this.a);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Row getKey(int i2) {
            void var1_1;
            return this.c.getRowIndex().getKey((int)var1_1);
        }

        @Override
        public int size() {
            return this.c.getRowIndex().getSize();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int getAddress(Row key) {
            void var1_1;
            return this.c.getRowAddress(var1_1);
        }

        @Override
        public Iterable<Row> keys() {
            return this.c.getRowIndex().keys();
        }

        @Override
        public <L> Series<L, V> reindex(L ... keys) {
            return null;
        }

        @Override
        public Series<Row, V> head(int count) {
            return null;
        }

        @Override
        public Series<Row, V> tail(int count) {
            return null;
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ ColumnSeries(AbstractDataFrame x0, Object x1, byte by) {
            this((AbstractDataFrame)var1_1, var2_2);
            void var2_2;
            void var1_1;
        }
    }

    final class j<R, K>
    implements DataFrameListener<R, K> {
        private final WeakReference<DataFrameListener<R, K>> a;
        private /* synthetic */ AbstractDataFrame b;

        public j(AbstractDataFrame abstractDataFrame, DataFrameListener<R, K> dataFrameListener) {
            this.b = abstractDataFrame;
            this.a = new WeakReference<DataFrameListener<R, K>>(dataFrameListener);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void dataFrameChanged(DataFrameEvent event) {
            DataFrameListener<R, K> dataFrameListener = this.a();
            if (dataFrameListener != null) {
                void var1_1;
                dataFrameListener.dataFrameChanged((DataFrameEvent<R, K>)var1_1);
                return;
            }
            this.b.removeDataFrameListener(this);
        }

        public final DataFrameListener<R, K> a() {
            return (DataFrameListener)this.a.get();
        }
    }
}

