/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.molap.dataframe;

import com.macrofocus.molap.dataframe.AbstractDataFrame;
import com.macrofocus.molap.dataframe.ArcGISJsonDataFrame;
import com.macrofocus.molap.dataframe.CachedDataFrame;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.DataFrameFactory;
import com.macrofocus.molap.dataframe.IndexedDataFrame;
import com.macrofocus.molap.dataframe.JsonDataFrame;
import com.macrofocus.molap.index.DefaultUniqueIndex;
import com.macrofocus.molap.index.IntegerRangeUniqueIndex;
import com.macrofocus.molap.index.UniqueIndex;
import com.macrofocus.molap.series.Series;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonFactory;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.util.Random;

public abstract class AbstractDataFrameFactory
implements DataFrameFactory {
    /*
     * WARNING - void declaration
     */
    @Override
    public DataFrame<Integer, String, Double> createRandomDataFrame(int clusterCount, int rowCount, int columnCount) {
        void var2_2;
        int n2;
        Random random = new Random(0L);
        String[] stringArray = new String[columnCount];
        int n3 = 0;
        while (n3 < columnCount) {
            int n4 = n3++;
            stringArray[n4] = Integer.toString(n4);
        }
        double[][] dArray = new double[clusterCount][columnCount];
        for (int i2 = 0; i2 < clusterCount; ++i2) {
            for (n2 = 0; n2 < columnCount; ++n2) {
                dArray[i2][n2] = random.nextDouble();
            }
        }
        Double[][] doubleArray = new Double[rowCount][columnCount];
        for (n2 = 0; n2 < rowCount; ++n2) {
            int n5 = Math.abs(random.nextInt() % clusterCount);
            for (int i3 = 0; i3 < columnCount; ++i3) {
                double d2 = dArray[n5][i3];
                doubleArray[n2][i3] = d2 + random.nextGaussian() / 30.0;
            }
        }
        return new AbstractDataFrame<Integer, String, Double>(this, doubleArray, (int)var2_2, stringArray){
            private UniqueIndex<Integer> a = null;
            private UniqueIndex<String> b = null;
            private /* synthetic */ Double[][] c;
            private /* synthetic */ int d;
            private /* synthetic */ String[] e;
            {
                this.c = doubleArray;
                this.d = n2;
                this.e = stringArray;
            }

            @Override
            public final UniqueIndex<Integer> getRowIndex() {
                if (this.a == null) {
                    this.a = new IntegerRangeUniqueIndex(0, this.d - 1);
                }
                return this.a;
            }

            @Override
            public final UniqueIndex<String> getColumnIndex() {
                if (this.b == null) {
                    String[] stringArray = new String[this.e.length];
                    for (int i2 = 0; i2 < this.e.length; ++i2) {
                        stringArray[i2] = this.e[i2];
                    }
                    this.b = new DefaultUniqueIndex<String>(stringArray);
                }
                return this.b;
            }

            @Override
            public final int getRowCount() {
                return this.d;
            }

            @Override
            public final /* synthetic */ Object getValueAt(Object object, Object object2) {
                String string = (String)object2;
                object2 = (Integer)object;
                object = this;
                return object.c[object.getRowIndex().getAddress((Integer)object2)][object.getColumnIndex().getAddress(string)];
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DataFrame<Integer, String, Object> fromJsonString(String json) {
        void var1_1;
        return this.fromJsonString("data", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DataFrame<Integer, String, Object> fromJsonString(String name, String json) {
        void var1_1;
        JsonValue jsonValue;
        JsonFactory jsonFactory = Json.instance();
        jsonValue = jsonFactory.parse((String)jsonValue);
        return this.fromJsonValue(jsonValue, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public DataFrame<Integer, String, Object> fromJsonValue(JsonValue root, String name) {
        void var1_1;
        if (root instanceof JsonObject) {
            JsonArray jsonArray;
            if ((jsonArray = (JsonArray)((JsonObject)root).get((String)jsonArray)) != null) {
                return new JsonDataFrame(jsonArray);
            }
            jsonArray = (JsonArray)((JsonObject)root).get("features");
            if (jsonArray != null) {
                return new ArcGISJsonDataFrame(jsonArray, (JsonArray)((JsonObject)root).get("fields"));
            }
            return null;
        }
        return new JsonDataFrame((JsonArray)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public <R, C, V> DataFrame<R, C, V> fromDataFrame(DataFrame<R, C, V> dataFrame) {
        void var1_1;
        return new CachedDataFrame(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <R, V> DataFrame<R, Object, V> fromColumnSeries(Series<R, V> ... series) {
        void var1_1;
        return new IndexedDataFrame(var1_1);
    }
}

