/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.molap.dataframe;

import com.macrofocus.common.annotations.GwtIncompatible;
import com.macrofocus.filter.MutableFilter;
import com.macrofocus.molap.aggregates.AggregateDataFrame;
import com.macrofocus.molap.aggregates.aggregation.Aggregation;
import com.macrofocus.molap.aggregates.aggregation.ConstantAggregation;
import com.macrofocus.molap.aggregates.aggregation.CountAggregation;
import com.macrofocus.molap.aggregates.aggregation.CountDistinctAggregation;
import com.macrofocus.molap.aggregates.aggregation.CountDistinctWithNullAggregation;
import com.macrofocus.molap.aggregates.aggregation.DataFrameAggregation;
import com.macrofocus.molap.aggregates.aggregation.DistributiveStatisticsAggregation;
import com.macrofocus.molap.aggregates.aggregation.FirstAggregation;
import com.macrofocus.molap.aggregates.aggregation.FirstQuartileAggregation;
import com.macrofocus.molap.aggregates.aggregation.MaxAggregation;
import com.macrofocus.molap.aggregates.aggregation.MeanAggregation;
import com.macrofocus.molap.aggregates.aggregation.MedianAggregation;
import com.macrofocus.molap.aggregates.aggregation.MinAggregation;
import com.macrofocus.molap.aggregates.aggregation.StdDevAggregation;
import com.macrofocus.molap.aggregates.aggregation.SumAggregation;
import com.macrofocus.molap.aggregates.aggregation.ThirdQuartileAggregation;
import com.macrofocus.molap.aggregates.aggregation.UnivariateStatisticsAggregation;
import com.macrofocus.molap.aggregates.aggregation.VarianceAggregation;
import com.macrofocus.molap.aggregates.cube.UnivariateStatistics;
import com.macrofocus.molap.dataframe.DataFrameListener;
import com.macrofocus.molap.dataframe.FilterDataFrame;
import com.macrofocus.molap.dataframe.SortKey;
import com.macrofocus.molap.index.MultiKey;
import com.macrofocus.molap.index.UniqueIndex;
import com.macrofocus.molap.series.Series;
import java.io.PrintStream;

public interface DataFrame<Row, Column, V> {
    public String getColumnName(Column var1);

    public Class getRowClass(Row var1);

    public Class getColumnClass(Column var1);

    public V getValueAt(Row var1, Column var2);

    public Series<Column, ?> getRow(Row var1);

    public Series<Row, V> getColumn(Column var1);

    public Iterable<Row> rows();

    public Iterable<Column> columns();

    public Row getRowKey(int var1);

    public Column getColumnKey(int var1);

    public int getRowAddress(Row var1);

    public int getColumnAddress(Column var1);

    public int getRowCount();

    public int getColumnCount();

    public DataFrame<Integer, Column, V> reindexRows();

    public DataFrame<V, Column, V> reindexRowsUsingColumn(Column var1);

    public DataFrame<V, Column, V> reindexRowsUsingColumnDefault(boolean var1, Column var2);

    public DataFrame<MultiKey, Column, V> reindexRowsUsingColumns(Column ... var1);

    public DataFrame<MultiKey, Column, V> reindexRowsDefault(boolean var1, Column ... var2);

    public <Column> DataFrame<Row, Column, V> reindexColumns(Column ... var1);

    public UniqueIndex<Row> getRowIndex();

    public UniqueIndex<Column> getColumnIndex();

    public DataFrame<Row, Column, V> orderRows(SortKey<Column> ... var1);

    public FilterDataFrame<Row, Column, V> filter(MutableFilter<Row> var1);

    public DataFrame<Row, Column, V> removeDuplicates(Column ... var1);

    public AggregateDataFrame<Column> aggregate(Aggregation ... var1);

    public AggregateDataFrame<Column> aggregate(boolean var1, Aggregation ... var2);

    public DataFrame<Row, Column, V> remapColumns(Column ... var1);

    public DataFrame<Row, Column, V> removeColumns(Column ... var1);

    public DataFrame<Row, Column, V> append(DataFrame<Row, Column, V> var1);

    public DataFrame<Integer, Column, V> appendAndReindex(DataFrame<Row, Column, V> var1);

    public DataFrame join(Series var1, Column[] var2);

    public UnivariateStatistics getStatistics(Column var1);

    public DataFrameAggregation getDataFrameAggregation();

    public FirstAggregation getFirst(Column var1);

    public ConstantAggregation getConstant(Object var1);

    public Aggregation getRandom(double var1, double var3);

    public SumAggregation getSum(Column var1);

    public CountAggregation getCount(Column var1);

    public DistributiveStatisticsAggregation getDistributiveStatistics(Column var1);

    public MinAggregation getMin(Column var1);

    public MaxAggregation getMax(Column var1);

    public MeanAggregation getMean(Column var1);

    public VarianceAggregation getVariance(Column var1);

    public VarianceAggregation getVarianceByPopulation(Column var1, Column var2);

    public StdDevAggregation getStdDev(Column var1);

    public UnivariateStatisticsAggregation getUnivariateStatistics(Column var1);

    public MedianAggregation getMedian(Column var1);

    public FirstQuartileAggregation getFirstQuartile(Column var1);

    public ThirdQuartileAggregation getThirdQuartile(Column var1);

    public Aggregation getWeightedSum(Column var1, Column var2);

    public Aggregation getWeightedMean(Column var1, Column var2);

    public CountDistinctAggregation getCountDistinct(Column var1);

    public CountDistinctWithNullAggregation getCountDistinctWithNull(Column var1);

    public Aggregation getCentroid(Column var1);

    @GwtIncompatible
    public void printSchema();

    @GwtIncompatible
    public void print();

    @GwtIncompatible
    public void print(PrintStream var1, String var2, boolean var3);

    public void benchmark();

    public void addDataFrameListener(DataFrameListener<Row, Column> var1);

    public void addWeakDataFrameListener(DataFrameListener<Row, Column> var1);

    public void removeDataFrameListener(DataFrameListener<Row, Column> var1);

    public void removeDataFrameListeners();
}

