/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.expression;

import java.util.Comparator;
import prefuse.data.Schema;
import prefuse.data.Tuple;
import prefuse.data.expression.BinaryExpression;
import prefuse.data.expression.Expression;
import prefuse.data.expression.Predicate;
import prefuse.util.TypeLib;
import prefuse.util.collections.DefaultLiteralComparator;
import prefuse.util.collections.LiteralComparator;

public class ComparisonPredicate
extends BinaryExpression
implements Predicate {
    public static final int LT = 0;
    public static final int GT = 1;
    public static final int EQ = 2;
    public static final int NEQ = 3;
    public static final int LTEQ = 4;
    public static final int GTEQ = 5;
    private Comparator a;

    /*
     * WARNING - void declaration
     */
    public ComparisonPredicate(int operation, Expression left, Expression right) {
        this((int)var1_1, (Expression)var2_2, (Expression)var3_3, DefaultLiteralComparator.getInstance());
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ComparisonPredicate(int operation, Expression left, Expression right, Comparator cmp) {
        super((int)var1_1, 0, 5, (Expression)var2_2, (Expression)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
        this.a = cmp;
    }

    public Comparator getComparator() {
        return this.a;
    }

    @Override
    public Class getType(Schema s2) {
        return Boolean.TYPE;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean getBoolean(Tuple t2) {
        void var1_1;
        int n2;
        Class clazz = this.m_left.getType(t2.getSchema());
        Class clazz2 = this.m_right.getType(t2.getSchema());
        if (TypeLib.isNumericType(clazz) && TypeLib.isNumericType(clazz2)) {
            if ((clazz = TypeLib.getNumericType(clazz, clazz2)) == Integer.TYPE || clazz == Byte.TYPE) {
                int n3 = this.m_left.getInt(t2);
                int n4 = this.m_right.getInt(t2);
                n2 = ((LiteralComparator)this.a).compare(n3, n4);
            } else if (clazz == Long.TYPE) {
                long l2 = this.m_left.getLong((Tuple)var1_1);
                long l3 = this.m_right.getLong((Tuple)var1_1);
                n2 = ((LiteralComparator)this.a).compare(l2, l3);
            } else if (clazz == Float.TYPE) {
                float f2 = this.m_left.getFloat((Tuple)var1_1);
                float f3 = this.m_right.getFloat((Tuple)var1_1);
                n2 = ((LiteralComparator)this.a).compare(f2, f3);
            } else {
                if (clazz != Double.TYPE) throw new IllegalStateException();
                double d2 = this.m_left.getDouble((Tuple)var1_1);
                double d3 = this.m_right.getDouble((Tuple)var1_1);
                n2 = ((LiteralComparator)this.a).compare(d2, d3);
            }
        } else {
            n2 = this.a.compare(this.m_left.get((Tuple)var1_1), this.m_right.get((Tuple)var1_1));
        }
        switch (this.m_op) {
            case 0: {
                return n2 == -1;
            }
            case 1: {
                return n2 == 1;
            }
            case 2: {
                return n2 == 0;
            }
            case 3: {
                return n2 != 0;
            }
            case 4: {
                return n2 <= 0;
            }
            case 5: {
                return n2 >= 0;
            }
        }
        throw new IllegalStateException("Unknown operation.");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object get(Tuple t2) {
        void var1_1;
        if (this.getBoolean((Tuple)var1_1)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public String toString() {
        String string = "?";
        switch (this.m_op) {
            case 0: {
                string = "<";
                break;
            }
            case 1: {
                string = ">";
                break;
            }
            case 2: {
                string = "=";
                break;
            }
            case 3: {
                string = "!=";
                break;
            }
            case 4: {
                string = "<=";
                break;
            }
            case 5: {
                string = ">=";
            }
        }
        return this.m_left.toString() + ' ' + string + ' ' + this.m_right.toString();
    }
}

