/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util;

public class ColorLib {
    public static final char HEX_PREFIX = '#';
    private static int a = 0;
    private static int b = 0;
    public static final float[] CATEGORY_HUES = new float[]{0.0f, 0.083333336f, 0.16666667f, 0.33333334f, 0.5f, 0.5833333f, 0.6666667f, 0.8333333f, 0.9166667f};
    public static final int DEFAULT_MAP_SIZE = 64;

    /*
     * WARNING - void declaration
     */
    public static int rgb(int r2, int g2, int b2) {
        void var2_2;
        void var1_1;
        return ColorLib.rgba(r2, (int)var1_1, (int)var2_2, 255);
    }

    public static int gray(int v2) {
        int n2;
        int n3 = v2;
        return ColorLib.rgba(n3, n3, n2, 255);
    }

    /*
     * WARNING - void declaration
     */
    public static int gray(int v2, int a2) {
        void var1_1;
        int n2;
        int n3 = v2;
        return ColorLib.rgba(n3, n3, n2, (int)var1_1);
    }

    public static int hex(String hex) {
        String string;
        if (hex.charAt(0) == '#') {
            hex = hex.substring(1);
        }
        if (hex.length() > 6) {
            int n2 = Integer.parseInt(hex.substring(2), 16);
            int n3 = Integer.parseInt(hex.substring(0, 2), 16);
            return ColorLib.setAlpha(n2, n3);
        }
        return ColorLib.setAlpha(Integer.parseInt(string, 16), 255);
    }

    /*
     * WARNING - void declaration
     */
    public static int HSBtoRGB(float hue, float saturation, float brightness) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (saturation == 0.0f) {
            n3 = n4 = (int)(brightness * 255.0f + 0.5f);
            n2 = n4;
        } else {
            float f2;
            float f3;
            float f4 = f3;
            f3 = (f4 - (float)Math.floor(f4)) * 6.0f;
            float f5 = f3 - (float)Math.floor(f3);
            float f6 = brightness * (1.0f - saturation);
            float f7 = brightness * (1.0f - saturation * f5);
            f2 = brightness * (1.0f - f2 * (1.0f - f5));
            switch ((int)f3) {
                case 0: {
                    n2 = (int)(brightness * 255.0f + 0.5f);
                    n3 = (int)(f2 * 255.0f + 0.5f);
                    n4 = (int)(f6 * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    n2 = (int)(f7 * 255.0f + 0.5f);
                    n3 = (int)(brightness * 255.0f + 0.5f);
                    n4 = (int)(f6 * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    n2 = (int)(f6 * 255.0f + 0.5f);
                    n3 = (int)(brightness * 255.0f + 0.5f);
                    n4 = (int)(f2 * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    n2 = (int)(f6 * 255.0f + 0.5f);
                    n3 = (int)(f7 * 255.0f + 0.5f);
                    n4 = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    n2 = (int)(f2 * 255.0f + 0.5f);
                    n3 = (int)(f6 * 255.0f + 0.5f);
                    n4 = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    void var2_2;
                    n2 = (int)(var2_2 * 255.0f + 0.5f);
                    n3 = (int)(f6 * 255.0f + 0.5f);
                    n4 = (int)(f7 * 255.0f + 0.5f);
                }
            }
        }
        return 0xFF000000 | n2 << 16 | n3 << 8 | n4;
    }

    /*
     * WARNING - void declaration
     */
    public static int hsb(float h2, float s2, float b2) {
        void var2_2;
        void var1_1;
        return ColorLib.HSBtoRGB(h2, (float)var1_1, (float)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static int hsba(float h2, float s2, float b2, float a2) {
        void var3_3;
        void var2_2;
        void var1_1;
        return ColorLib.setAlpha(ColorLib.HSBtoRGB(h2, (float)var1_1, (float)var2_2), (int)((double)(var3_3 * 255.0f) + 0.5) & 0xFF);
    }

    /*
     * WARNING - void declaration
     */
    public static int rgba(int r2, int g2, int b2, int a2) {
        void var2_2;
        void var1_1;
        int n2;
        return (a2 & 0xFF) << 24 | (n2 & 0xFF) << 16 | (var1_1 & 0xFF) << 8 | var2_2 & 0xFF;
    }

    /*
     * WARNING - void declaration
     */
    public static int rgba(float r2, float g2, float b2, float a2) {
        void var2_2;
        void var1_1;
        float f2;
        return ((int)((double)(a2 * 255.0f) + 0.5) & 0xFF) << 24 | ((int)((double)(f2 * 255.0f) + 0.5) & 0xFF) << 16 | ((int)((double)(var1_1 * 255.0f) + 0.5) & 0xFF) << 8 | (int)((double)(var2_2 * 255.0f) + 0.5) & 0xFF;
    }

    public static int red(int color) {
        return color >> 16 & 0xFF;
    }

    public static int green(int color) {
        return color >> 8 & 0xFF;
    }

    public static int blue(int color) {
        return color & 0xFF;
    }

    public static int alpha(int color) {
        return color >>> 24;
    }

    /*
     * WARNING - void declaration
     */
    public static int setAlpha(int c2, int alpha) {
        void var1_1;
        int n2;
        return ColorLib.rgba(ColorLib.red(c2), ColorLib.green(c2), ColorLib.blue(n2), (int)var1_1);
    }

    public static int getCacheMissCount() {
        return 0;
    }

    public static int getCacheLookupCount() {
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public static int interp(int c1, int c2, double frac) {
        int n2;
        void var1_1;
        void var2_2;
        double d2 = 1.0 - frac;
        return ColorLib.rgba((int)Math.round(frac * (double)ColorLib.red(c2) + d2 * (double)ColorLib.red(c1)), (int)Math.round(frac * (double)ColorLib.green(c2) + d2 * (double)ColorLib.green(c1)), (int)Math.round(frac * (double)ColorLib.blue(c2) + d2 * (double)ColorLib.blue(c1)), (int)Math.round((double)(var2_2 * (double)ColorLib.alpha((int)var1_1) + d2 * (double)ColorLib.alpha(n2))));
    }

    public static int darker(int c2) {
        int n2;
        return ColorLib.rgba(Math.max(0, (int)(0.7f * (float)ColorLib.red(c2))), Math.max(0, (int)(0.7f * (float)ColorLib.green(c2))), Math.max(0, (int)(0.7f * (float)ColorLib.blue(c2))), ColorLib.alpha(n2));
    }

    public static int brighter(int c2) {
        int n2;
        int n3 = ColorLib.red(c2);
        int n4 = ColorLib.green(c2);
        int n5 = ColorLib.blue(c2);
        if (n3 == 0 && n4 == 0 && n5 == 0) {
            return ColorLib.rgba(3, 3, 3, ColorLib.alpha(c2));
        }
        if (n3 > 0 && n3 < 3) {
            n3 = 3;
        }
        if (n4 > 0 && n4 < 3) {
            n4 = 3;
        }
        if (n5 > 0 && n5 < 3) {
            n5 = 3;
        }
        return ColorLib.rgba(Math.min(255, (int)((float)n3 / 0.7f)), Math.min(255, (int)((float)n4 / 0.7f)), Math.min(255, (int)((float)n5 / 0.7f)), ColorLib.alpha(n2));
    }

    public static int desaturate(int c2) {
        int n2;
        int n3 = c2 & 0xFF000000;
        float f2 = c2 >> 16 & 0xFF;
        float f3 = c2 >> 8 & 0xFF;
        float f4 = n2 & 0xFF;
        int n4 = Math.min((int)((f2 *= 0.2125f) + (f3 *= 0.7154f) + (f4 *= 0.0721f)), 255) & 0xFF;
        return n3 | n4 << 16 | n4 << 8 | n4;
    }

    /*
     * WARNING - void declaration
     */
    public static float[] RGBtoHSB(int r2, int g2, int b2, float[] hsbvals) {
        void var3_5;
        float f2;
        int n2;
        int n3;
        if (hsbvals == null) {
            hsbvals = new float[3];
        }
        int n4 = n3 = r2 > g2 ? r2 : g2;
        if (b2 > n3) {
            n3 = b2;
        }
        int n5 = n2 = r2 < g2 ? r2 : g2;
        if (b2 < n2) {
            n2 = b2;
        }
        float f3 = (float)n3 / 255.0f;
        float f4 = n3 != 0 ? (float)(n3 - n2) / (float)n3 : 0.0f;
        if (f4 == 0.0f) {
            f2 = 0.0f;
        } else {
            float f5;
            void var1_2;
            void var2_3;
            int n6;
            float f6 = (float)(n3 - n6) / (float)(n3 - n2);
            float f7 = (float)(n3 - g2) / (float)(n3 - n2);
            float f8 = (float)(n3 - var2_3) / (float)(n3 - n2);
            f2 = n6 == n3 ? f8 - f7 : (var1_2 == n3 ? f6 + 2.0f - f8 : f7 + 4.0f - f6);
            f2 /= 6.0f;
            if (f5 < 0.0f) {
                f2 += 1.0f;
            }
        }
        hsbvals[0] = f2;
        hsbvals[1] = f4;
        hsbvals[2] = f3;
        return var3_5;
    }

    /*
     * WARNING - void declaration
     */
    public static int saturate(int c2, float saturation) {
        void var1_2;
        int n2;
        float[] fArray = ColorLib.RGBtoHSB(ColorLib.red(c2), ColorLib.green(c2), ColorLib.blue(n2), null);
        return ColorLib.hsb(fArray[0], (float)var1_2, fArray[2]);
    }

    public static int[] getCoolPalette(int size) {
        int[] nArray = new int[size];
        for (int i2 = 0; i2 < size; ++i2) {
            float f2 = (float)i2 / Math.max((float)(size - 1), 1.0f);
            nArray[i2] = ColorLib.rgba(f2, 1.0f - f2, 1.0f, 1.0f);
        }
        return nArray;
    }

    public static int[] getCoolPalette() {
        return ColorLib.getCoolPalette(64);
    }

    public static int[] getHotPalette(int size) {
        int[] nArray = new int[size];
        for (int i2 = 0; i2 < size; ++i2) {
            float f2;
            int n2 = 3 * size / 8;
            float f3 = f2 = i2 < n2 ? (float)(i2 + 1) / (float)n2 : 1.0f;
            float f4 = i2 < n2 ? 0.0f : (i2 < 2 * n2 ? (float)(i2 - n2) / (float)n2 : 1.0f);
            float f5 = i2 < 2 * n2 ? 0.0f : (float)(i2 - 2 * n2) / (float)(size - 2 * n2);
            nArray[i2] = ColorLib.rgba(f2, f4, f5, 1.0f);
        }
        return nArray;
    }

    public static int[] getHotPalette() {
        return ColorLib.getHotPalette(64);
    }

    public static int[] getCategoryPalette(int size, float s1, float s2, float b2, float a2) {
        int[] nArray = new int[size];
        float f2 = s1;
        for (int i2 = 0; i2 < size; ++i2) {
            int n2 = i2 % CATEGORY_HUES.length;
            if (n2 == 0) {
                f2 = s1 + (float)i2 / (float)size * (s2 - s1);
            }
            nArray[i2] = ColorLib.hsba(CATEGORY_HUES[n2], f2, b2, a2);
        }
        return nArray;
    }

    public static int[] getCategoryPalette(int size) {
        return ColorLib.getCategoryPalette(size, 1.0f, 0.4f, 1.0f, 1.0f);
    }

    public static int[] getHSBPalette(int size, float s2, float b2) {
        int[] nArray = new int[size];
        for (int i2 = 0; i2 < size; ++i2) {
            float f2 = (float)i2 / (float)(size - 1);
            nArray[i2] = ColorLib.hsb(f2, s2, b2);
        }
        return nArray;
    }

    public static int[] getHSBPalette() {
        return ColorLib.getHSBPalette(64, 1.0f, 1.0f);
    }

    public static int[] getInterpolatedPalette(int size, int c1, int c2) {
        int[] nArray = new int[size];
        for (int i2 = 0; i2 < size; ++i2) {
            float f2 = (float)i2 / (float)(size - 1);
            nArray[i2] = ColorLib.interp(c1, c2, f2);
        }
        return nArray;
    }

    /*
     * WARNING - void declaration
     */
    public static int[] getInterpolatedPalette(int c1, int c2) {
        void var1_1;
        int n2;
        return ColorLib.getInterpolatedPalette(64, n2, (int)var1_1);
    }

    public static int[] getGrayscalePalette(int size) {
        int[] nArray = new int[size];
        for (int i2 = 0; i2 < size; ++i2) {
            int n2 = Math.round(255.0f * (0.2f + 0.6f * (float)i2 / (float)(size - 1)));
            nArray[size - i2 - 1] = ColorLib.gray(n2);
        }
        return nArray;
    }

    public static int[] getGrayscalePalette() {
        return ColorLib.getGrayscalePalette(64);
    }
}

