/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.collections;

import prefuse.util.collections.PrimeFinder;

public abstract class AbstractHashMap {
    protected int distinct;
    protected int lowWaterMark;
    protected int highWaterMark;
    protected double minLoadFactor;
    protected double maxLoadFactor;
    protected static final int defaultCapacity = 277;
    protected static final double defaultMinLoadFactor = 0.2;
    protected static final double defaultMaxLoadFactor = 0.5;

    protected AbstractHashMap() {
    }

    /*
     * WARNING - void declaration
     */
    protected int chooseGrowCapacity(int size, double minLoad, double maxLoad) {
        void var2_2;
        void var1_1;
        return this.nextPrime(Math.max(size + 1, (int)((double)(4 * var1_1) / (var2_2 * 3.0 + maxLoad))));
    }

    /*
     * WARNING - void declaration
     */
    protected int chooseHighWaterMark(int capacity, double maxLoad) {
        void var2_2;
        void var1_1;
        return Math.min(capacity - 2, (int)((double)var1_1 * var2_2));
    }

    /*
     * WARNING - void declaration
     */
    protected int chooseLowWaterMark(int capacity, double minLoad) {
        void var2_2;
        return (int)((double)capacity * var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected int chooseMeanCapacity(int size, double minLoad, double maxLoad) {
        void var2_2;
        void var1_1;
        return this.nextPrime(Math.max(size + 1, (int)((double)(2 * var1_1) / (var2_2 + maxLoad))));
    }

    /*
     * WARNING - void declaration
     */
    protected int chooseShrinkCapacity(int size, double minLoad, double maxLoad) {
        void var2_2;
        void var1_1;
        return this.nextPrime(Math.max(size + 1, (int)((double)(4 * var1_1) / (var2_2 + maxLoad * 3.0))));
    }

    public abstract void clear();

    public void ensureCapacity(int minCapacity) {
    }

    public boolean isEmpty() {
        return this.distinct == 0;
    }

    protected int nextPrime(int desiredCapacity) {
        return PrimeFinder.nextPrime(desiredCapacity);
    }

    /*
     * WARNING - void declaration
     */
    protected void setUp(int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        if (initialCapacity < 0) {
            void var1_1;
            throw new IllegalArgumentException("Initial Capacity must not be less than zero: " + (int)var1_1);
        }
        if (minLoadFactor < 0.0 || minLoadFactor >= 1.0) {
            throw new IllegalArgumentException("Illegal minLoadFactor: " + minLoadFactor);
        }
        if (maxLoadFactor <= 0.0 || maxLoadFactor >= 1.0) {
            throw new IllegalArgumentException("Illegal maxLoadFactor: " + maxLoadFactor);
        }
        if (minLoadFactor >= maxLoadFactor) {
            void var2_2;
            throw new IllegalArgumentException("Illegal minLoadFactor: " + (double)var2_2 + " and maxLoadFactor: " + maxLoadFactor);
        }
    }

    public int size() {
        return this.distinct;
    }

    public void trimToSize() {
    }
}

